/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2.Catalog;
import com.google.cloud.retail.v2.CatalogServiceClient;
import com.google.cloud.retail.v2.GetDefaultBranchRequest;
import com.google.cloud.retail.v2.GetDefaultBranchResponse;
import com.google.cloud.retail.v2.ListCatalogsRequest;
import com.google.cloud.retail.v2.ListCatalogsResponse;
import com.google.cloud.retail.v2.SetDefaultBranchRequest;
import com.google.cloud.retail.v2.UpdateCatalogRequest;
import com.google.cloud.retail.v2.stub.CatalogServiceStub;
import com.google.cloud.retail.v2.stub.CatalogServiceStubSettings;
import com.google.cloud.retail.v2.stub.GrpcCatalogServiceCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcCatalogServiceStub
extends CatalogServiceStub {
    private static final MethodDescriptor<ListCatalogsRequest, ListCatalogsResponse> listCatalogsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2.CatalogService/ListCatalogs").setRequestMarshaller(ProtoUtils.marshaller((Message)ListCatalogsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListCatalogsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateCatalogRequest, Catalog> updateCatalogMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2.CatalogService/UpdateCatalog").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateCatalogRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Catalog.getDefaultInstance())).build();
    private static final MethodDescriptor<SetDefaultBranchRequest, Empty> setDefaultBranchMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2.CatalogService/SetDefaultBranch").setRequestMarshaller(ProtoUtils.marshaller((Message)SetDefaultBranchRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<GetDefaultBranchRequest, GetDefaultBranchResponse> getDefaultBranchMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2.CatalogService/GetDefaultBranch").setRequestMarshaller(ProtoUtils.marshaller((Message)GetDefaultBranchRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GetDefaultBranchResponse.getDefaultInstance())).build();
    private final UnaryCallable<ListCatalogsRequest, ListCatalogsResponse> listCatalogsCallable;
    private final UnaryCallable<ListCatalogsRequest, CatalogServiceClient.ListCatalogsPagedResponse> listCatalogsPagedCallable;
    private final UnaryCallable<UpdateCatalogRequest, Catalog> updateCatalogCallable;
    private final UnaryCallable<SetDefaultBranchRequest, Empty> setDefaultBranchCallable;
    private final UnaryCallable<GetDefaultBranchRequest, GetDefaultBranchResponse> getDefaultBranchCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcCatalogServiceStub create(CatalogServiceStubSettings settings) throws IOException {
        return new GrpcCatalogServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcCatalogServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcCatalogServiceStub(CatalogServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcCatalogServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcCatalogServiceStub(CatalogServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcCatalogServiceStub(CatalogServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcCatalogServiceCallableFactory());
    }

    protected GrpcCatalogServiceStub(CatalogServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listCatalogsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listCatalogsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings updateCatalogTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateCatalogMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"catalog.name", (Object)String.valueOf(request.getCatalog().getName()));
            return params.build();
        }).build();
        GrpcCallSettings setDefaultBranchTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setDefaultBranchMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"catalog", (Object)String.valueOf(request.getCatalog()));
            return params.build();
        }).build();
        GrpcCallSettings getDefaultBranchTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getDefaultBranchMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"catalog", (Object)String.valueOf(request.getCatalog()));
            return params.build();
        }).build();
        this.listCatalogsCallable = callableFactory.createUnaryCallable(listCatalogsTransportSettings, settings.listCatalogsSettings(), clientContext);
        this.listCatalogsPagedCallable = callableFactory.createPagedCallable(listCatalogsTransportSettings, settings.listCatalogsSettings(), clientContext);
        this.updateCatalogCallable = callableFactory.createUnaryCallable(updateCatalogTransportSettings, settings.updateCatalogSettings(), clientContext);
        this.setDefaultBranchCallable = callableFactory.createUnaryCallable(setDefaultBranchTransportSettings, settings.setDefaultBranchSettings(), clientContext);
        this.getDefaultBranchCallable = callableFactory.createUnaryCallable(getDefaultBranchTransportSettings, settings.getDefaultBranchSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListCatalogsRequest, ListCatalogsResponse> listCatalogsCallable() {
        return this.listCatalogsCallable;
    }

    @Override
    public UnaryCallable<ListCatalogsRequest, CatalogServiceClient.ListCatalogsPagedResponse> listCatalogsPagedCallable() {
        return this.listCatalogsPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateCatalogRequest, Catalog> updateCatalogCallable() {
        return this.updateCatalogCallable;
    }

    @Override
    public UnaryCallable<SetDefaultBranchRequest, Empty> setDefaultBranchCallable() {
        return this.setDefaultBranchCallable;
    }

    @Override
    public UnaryCallable<GetDefaultBranchRequest, GetDefaultBranchResponse> getDefaultBranchCallable() {
        return this.getDefaultBranchCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

