/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2.CreateProductRequest;
import com.google.cloud.retail.v2.DeleteProductRequest;
import com.google.cloud.retail.v2.GetProductRequest;
import com.google.cloud.retail.v2.ImportMetadata;
import com.google.cloud.retail.v2.ImportProductsRequest;
import com.google.cloud.retail.v2.ImportProductsResponse;
import com.google.cloud.retail.v2.Product;
import com.google.cloud.retail.v2.UpdateProductRequest;
import com.google.cloud.retail.v2.stub.GrpcProductServiceCallableFactory;
import com.google.cloud.retail.v2.stub.ProductServiceStub;
import com.google.cloud.retail.v2.stub.ProductServiceStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcProductServiceStub
extends ProductServiceStub {
    private static final MethodDescriptor<CreateProductRequest, Product> createProductMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2.ProductService/CreateProduct").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateProductRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Product.getDefaultInstance())).build();
    private static final MethodDescriptor<GetProductRequest, Product> getProductMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2.ProductService/GetProduct").setRequestMarshaller(ProtoUtils.marshaller((Message)GetProductRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Product.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateProductRequest, Product> updateProductMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2.ProductService/UpdateProduct").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateProductRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Product.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteProductRequest, Empty> deleteProductMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2.ProductService/DeleteProduct").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteProductRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ImportProductsRequest, Operation> importProductsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2.ProductService/ImportProducts").setRequestMarshaller(ProtoUtils.marshaller((Message)ImportProductsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<CreateProductRequest, Product> createProductCallable;
    private final UnaryCallable<GetProductRequest, Product> getProductCallable;
    private final UnaryCallable<UpdateProductRequest, Product> updateProductCallable;
    private final UnaryCallable<DeleteProductRequest, Empty> deleteProductCallable;
    private final UnaryCallable<ImportProductsRequest, Operation> importProductsCallable;
    private final OperationCallable<ImportProductsRequest, ImportProductsResponse, ImportMetadata> importProductsOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcProductServiceStub create(ProductServiceStubSettings settings) throws IOException {
        return new GrpcProductServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcProductServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcProductServiceStub(ProductServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcProductServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcProductServiceStub(ProductServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcProductServiceStub(ProductServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcProductServiceCallableFactory());
    }

    protected GrpcProductServiceStub(ProductServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createProductTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createProductMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CreateProductRequest>(){

            public Map<String, String> extract(CreateProductRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getProductTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getProductMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetProductRequest>(){

            public Map<String, String> extract(GetProductRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings updateProductTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateProductMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<UpdateProductRequest>(){

            public Map<String, String> extract(UpdateProductRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"product.name", (Object)String.valueOf(request.getProduct().getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deleteProductTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteProductMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeleteProductRequest>(){

            public Map<String, String> extract(DeleteProductRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings importProductsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(importProductsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ImportProductsRequest>(){

            public Map<String, String> extract(ImportProductsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        this.createProductCallable = callableFactory.createUnaryCallable(createProductTransportSettings, settings.createProductSettings(), clientContext);
        this.getProductCallable = callableFactory.createUnaryCallable(getProductTransportSettings, settings.getProductSettings(), clientContext);
        this.updateProductCallable = callableFactory.createUnaryCallable(updateProductTransportSettings, settings.updateProductSettings(), clientContext);
        this.deleteProductCallable = callableFactory.createUnaryCallable(deleteProductTransportSettings, settings.deleteProductSettings(), clientContext);
        this.importProductsCallable = callableFactory.createUnaryCallable(importProductsTransportSettings, settings.importProductsSettings(), clientContext);
        this.importProductsOperationCallable = callableFactory.createOperationCallable(importProductsTransportSettings, settings.importProductsOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateProductRequest, Product> createProductCallable() {
        return this.createProductCallable;
    }

    @Override
    public UnaryCallable<GetProductRequest, Product> getProductCallable() {
        return this.getProductCallable;
    }

    @Override
    public UnaryCallable<UpdateProductRequest, Product> updateProductCallable() {
        return this.updateProductCallable;
    }

    @Override
    public UnaryCallable<DeleteProductRequest, Empty> deleteProductCallable() {
        return this.deleteProductCallable;
    }

    @Override
    public UnaryCallable<ImportProductsRequest, Operation> importProductsCallable() {
        return this.importProductsCallable;
    }

    @Override
    public OperationCallable<ImportProductsRequest, ImportProductsResponse, ImportMetadata> importProductsOperationCallable() {
        return this.importProductsOperationCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

