/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager.v3.stub;

import com.google.api.HttpRule;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.resourcemanager.v3.CreateFolderMetadata;
import com.google.cloud.resourcemanager.v3.CreateFolderRequest;
import com.google.cloud.resourcemanager.v3.DeleteFolderMetadata;
import com.google.cloud.resourcemanager.v3.DeleteFolderRequest;
import com.google.cloud.resourcemanager.v3.Folder;
import com.google.cloud.resourcemanager.v3.FoldersClient;
import com.google.cloud.resourcemanager.v3.GetFolderRequest;
import com.google.cloud.resourcemanager.v3.ListFoldersRequest;
import com.google.cloud.resourcemanager.v3.ListFoldersResponse;
import com.google.cloud.resourcemanager.v3.MoveFolderMetadata;
import com.google.cloud.resourcemanager.v3.MoveFolderRequest;
import com.google.cloud.resourcemanager.v3.SearchFoldersRequest;
import com.google.cloud.resourcemanager.v3.SearchFoldersResponse;
import com.google.cloud.resourcemanager.v3.UndeleteFolderMetadata;
import com.google.cloud.resourcemanager.v3.UndeleteFolderRequest;
import com.google.cloud.resourcemanager.v3.UpdateFolderMetadata;
import com.google.cloud.resourcemanager.v3.UpdateFolderRequest;
import com.google.cloud.resourcemanager.v3.stub.FoldersStub;
import com.google.cloud.resourcemanager.v3.stub.FoldersStubSettings;
import com.google.cloud.resourcemanager.v3.stub.HttpJsonFoldersCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HttpJsonFoldersStub
extends FoldersStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(UndeleteFolderMetadata.getDescriptor()).add(Folder.getDescriptor()).add(UpdateFolderMetadata.getDescriptor()).add(DeleteFolderMetadata.getDescriptor()).add(MoveFolderMetadata.getDescriptor()).add(CreateFolderMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<GetFolderRequest, Folder> getFolderMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.Folders/GetFolder").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{name=folders/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Folder.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListFoldersRequest, ListFoldersResponse> listFoldersMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.Folders/ListFolders").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/folders", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "parent", (Object)request.getParent());
        serializer.putQueryParam(fields, "showDeleted", (Object)request.getShowDeleted());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListFoldersResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SearchFoldersRequest, SearchFoldersResponse> searchFoldersMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.Folders/SearchFolders").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/folders:search", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "query", (Object)request.getQuery());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SearchFoldersResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateFolderRequest, Operation> createFolderMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.Folders/CreateFolder").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/folders", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("folder", (Message)request.getFolder(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateFolderRequest, Operation> updateFolderMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.Folders/UpdateFolder").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{folder.name=folders/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "folder.name", (Object)request.getFolder().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("folder", (Message)request.getFolder(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<MoveFolderRequest, Operation> moveFolderMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.Folders/MoveFolder").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{name=folders/*}:move", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteFolderRequest, Operation> deleteFolderMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.Folders/DeleteFolder").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{name=folders/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UndeleteFolderRequest, Operation> undeleteFolderMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.Folders/UndeleteFolder").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{name=folders/*}:undelete", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.Folders/GetIamPolicy").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{resource=folders/*}:getIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.Folders/SetIamPolicy").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{resource=folders/*}:setIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.Folders/TestIamPermissions").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{resource=folders/*}:testIamPermissions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TestIamPermissionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<GetFolderRequest, Folder> getFolderCallable;
    private final UnaryCallable<ListFoldersRequest, ListFoldersResponse> listFoldersCallable;
    private final UnaryCallable<ListFoldersRequest, FoldersClient.ListFoldersPagedResponse> listFoldersPagedCallable;
    private final UnaryCallable<SearchFoldersRequest, SearchFoldersResponse> searchFoldersCallable;
    private final UnaryCallable<SearchFoldersRequest, FoldersClient.SearchFoldersPagedResponse> searchFoldersPagedCallable;
    private final UnaryCallable<CreateFolderRequest, Operation> createFolderCallable;
    private final OperationCallable<CreateFolderRequest, Folder, CreateFolderMetadata> createFolderOperationCallable;
    private final UnaryCallable<UpdateFolderRequest, Operation> updateFolderCallable;
    private final OperationCallable<UpdateFolderRequest, Folder, UpdateFolderMetadata> updateFolderOperationCallable;
    private final UnaryCallable<MoveFolderRequest, Operation> moveFolderCallable;
    private final OperationCallable<MoveFolderRequest, Folder, MoveFolderMetadata> moveFolderOperationCallable;
    private final UnaryCallable<DeleteFolderRequest, Operation> deleteFolderCallable;
    private final OperationCallable<DeleteFolderRequest, Folder, DeleteFolderMetadata> deleteFolderOperationCallable;
    private final UnaryCallable<UndeleteFolderRequest, Operation> undeleteFolderCallable;
    private final OperationCallable<UndeleteFolderRequest, Folder, UndeleteFolderMetadata> undeleteFolderOperationCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonFoldersStub create(FoldersStubSettings settings) throws IOException {
        return new HttpJsonFoldersStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonFoldersStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonFoldersStub(FoldersStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonFoldersStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonFoldersStub(FoldersStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonFoldersStub(FoldersStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonFoldersCallableFactory());
    }

    protected HttpJsonFoldersStub(FoldersStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v3/{name=operations/**}").build()).build());
        HttpJsonCallSettings getFolderTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getFolderMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listFoldersTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listFoldersMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings searchFoldersTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(searchFoldersMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createFolderTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createFolderMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateFolderTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateFolderMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("folder.name", String.valueOf(request.getFolder().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings moveFolderTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(moveFolderMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteFolderTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteFolderMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings undeleteFolderTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(undeleteFolderMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        HttpJsonCallSettings setIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        HttpJsonCallSettings testIamPermissionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.getFolderCallable = callableFactory.createUnaryCallable(getFolderTransportSettings, settings.getFolderSettings(), clientContext);
        this.listFoldersCallable = callableFactory.createUnaryCallable(listFoldersTransportSettings, settings.listFoldersSettings(), clientContext);
        this.listFoldersPagedCallable = callableFactory.createPagedCallable(listFoldersTransportSettings, settings.listFoldersSettings(), clientContext);
        this.searchFoldersCallable = callableFactory.createUnaryCallable(searchFoldersTransportSettings, settings.searchFoldersSettings(), clientContext);
        this.searchFoldersPagedCallable = callableFactory.createPagedCallable(searchFoldersTransportSettings, settings.searchFoldersSettings(), clientContext);
        this.createFolderCallable = callableFactory.createUnaryCallable(createFolderTransportSettings, settings.createFolderSettings(), clientContext);
        this.createFolderOperationCallable = callableFactory.createOperationCallable(createFolderTransportSettings, settings.createFolderOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateFolderCallable = callableFactory.createUnaryCallable(updateFolderTransportSettings, settings.updateFolderSettings(), clientContext);
        this.updateFolderOperationCallable = callableFactory.createOperationCallable(updateFolderTransportSettings, settings.updateFolderOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.moveFolderCallable = callableFactory.createUnaryCallable(moveFolderTransportSettings, settings.moveFolderSettings(), clientContext);
        this.moveFolderOperationCallable = callableFactory.createOperationCallable(moveFolderTransportSettings, settings.moveFolderOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteFolderCallable = callableFactory.createUnaryCallable(deleteFolderTransportSettings, settings.deleteFolderSettings(), clientContext);
        this.deleteFolderOperationCallable = callableFactory.createOperationCallable(deleteFolderTransportSettings, settings.deleteFolderOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.undeleteFolderCallable = callableFactory.createUnaryCallable(undeleteFolderTransportSettings, settings.undeleteFolderSettings(), clientContext);
        this.undeleteFolderOperationCallable = callableFactory.createOperationCallable(undeleteFolderTransportSettings, settings.undeleteFolderOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getFolderMethodDescriptor);
        methodDescriptors.add(listFoldersMethodDescriptor);
        methodDescriptors.add(searchFoldersMethodDescriptor);
        methodDescriptors.add(createFolderMethodDescriptor);
        methodDescriptors.add(updateFolderMethodDescriptor);
        methodDescriptors.add(moveFolderMethodDescriptor);
        methodDescriptors.add(deleteFolderMethodDescriptor);
        methodDescriptors.add(undeleteFolderMethodDescriptor);
        methodDescriptors.add(getIamPolicyMethodDescriptor);
        methodDescriptors.add(setIamPolicyMethodDescriptor);
        methodDescriptors.add(testIamPermissionsMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<GetFolderRequest, Folder> getFolderCallable() {
        return this.getFolderCallable;
    }

    @Override
    public UnaryCallable<ListFoldersRequest, ListFoldersResponse> listFoldersCallable() {
        return this.listFoldersCallable;
    }

    @Override
    public UnaryCallable<ListFoldersRequest, FoldersClient.ListFoldersPagedResponse> listFoldersPagedCallable() {
        return this.listFoldersPagedCallable;
    }

    @Override
    public UnaryCallable<SearchFoldersRequest, SearchFoldersResponse> searchFoldersCallable() {
        return this.searchFoldersCallable;
    }

    @Override
    public UnaryCallable<SearchFoldersRequest, FoldersClient.SearchFoldersPagedResponse> searchFoldersPagedCallable() {
        return this.searchFoldersPagedCallable;
    }

    @Override
    public UnaryCallable<CreateFolderRequest, Operation> createFolderCallable() {
        return this.createFolderCallable;
    }

    @Override
    public OperationCallable<CreateFolderRequest, Folder, CreateFolderMetadata> createFolderOperationCallable() {
        return this.createFolderOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateFolderRequest, Operation> updateFolderCallable() {
        return this.updateFolderCallable;
    }

    @Override
    public OperationCallable<UpdateFolderRequest, Folder, UpdateFolderMetadata> updateFolderOperationCallable() {
        return this.updateFolderOperationCallable;
    }

    @Override
    public UnaryCallable<MoveFolderRequest, Operation> moveFolderCallable() {
        return this.moveFolderCallable;
    }

    @Override
    public OperationCallable<MoveFolderRequest, Folder, MoveFolderMetadata> moveFolderOperationCallable() {
        return this.moveFolderOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteFolderRequest, Operation> deleteFolderCallable() {
        return this.deleteFolderCallable;
    }

    @Override
    public OperationCallable<DeleteFolderRequest, Folder, DeleteFolderMetadata> deleteFolderOperationCallable() {
        return this.deleteFolderOperationCallable;
    }

    @Override
    public UnaryCallable<UndeleteFolderRequest, Operation> undeleteFolderCallable() {
        return this.undeleteFolderCallable;
    }

    @Override
    public OperationCallable<UndeleteFolderRequest, Folder, UndeleteFolderMetadata> undeleteFolderOperationCallable() {
        return this.undeleteFolderOperationCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

