/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager.v3.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.resourcemanager.v3.CreateFolderMetadata;
import com.google.cloud.resourcemanager.v3.CreateFolderRequest;
import com.google.cloud.resourcemanager.v3.DeleteFolderMetadata;
import com.google.cloud.resourcemanager.v3.DeleteFolderRequest;
import com.google.cloud.resourcemanager.v3.Folder;
import com.google.cloud.resourcemanager.v3.FoldersClient;
import com.google.cloud.resourcemanager.v3.GetFolderRequest;
import com.google.cloud.resourcemanager.v3.ListFoldersRequest;
import com.google.cloud.resourcemanager.v3.ListFoldersResponse;
import com.google.cloud.resourcemanager.v3.MoveFolderMetadata;
import com.google.cloud.resourcemanager.v3.MoveFolderRequest;
import com.google.cloud.resourcemanager.v3.SearchFoldersRequest;
import com.google.cloud.resourcemanager.v3.SearchFoldersResponse;
import com.google.cloud.resourcemanager.v3.UndeleteFolderMetadata;
import com.google.cloud.resourcemanager.v3.UndeleteFolderRequest;
import com.google.cloud.resourcemanager.v3.UpdateFolderMetadata;
import com.google.cloud.resourcemanager.v3.UpdateFolderRequest;
import com.google.cloud.resourcemanager.v3.stub.FoldersStub;
import com.google.cloud.resourcemanager.v3.stub.GrpcFoldersStub;
import com.google.cloud.resourcemanager.v3.stub.HttpJsonFoldersStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class FoldersStubSettings
extends StubSettings<FoldersStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").build();
    private final UnaryCallSettings<GetFolderRequest, Folder> getFolderSettings;
    private final PagedCallSettings<ListFoldersRequest, ListFoldersResponse, FoldersClient.ListFoldersPagedResponse> listFoldersSettings;
    private final PagedCallSettings<SearchFoldersRequest, SearchFoldersResponse, FoldersClient.SearchFoldersPagedResponse> searchFoldersSettings;
    private final UnaryCallSettings<CreateFolderRequest, Operation> createFolderSettings;
    private final OperationCallSettings<CreateFolderRequest, Folder, CreateFolderMetadata> createFolderOperationSettings;
    private final UnaryCallSettings<UpdateFolderRequest, Operation> updateFolderSettings;
    private final OperationCallSettings<UpdateFolderRequest, Folder, UpdateFolderMetadata> updateFolderOperationSettings;
    private final UnaryCallSettings<MoveFolderRequest, Operation> moveFolderSettings;
    private final OperationCallSettings<MoveFolderRequest, Folder, MoveFolderMetadata> moveFolderOperationSettings;
    private final UnaryCallSettings<DeleteFolderRequest, Operation> deleteFolderSettings;
    private final OperationCallSettings<DeleteFolderRequest, Folder, DeleteFolderMetadata> deleteFolderOperationSettings;
    private final UnaryCallSettings<UndeleteFolderRequest, Operation> undeleteFolderSettings;
    private final OperationCallSettings<UndeleteFolderRequest, Folder, UndeleteFolderMetadata> undeleteFolderOperationSettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListFoldersRequest, ListFoldersResponse, Folder> LIST_FOLDERS_PAGE_STR_DESC = new PagedListDescriptor<ListFoldersRequest, ListFoldersResponse, Folder>(){

        public String emptyToken() {
            return "";
        }

        public ListFoldersRequest injectToken(ListFoldersRequest payload, String token) {
            return ListFoldersRequest.newBuilder((ListFoldersRequest)payload).setPageToken(token).build();
        }

        public ListFoldersRequest injectPageSize(ListFoldersRequest payload, int pageSize) {
            return ListFoldersRequest.newBuilder((ListFoldersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListFoldersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListFoldersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Folder> extractResources(ListFoldersResponse payload) {
            return payload.getFoldersList() == null ? ImmutableList.of() : payload.getFoldersList();
        }
    };
    private static final PagedListDescriptor<SearchFoldersRequest, SearchFoldersResponse, Folder> SEARCH_FOLDERS_PAGE_STR_DESC = new PagedListDescriptor<SearchFoldersRequest, SearchFoldersResponse, Folder>(){

        public String emptyToken() {
            return "";
        }

        public SearchFoldersRequest injectToken(SearchFoldersRequest payload, String token) {
            return SearchFoldersRequest.newBuilder((SearchFoldersRequest)payload).setPageToken(token).build();
        }

        public SearchFoldersRequest injectPageSize(SearchFoldersRequest payload, int pageSize) {
            return SearchFoldersRequest.newBuilder((SearchFoldersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchFoldersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchFoldersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Folder> extractResources(SearchFoldersResponse payload) {
            return payload.getFoldersList() == null ? ImmutableList.of() : payload.getFoldersList();
        }
    };
    private static final PagedListResponseFactory<ListFoldersRequest, ListFoldersResponse, FoldersClient.ListFoldersPagedResponse> LIST_FOLDERS_PAGE_STR_FACT = new PagedListResponseFactory<ListFoldersRequest, ListFoldersResponse, FoldersClient.ListFoldersPagedResponse>(){

        public ApiFuture<FoldersClient.ListFoldersPagedResponse> getFuturePagedResponse(UnaryCallable<ListFoldersRequest, ListFoldersResponse> callable, ListFoldersRequest request, ApiCallContext context, ApiFuture<ListFoldersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_FOLDERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return FoldersClient.ListFoldersPagedResponse.createAsync((PageContext<ListFoldersRequest, ListFoldersResponse, Folder>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<SearchFoldersRequest, SearchFoldersResponse, FoldersClient.SearchFoldersPagedResponse> SEARCH_FOLDERS_PAGE_STR_FACT = new PagedListResponseFactory<SearchFoldersRequest, SearchFoldersResponse, FoldersClient.SearchFoldersPagedResponse>(){

        public ApiFuture<FoldersClient.SearchFoldersPagedResponse> getFuturePagedResponse(UnaryCallable<SearchFoldersRequest, SearchFoldersResponse> callable, SearchFoldersRequest request, ApiCallContext context, ApiFuture<SearchFoldersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_FOLDERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return FoldersClient.SearchFoldersPagedResponse.createAsync((PageContext<SearchFoldersRequest, SearchFoldersResponse, Folder>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetFolderRequest, Folder> getFolderSettings() {
        return this.getFolderSettings;
    }

    public PagedCallSettings<ListFoldersRequest, ListFoldersResponse, FoldersClient.ListFoldersPagedResponse> listFoldersSettings() {
        return this.listFoldersSettings;
    }

    public PagedCallSettings<SearchFoldersRequest, SearchFoldersResponse, FoldersClient.SearchFoldersPagedResponse> searchFoldersSettings() {
        return this.searchFoldersSettings;
    }

    public UnaryCallSettings<CreateFolderRequest, Operation> createFolderSettings() {
        return this.createFolderSettings;
    }

    public OperationCallSettings<CreateFolderRequest, Folder, CreateFolderMetadata> createFolderOperationSettings() {
        return this.createFolderOperationSettings;
    }

    public UnaryCallSettings<UpdateFolderRequest, Operation> updateFolderSettings() {
        return this.updateFolderSettings;
    }

    public OperationCallSettings<UpdateFolderRequest, Folder, UpdateFolderMetadata> updateFolderOperationSettings() {
        return this.updateFolderOperationSettings;
    }

    public UnaryCallSettings<MoveFolderRequest, Operation> moveFolderSettings() {
        return this.moveFolderSettings;
    }

    public OperationCallSettings<MoveFolderRequest, Folder, MoveFolderMetadata> moveFolderOperationSettings() {
        return this.moveFolderOperationSettings;
    }

    public UnaryCallSettings<DeleteFolderRequest, Operation> deleteFolderSettings() {
        return this.deleteFolderSettings;
    }

    public OperationCallSettings<DeleteFolderRequest, Folder, DeleteFolderMetadata> deleteFolderOperationSettings() {
        return this.deleteFolderOperationSettings;
    }

    public UnaryCallSettings<UndeleteFolderRequest, Operation> undeleteFolderSettings() {
        return this.undeleteFolderSettings;
    }

    public OperationCallSettings<UndeleteFolderRequest, Folder, UndeleteFolderMetadata> undeleteFolderOperationSettings() {
        return this.undeleteFolderOperationSettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public FoldersStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcFoldersStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonFoldersStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "cloudresourcemanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "cloudresourcemanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudresourcemanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return FoldersStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(FoldersStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(FoldersStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return FoldersStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected FoldersStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getFolderSettings = settingsBuilder.getFolderSettings().build();
        this.listFoldersSettings = settingsBuilder.listFoldersSettings().build();
        this.searchFoldersSettings = settingsBuilder.searchFoldersSettings().build();
        this.createFolderSettings = settingsBuilder.createFolderSettings().build();
        this.createFolderOperationSettings = settingsBuilder.createFolderOperationSettings().build();
        this.updateFolderSettings = settingsBuilder.updateFolderSettings().build();
        this.updateFolderOperationSettings = settingsBuilder.updateFolderOperationSettings().build();
        this.moveFolderSettings = settingsBuilder.moveFolderSettings().build();
        this.moveFolderOperationSettings = settingsBuilder.moveFolderOperationSettings().build();
        this.deleteFolderSettings = settingsBuilder.deleteFolderSettings().build();
        this.deleteFolderOperationSettings = settingsBuilder.deleteFolderOperationSettings().build();
        this.undeleteFolderSettings = settingsBuilder.undeleteFolderSettings().build();
        this.undeleteFolderOperationSettings = settingsBuilder.undeleteFolderOperationSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<FoldersStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetFolderRequest, Folder> getFolderSettings;
        private final PagedCallSettings.Builder<ListFoldersRequest, ListFoldersResponse, FoldersClient.ListFoldersPagedResponse> listFoldersSettings;
        private final PagedCallSettings.Builder<SearchFoldersRequest, SearchFoldersResponse, FoldersClient.SearchFoldersPagedResponse> searchFoldersSettings;
        private final UnaryCallSettings.Builder<CreateFolderRequest, Operation> createFolderSettings;
        private final OperationCallSettings.Builder<CreateFolderRequest, Folder, CreateFolderMetadata> createFolderOperationSettings;
        private final UnaryCallSettings.Builder<UpdateFolderRequest, Operation> updateFolderSettings;
        private final OperationCallSettings.Builder<UpdateFolderRequest, Folder, UpdateFolderMetadata> updateFolderOperationSettings;
        private final UnaryCallSettings.Builder<MoveFolderRequest, Operation> moveFolderSettings;
        private final OperationCallSettings.Builder<MoveFolderRequest, Folder, MoveFolderMetadata> moveFolderOperationSettings;
        private final UnaryCallSettings.Builder<DeleteFolderRequest, Operation> deleteFolderSettings;
        private final OperationCallSettings.Builder<DeleteFolderRequest, Folder, DeleteFolderMetadata> deleteFolderOperationSettings;
        private final UnaryCallSettings.Builder<UndeleteFolderRequest, Operation> undeleteFolderSettings;
        private final OperationCallSettings.Builder<UndeleteFolderRequest, Folder, UndeleteFolderMetadata> undeleteFolderOperationSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getFolderSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listFoldersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_FOLDERS_PAGE_STR_FACT);
            this.searchFoldersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_FOLDERS_PAGE_STR_FACT);
            this.createFolderSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createFolderOperationSettings = OperationCallSettings.newBuilder();
            this.updateFolderSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateFolderOperationSettings = OperationCallSettings.newBuilder();
            this.moveFolderSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.moveFolderOperationSettings = OperationCallSettings.newBuilder();
            this.deleteFolderSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteFolderOperationSettings = OperationCallSettings.newBuilder();
            this.undeleteFolderSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.undeleteFolderOperationSettings = OperationCallSettings.newBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getFolderSettings, this.listFoldersSettings, this.searchFoldersSettings, this.createFolderSettings, this.updateFolderSettings, this.moveFolderSettings, this.deleteFolderSettings, this.undeleteFolderSettings, this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(FoldersStubSettings settings) {
            super((StubSettings)settings);
            this.getFolderSettings = settings.getFolderSettings.toBuilder();
            this.listFoldersSettings = settings.listFoldersSettings.toBuilder();
            this.searchFoldersSettings = settings.searchFoldersSettings.toBuilder();
            this.createFolderSettings = settings.createFolderSettings.toBuilder();
            this.createFolderOperationSettings = settings.createFolderOperationSettings.toBuilder();
            this.updateFolderSettings = settings.updateFolderSettings.toBuilder();
            this.updateFolderOperationSettings = settings.updateFolderOperationSettings.toBuilder();
            this.moveFolderSettings = settings.moveFolderSettings.toBuilder();
            this.moveFolderOperationSettings = settings.moveFolderOperationSettings.toBuilder();
            this.deleteFolderSettings = settings.deleteFolderSettings.toBuilder();
            this.deleteFolderOperationSettings = settings.deleteFolderOperationSettings.toBuilder();
            this.undeleteFolderSettings = settings.undeleteFolderSettings.toBuilder();
            this.undeleteFolderOperationSettings = settings.undeleteFolderOperationSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getFolderSettings, this.listFoldersSettings, this.searchFoldersSettings, this.createFolderSettings, this.updateFolderSettings, this.moveFolderSettings, this.deleteFolderSettings, this.undeleteFolderSettings, this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(FoldersStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)FoldersStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)FoldersStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(FoldersStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)FoldersStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)FoldersStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)FoldersStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(FoldersStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getFolderSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listFoldersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.searchFoldersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createFolderSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateFolderSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.moveFolderSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteFolderSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.undeleteFolderSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createFolderOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Folder.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateFolderMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateFolderOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Folder.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpdateFolderMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.moveFolderOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Folder.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(MoveFolderMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteFolderOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Folder.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteFolderMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.undeleteFolderOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Folder.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UndeleteFolderMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetFolderRequest, Folder> getFolderSettings() {
            return this.getFolderSettings;
        }

        public PagedCallSettings.Builder<ListFoldersRequest, ListFoldersResponse, FoldersClient.ListFoldersPagedResponse> listFoldersSettings() {
            return this.listFoldersSettings;
        }

        public PagedCallSettings.Builder<SearchFoldersRequest, SearchFoldersResponse, FoldersClient.SearchFoldersPagedResponse> searchFoldersSettings() {
            return this.searchFoldersSettings;
        }

        public UnaryCallSettings.Builder<CreateFolderRequest, Operation> createFolderSettings() {
            return this.createFolderSettings;
        }

        public OperationCallSettings.Builder<CreateFolderRequest, Folder, CreateFolderMetadata> createFolderOperationSettings() {
            return this.createFolderOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateFolderRequest, Operation> updateFolderSettings() {
            return this.updateFolderSettings;
        }

        public OperationCallSettings.Builder<UpdateFolderRequest, Folder, UpdateFolderMetadata> updateFolderOperationSettings() {
            return this.updateFolderOperationSettings;
        }

        public UnaryCallSettings.Builder<MoveFolderRequest, Operation> moveFolderSettings() {
            return this.moveFolderSettings;
        }

        public OperationCallSettings.Builder<MoveFolderRequest, Folder, MoveFolderMetadata> moveFolderOperationSettings() {
            return this.moveFolderOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteFolderRequest, Operation> deleteFolderSettings() {
            return this.deleteFolderSettings;
        }

        public OperationCallSettings.Builder<DeleteFolderRequest, Folder, DeleteFolderMetadata> deleteFolderOperationSettings() {
            return this.deleteFolderOperationSettings;
        }

        public UnaryCallSettings.Builder<UndeleteFolderRequest, Operation> undeleteFolderSettings() {
            return this.undeleteFolderSettings;
        }

        public OperationCallSettings.Builder<UndeleteFolderRequest, Folder, UndeleteFolderMetadata> undeleteFolderOperationSettings() {
            return this.undeleteFolderOperationSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public FoldersStubSettings build() throws IOException {
            return new FoldersStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

