/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager;

import com.google.api.core.ApiClock;
import com.google.api.gax.paging.Page;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.services.cloudresourcemanager.model.Constraint;
import com.google.api.services.cloudresourcemanager.model.OrgPolicy;
import com.google.cloud.BaseService;
import com.google.cloud.PageImpl;
import com.google.cloud.Policy;
import com.google.cloud.RetryHelper;
import com.google.cloud.ServiceOptions;
import com.google.cloud.Tuple;
import com.google.cloud.resourcemanager.ConstraintInfo;
import com.google.cloud.resourcemanager.Option;
import com.google.cloud.resourcemanager.OrgPolicyInfo;
import com.google.cloud.resourcemanager.PolicyMarshaller;
import com.google.cloud.resourcemanager.Project;
import com.google.cloud.resourcemanager.ProjectInfo;
import com.google.cloud.resourcemanager.ResourceManager;
import com.google.cloud.resourcemanager.ResourceManagerException;
import com.google.cloud.resourcemanager.ResourceManagerOptions;
import com.google.cloud.resourcemanager.spi.v1beta1.ResourceManagerRpc;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

@Deprecated
final class ResourceManagerImpl
extends BaseService<ResourceManagerOptions>
implements ResourceManager {
    private final ResourceManagerRpc resourceManagerRpc;

    ResourceManagerImpl(ResourceManagerOptions options) {
        super((ServiceOptions)options);
        this.resourceManagerRpc = options.getResourceManagerRpcV1Beta1();
    }

    @Override
    public Project create(final ProjectInfo project) {
        try {
            return Project.fromPb(this, (com.google.api.services.cloudresourcemanager.model.Project)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.cloudresourcemanager.model.Project>(){

                @Override
                public com.google.api.services.cloudresourcemanager.model.Project call() {
                    return ResourceManagerImpl.this.resourceManagerRpc.create(project.toPb());
                }
            }, (RetrySettings)((ResourceManagerOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ResourceManagerOptions)this.getOptions()).getClock()));
        }
        catch (RetryHelper.RetryHelperException ex) {
            throw ResourceManagerException.translateAndThrow(ex);
        }
    }

    @Override
    public void delete(final String projectId) {
        try {
            RetryHelper.runWithRetries((Callable)new Callable<Void>(){

                @Override
                public Void call() {
                    ResourceManagerImpl.this.resourceManagerRpc.delete(projectId);
                    return null;
                }
            }, (RetrySettings)((ResourceManagerOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ResourceManagerOptions)this.getOptions()).getClock());
        }
        catch (RetryHelper.RetryHelperException ex) {
            throw ResourceManagerException.translateAndThrow(ex);
        }
    }

    @Override
    public Project get(final String projectId, ResourceManager.ProjectGetOption ... options) {
        final Map<ResourceManagerRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.cloudresourcemanager.model.Project answer = (com.google.api.services.cloudresourcemanager.model.Project)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.cloudresourcemanager.model.Project>(){

                @Override
                public com.google.api.services.cloudresourcemanager.model.Project call() {
                    return ResourceManagerImpl.this.resourceManagerRpc.get(projectId, optionsMap);
                }
            }, (RetrySettings)((ResourceManagerOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ResourceManagerOptions)this.getOptions()).getClock());
            return answer == null ? null : Project.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException ex) {
            throw ResourceManagerException.translateAndThrow(ex);
        }
    }

    @Override
    public Page<Project> list(ResourceManager.ProjectListOption ... options) {
        return ResourceManagerImpl.listProjects((ResourceManagerOptions)this.getOptions(), this.optionMap(options));
    }

    private static Page<Project> listProjects(final ResourceManagerOptions serviceOptions, final Map<ResourceManagerRpc.Option, ?> optionsMap) {
        try {
            Tuple result = (Tuple)RetryHelper.runWithRetries((Callable)new Callable<Tuple<String, Iterable<com.google.api.services.cloudresourcemanager.model.Project>>>(){

                @Override
                public Tuple<String, Iterable<com.google.api.services.cloudresourcemanager.model.Project>> call() {
                    return serviceOptions.getResourceManagerRpcV1Beta1().list(optionsMap);
                }
            }, (RetrySettings)serviceOptions.getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
            String cursor = (String)result.x();
            ImmutableList projects = result.y() == null ? ImmutableList.of() : Iterables.transform((Iterable)((Iterable)result.y()), (Function)new Function<com.google.api.services.cloudresourcemanager.model.Project, Project>(){

                public Project apply(com.google.api.services.cloudresourcemanager.model.Project projectPb) {
                    return new Project((ResourceManager)serviceOptions.getService(), new ProjectInfo.BuilderImpl(ProjectInfo.fromPb(projectPb)));
                }
            });
            return new PageImpl((PageImpl.NextPageFetcher)new ProjectPageFetcher(serviceOptions, cursor, optionsMap), cursor, (Iterable)projects);
        }
        catch (RetryHelper.RetryHelperException ex) {
            throw ResourceManagerException.translateAndThrow(ex);
        }
    }

    @Override
    public Project replace(final ProjectInfo newProject) {
        try {
            return Project.fromPb(this, (com.google.api.services.cloudresourcemanager.model.Project)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.cloudresourcemanager.model.Project>(){

                @Override
                public com.google.api.services.cloudresourcemanager.model.Project call() {
                    return ResourceManagerImpl.this.resourceManagerRpc.replace(newProject.toPb());
                }
            }, (RetrySettings)((ResourceManagerOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ResourceManagerOptions)this.getOptions()).getClock()));
        }
        catch (RetryHelper.RetryHelperException ex) {
            throw ResourceManagerException.translateAndThrow(ex);
        }
    }

    @Override
    public void undelete(final String projectId) {
        try {
            RetryHelper.runWithRetries((Callable)new Callable<Void>(){

                @Override
                public Void call() {
                    ResourceManagerImpl.this.resourceManagerRpc.undelete(projectId);
                    return null;
                }
            }, (RetrySettings)((ResourceManagerOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ResourceManagerOptions)this.getOptions()).getClock());
        }
        catch (RetryHelper.RetryHelperException ex) {
            throw ResourceManagerException.translateAndThrow(ex);
        }
    }

    @Override
    public Policy getPolicy(final String projectId) {
        try {
            com.google.api.services.cloudresourcemanager.model.Policy answer = (com.google.api.services.cloudresourcemanager.model.Policy)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.cloudresourcemanager.model.Policy>(){

                @Override
                public com.google.api.services.cloudresourcemanager.model.Policy call() {
                    return ResourceManagerImpl.this.resourceManagerRpc.getPolicy(projectId);
                }
            }, (RetrySettings)((ResourceManagerOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ResourceManagerOptions)this.getOptions()).getClock());
            return answer == null ? null : PolicyMarshaller.INSTANCE.fromPb(answer);
        }
        catch (RetryHelper.RetryHelperException ex) {
            throw ResourceManagerException.translateAndThrow(ex);
        }
    }

    @Override
    public Policy replacePolicy(final String projectId, final Policy newPolicy) {
        try {
            return PolicyMarshaller.INSTANCE.fromPb((com.google.api.services.cloudresourcemanager.model.Policy)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.cloudresourcemanager.model.Policy>(){

                @Override
                public com.google.api.services.cloudresourcemanager.model.Policy call() {
                    return ResourceManagerImpl.this.resourceManagerRpc.replacePolicy(projectId, PolicyMarshaller.INSTANCE.toPb(newPolicy));
                }
            }, (RetrySettings)((ResourceManagerOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ResourceManagerOptions)this.getOptions()).getClock()));
        }
        catch (RetryHelper.RetryHelperException ex) {
            throw ResourceManagerException.translateAndThrow(ex);
        }
    }

    @Override
    public List<Boolean> testPermissions(final String projectId, final List<String> permissions) {
        try {
            return (List)RetryHelper.runWithRetries((Callable)new Callable<List<Boolean>>(){

                @Override
                public List<Boolean> call() {
                    return ResourceManagerImpl.this.resourceManagerRpc.testPermissions(projectId, permissions);
                }
            }, (RetrySettings)((ResourceManagerOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ResourceManagerOptions)this.getOptions()).getClock());
        }
        catch (RetryHelper.RetryHelperException ex) {
            throw ResourceManagerException.translateAndThrow(ex);
        }
    }

    @Override
    public Map<String, Boolean> testOrgPermissions(final String resource, final List<String> permissions) {
        try {
            return (Map)RetryHelper.runWithRetries((Callable)new Callable<Map<String, Boolean>>(){

                @Override
                public Map<String, Boolean> call() throws IOException {
                    return ResourceManagerImpl.this.resourceManagerRpc.testOrgPermissions(resource, permissions);
                }
            }, (RetrySettings)((ResourceManagerOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ResourceManagerOptions)this.getOptions()).getClock());
        }
        catch (RetryHelper.RetryHelperException ex) {
            throw ResourceManagerException.translateAndThrow(ex);
        }
    }

    @Override
    public void clearOrgPolicy(final String resource, final OrgPolicyInfo orgPolicy) {
        try {
            RetryHelper.runWithRetries((Callable)new Callable<Void>(){

                @Override
                public Void call() throws IOException {
                    ResourceManagerImpl.this.resourceManagerRpc.clearOrgPolicy(resource, orgPolicy.toProtobuf());
                    return null;
                }
            }, (RetrySettings)((ResourceManagerOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ResourceManagerOptions)this.getOptions()).getClock());
        }
        catch (RetryHelper.RetryHelperException ex) {
            throw ResourceManagerException.translateAndThrow(ex);
        }
    }

    @Override
    public OrgPolicyInfo getEffectiveOrgPolicy(final String resource, final String constraint) {
        try {
            return OrgPolicyInfo.fromProtobuf((OrgPolicy)RetryHelper.runWithRetries((Callable)new Callable<OrgPolicy>(){

                @Override
                public OrgPolicy call() throws IOException {
                    return ResourceManagerImpl.this.resourceManagerRpc.getEffectiveOrgPolicy(resource, constraint);
                }
            }, (RetrySettings)((ResourceManagerOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ResourceManagerOptions)this.getOptions()).getClock()));
        }
        catch (RetryHelper.RetryHelperException ex) {
            throw ResourceManagerException.translateAndThrow(ex);
        }
    }

    @Override
    public OrgPolicyInfo getOrgPolicy(final String resource, final String constraint) {
        try {
            return OrgPolicyInfo.fromProtobuf((OrgPolicy)RetryHelper.runWithRetries((Callable)new Callable<OrgPolicy>(){

                @Override
                public OrgPolicy call() throws IOException {
                    return ResourceManagerImpl.this.resourceManagerRpc.getOrgPolicy(resource, constraint);
                }
            }, (RetrySettings)((ResourceManagerOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ResourceManagerOptions)this.getOptions()).getClock()));
        }
        catch (RetryHelper.RetryHelperException ex) {
            throw ResourceManagerException.translateAndThrow(ex);
        }
    }

    @Override
    public Page<ConstraintInfo> listAvailableOrgPolicyConstraints(String resource, ResourceManager.ListOption ... options) {
        return ResourceManagerImpl.listAvailableOrgPolicyConstraints(resource, (ResourceManagerOptions)this.getOptions(), this.optionMap(options));
    }

    private static Page<ConstraintInfo> listAvailableOrgPolicyConstraints(final String resource, ResourceManagerOptions serviceOptions, final Map<ResourceManagerRpc.Option, ?> optionsMap) {
        try {
            final ResourceManagerRpc rpc = serviceOptions.getResourceManagerRpcV1Beta1();
            ResourceManagerRpc.ListResult constraintList = (ResourceManagerRpc.ListResult)RetryHelper.runWithRetries((Callable)new Callable<ResourceManagerRpc.ListResult<Constraint>>(){

                @Override
                public ResourceManagerRpc.ListResult<Constraint> call() throws IOException {
                    return rpc.listAvailableOrgPolicyConstraints(resource, optionsMap);
                }
            }, (RetrySettings)serviceOptions.getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
            String cursor = constraintList.pageToken();
            ImmutableList constraints = constraintList.results() == null ? ImmutableList.of() : Iterables.transform(constraintList.results(), ConstraintInfo.FROM_PROTOBUF_FUNCTION);
            return new PageImpl((PageImpl.NextPageFetcher)new ConstraintPageFetcher(resource, serviceOptions, cursor, optionsMap), cursor, (Iterable)constraints);
        }
        catch (RetryHelper.RetryHelperException ex) {
            throw ResourceManagerException.translateAndThrow(ex);
        }
    }

    @Override
    public Page<OrgPolicyInfo> listOrgPolicies(String resource, ResourceManager.ListOption ... options) {
        return ResourceManagerImpl.listOrgPolicies(resource, (ResourceManagerOptions)this.getOptions(), this.optionMap(options));
    }

    private static PageImpl<OrgPolicyInfo> listOrgPolicies(final String resource, ResourceManagerOptions serviceOptions, final Map<ResourceManagerRpc.Option, ?> optionsMap) {
        try {
            final ResourceManagerRpc rpc = serviceOptions.getResourceManagerRpcV1Beta1();
            ResourceManagerRpc.ListResult orgPolicy = (ResourceManagerRpc.ListResult)RetryHelper.runWithRetries((Callable)new Callable<ResourceManagerRpc.ListResult<OrgPolicy>>(){

                @Override
                public ResourceManagerRpc.ListResult<OrgPolicy> call() throws IOException {
                    return rpc.listOrgPolicies(resource, optionsMap);
                }
            }, (RetrySettings)serviceOptions.getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
            String cursor = orgPolicy.pageToken();
            ImmutableList orgPolicies = orgPolicy.results() == null ? ImmutableList.of() : Iterables.transform(orgPolicy.results(), OrgPolicyInfo.FROM_PROTOBUF_FUNCTION);
            return new PageImpl((PageImpl.NextPageFetcher)new OrgPolicyPageFetcher(resource, serviceOptions, cursor, optionsMap), cursor, (Iterable)orgPolicies);
        }
        catch (RetryHelper.RetryHelperException ex) {
            throw ResourceManagerException.translateAndThrow(ex);
        }
    }

    @Override
    public OrgPolicyInfo replaceOrgPolicy(final String resource, final OrgPolicyInfo orgPolicy) {
        try {
            return OrgPolicyInfo.fromProtobuf((OrgPolicy)RetryHelper.runWithRetries((Callable)new Callable<OrgPolicy>(){

                @Override
                public OrgPolicy call() throws IOException {
                    return ResourceManagerImpl.this.resourceManagerRpc.replaceOrgPolicy(resource, orgPolicy.toProtobuf());
                }
            }, (RetrySettings)((ResourceManagerOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((ResourceManagerOptions)this.getOptions()).getClock()));
        }
        catch (RetryHelper.RetryHelperException ex) {
            throw ResourceManagerException.translateAndThrow(ex);
        }
    }

    private Map<ResourceManagerRpc.Option, ?> optionMap(Option ... options) {
        EnumMap temp = Maps.newEnumMap(ResourceManagerRpc.Option.class);
        for (Option option : options) {
            Object prev = temp.put(option.getRpcOption(), option.getValue());
            Preconditions.checkArgument((prev == null ? 1 : 0) != 0, (String)"Duplicate option %s", (Object)option);
        }
        return ImmutableMap.copyOf((Map)temp);
    }

    private static class OrgPolicyPageFetcher
    implements PageImpl.NextPageFetcher<OrgPolicyInfo> {
        private static final long serialVersionUID = 2158209410430566961L;
        private final String resource;
        private final Map<ResourceManagerRpc.Option, ?> requestOptions;
        private final ResourceManagerOptions serviceOptions;

        OrgPolicyPageFetcher(String resource, ResourceManagerOptions serviceOptions, String cursor, Map<ResourceManagerRpc.Option, ?> optionMap) {
            this.resource = resource;
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)ResourceManagerRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
        }

        public Page<OrgPolicyInfo> getNextPage() {
            return ResourceManagerImpl.listOrgPolicies(this.resource, this.serviceOptions, this.requestOptions);
        }
    }

    private static class ConstraintPageFetcher
    implements PageImpl.NextPageFetcher<ConstraintInfo> {
        private static final long serialVersionUID = 2158209410430566961L;
        private final String resource;
        private final Map<ResourceManagerRpc.Option, ?> requestOptions;
        private final ResourceManagerOptions serviceOptions;

        ConstraintPageFetcher(String resource, ResourceManagerOptions serviceOptions, String cursor, Map<ResourceManagerRpc.Option, ?> optionMap) {
            this.resource = resource;
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)ResourceManagerRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
        }

        public Page<ConstraintInfo> getNextPage() {
            return ResourceManagerImpl.listAvailableOrgPolicyConstraints(this.resource, this.serviceOptions, this.requestOptions);
        }
    }

    private static class ProjectPageFetcher
    implements PageImpl.NextPageFetcher<Project> {
        private static final long serialVersionUID = 2158209410430566961L;
        private final Map<ResourceManagerRpc.Option, ?> requestOptions;
        private final ResourceManagerOptions serviceOptions;

        ProjectPageFetcher(ResourceManagerOptions serviceOptions, String cursor, Map<ResourceManagerRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)ResourceManagerRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
        }

        public Page<Project> getNextPage() {
            return ResourceManagerImpl.listProjects(this.serviceOptions, this.requestOptions);
        }
    }
}

