/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager.v3.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.resourcemanager.v3.CreateProjectMetadata;
import com.google.cloud.resourcemanager.v3.CreateProjectRequest;
import com.google.cloud.resourcemanager.v3.DeleteProjectMetadata;
import com.google.cloud.resourcemanager.v3.DeleteProjectRequest;
import com.google.cloud.resourcemanager.v3.GetProjectRequest;
import com.google.cloud.resourcemanager.v3.ListProjectsRequest;
import com.google.cloud.resourcemanager.v3.ListProjectsResponse;
import com.google.cloud.resourcemanager.v3.MoveProjectMetadata;
import com.google.cloud.resourcemanager.v3.MoveProjectRequest;
import com.google.cloud.resourcemanager.v3.Project;
import com.google.cloud.resourcemanager.v3.ProjectsClient;
import com.google.cloud.resourcemanager.v3.SearchProjectsRequest;
import com.google.cloud.resourcemanager.v3.SearchProjectsResponse;
import com.google.cloud.resourcemanager.v3.UndeleteProjectMetadata;
import com.google.cloud.resourcemanager.v3.UndeleteProjectRequest;
import com.google.cloud.resourcemanager.v3.UpdateProjectMetadata;
import com.google.cloud.resourcemanager.v3.UpdateProjectRequest;
import com.google.cloud.resourcemanager.v3.stub.GrpcProjectsStub;
import com.google.cloud.resourcemanager.v3.stub.HttpJsonProjectsStub;
import com.google.cloud.resourcemanager.v3.stub.ProjectsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class ProjectsStubSettings
extends StubSettings<ProjectsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").build();
    private final UnaryCallSettings<GetProjectRequest, Project> getProjectSettings;
    private final PagedCallSettings<ListProjectsRequest, ListProjectsResponse, ProjectsClient.ListProjectsPagedResponse> listProjectsSettings;
    private final PagedCallSettings<SearchProjectsRequest, SearchProjectsResponse, ProjectsClient.SearchProjectsPagedResponse> searchProjectsSettings;
    private final UnaryCallSettings<CreateProjectRequest, Operation> createProjectSettings;
    private final OperationCallSettings<CreateProjectRequest, Project, CreateProjectMetadata> createProjectOperationSettings;
    private final UnaryCallSettings<UpdateProjectRequest, Operation> updateProjectSettings;
    private final OperationCallSettings<UpdateProjectRequest, Project, UpdateProjectMetadata> updateProjectOperationSettings;
    private final UnaryCallSettings<MoveProjectRequest, Operation> moveProjectSettings;
    private final OperationCallSettings<MoveProjectRequest, Project, MoveProjectMetadata> moveProjectOperationSettings;
    private final UnaryCallSettings<DeleteProjectRequest, Operation> deleteProjectSettings;
    private final OperationCallSettings<DeleteProjectRequest, Project, DeleteProjectMetadata> deleteProjectOperationSettings;
    private final UnaryCallSettings<UndeleteProjectRequest, Operation> undeleteProjectSettings;
    private final OperationCallSettings<UndeleteProjectRequest, Project, UndeleteProjectMetadata> undeleteProjectOperationSettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListProjectsRequest, ListProjectsResponse, Project> LIST_PROJECTS_PAGE_STR_DESC = new PagedListDescriptor<ListProjectsRequest, ListProjectsResponse, Project>(){

        public String emptyToken() {
            return "";
        }

        public ListProjectsRequest injectToken(ListProjectsRequest payload, String token) {
            return ListProjectsRequest.newBuilder((ListProjectsRequest)payload).setPageToken(token).build();
        }

        public ListProjectsRequest injectPageSize(ListProjectsRequest payload, int pageSize) {
            return ListProjectsRequest.newBuilder((ListProjectsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListProjectsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListProjectsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Project> extractResources(ListProjectsResponse payload) {
            return payload.getProjectsList() == null ? ImmutableList.of() : payload.getProjectsList();
        }
    };
    private static final PagedListDescriptor<SearchProjectsRequest, SearchProjectsResponse, Project> SEARCH_PROJECTS_PAGE_STR_DESC = new PagedListDescriptor<SearchProjectsRequest, SearchProjectsResponse, Project>(){

        public String emptyToken() {
            return "";
        }

        public SearchProjectsRequest injectToken(SearchProjectsRequest payload, String token) {
            return SearchProjectsRequest.newBuilder((SearchProjectsRequest)payload).setPageToken(token).build();
        }

        public SearchProjectsRequest injectPageSize(SearchProjectsRequest payload, int pageSize) {
            return SearchProjectsRequest.newBuilder((SearchProjectsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchProjectsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchProjectsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Project> extractResources(SearchProjectsResponse payload) {
            return payload.getProjectsList() == null ? ImmutableList.of() : payload.getProjectsList();
        }
    };
    private static final PagedListResponseFactory<ListProjectsRequest, ListProjectsResponse, ProjectsClient.ListProjectsPagedResponse> LIST_PROJECTS_PAGE_STR_FACT = new PagedListResponseFactory<ListProjectsRequest, ListProjectsResponse, ProjectsClient.ListProjectsPagedResponse>(){

        public ApiFuture<ProjectsClient.ListProjectsPagedResponse> getFuturePagedResponse(UnaryCallable<ListProjectsRequest, ListProjectsResponse> callable, ListProjectsRequest request, ApiCallContext context, ApiFuture<ListProjectsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PROJECTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ProjectsClient.ListProjectsPagedResponse.createAsync((PageContext<ListProjectsRequest, ListProjectsResponse, Project>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<SearchProjectsRequest, SearchProjectsResponse, ProjectsClient.SearchProjectsPagedResponse> SEARCH_PROJECTS_PAGE_STR_FACT = new PagedListResponseFactory<SearchProjectsRequest, SearchProjectsResponse, ProjectsClient.SearchProjectsPagedResponse>(){

        public ApiFuture<ProjectsClient.SearchProjectsPagedResponse> getFuturePagedResponse(UnaryCallable<SearchProjectsRequest, SearchProjectsResponse> callable, SearchProjectsRequest request, ApiCallContext context, ApiFuture<SearchProjectsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_PROJECTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ProjectsClient.SearchProjectsPagedResponse.createAsync((PageContext<SearchProjectsRequest, SearchProjectsResponse, Project>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetProjectRequest, Project> getProjectSettings() {
        return this.getProjectSettings;
    }

    public PagedCallSettings<ListProjectsRequest, ListProjectsResponse, ProjectsClient.ListProjectsPagedResponse> listProjectsSettings() {
        return this.listProjectsSettings;
    }

    public PagedCallSettings<SearchProjectsRequest, SearchProjectsResponse, ProjectsClient.SearchProjectsPagedResponse> searchProjectsSettings() {
        return this.searchProjectsSettings;
    }

    public UnaryCallSettings<CreateProjectRequest, Operation> createProjectSettings() {
        return this.createProjectSettings;
    }

    public OperationCallSettings<CreateProjectRequest, Project, CreateProjectMetadata> createProjectOperationSettings() {
        return this.createProjectOperationSettings;
    }

    public UnaryCallSettings<UpdateProjectRequest, Operation> updateProjectSettings() {
        return this.updateProjectSettings;
    }

    public OperationCallSettings<UpdateProjectRequest, Project, UpdateProjectMetadata> updateProjectOperationSettings() {
        return this.updateProjectOperationSettings;
    }

    public UnaryCallSettings<MoveProjectRequest, Operation> moveProjectSettings() {
        return this.moveProjectSettings;
    }

    public OperationCallSettings<MoveProjectRequest, Project, MoveProjectMetadata> moveProjectOperationSettings() {
        return this.moveProjectOperationSettings;
    }

    public UnaryCallSettings<DeleteProjectRequest, Operation> deleteProjectSettings() {
        return this.deleteProjectSettings;
    }

    public OperationCallSettings<DeleteProjectRequest, Project, DeleteProjectMetadata> deleteProjectOperationSettings() {
        return this.deleteProjectOperationSettings;
    }

    public UnaryCallSettings<UndeleteProjectRequest, Operation> undeleteProjectSettings() {
        return this.undeleteProjectSettings;
    }

    public OperationCallSettings<UndeleteProjectRequest, Project, UndeleteProjectMetadata> undeleteProjectOperationSettings() {
        return this.undeleteProjectOperationSettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public ProjectsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcProjectsStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonProjectsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "cloudresourcemanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "cloudresourcemanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudresourcemanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ProjectsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ProjectsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ProjectsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ProjectsStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ProjectsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getProjectSettings = settingsBuilder.getProjectSettings().build();
        this.listProjectsSettings = settingsBuilder.listProjectsSettings().build();
        this.searchProjectsSettings = settingsBuilder.searchProjectsSettings().build();
        this.createProjectSettings = settingsBuilder.createProjectSettings().build();
        this.createProjectOperationSettings = settingsBuilder.createProjectOperationSettings().build();
        this.updateProjectSettings = settingsBuilder.updateProjectSettings().build();
        this.updateProjectOperationSettings = settingsBuilder.updateProjectOperationSettings().build();
        this.moveProjectSettings = settingsBuilder.moveProjectSettings().build();
        this.moveProjectOperationSettings = settingsBuilder.moveProjectOperationSettings().build();
        this.deleteProjectSettings = settingsBuilder.deleteProjectSettings().build();
        this.deleteProjectOperationSettings = settingsBuilder.deleteProjectOperationSettings().build();
        this.undeleteProjectSettings = settingsBuilder.undeleteProjectSettings().build();
        this.undeleteProjectOperationSettings = settingsBuilder.undeleteProjectOperationSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ProjectsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetProjectRequest, Project> getProjectSettings;
        private final PagedCallSettings.Builder<ListProjectsRequest, ListProjectsResponse, ProjectsClient.ListProjectsPagedResponse> listProjectsSettings;
        private final PagedCallSettings.Builder<SearchProjectsRequest, SearchProjectsResponse, ProjectsClient.SearchProjectsPagedResponse> searchProjectsSettings;
        private final UnaryCallSettings.Builder<CreateProjectRequest, Operation> createProjectSettings;
        private final OperationCallSettings.Builder<CreateProjectRequest, Project, CreateProjectMetadata> createProjectOperationSettings;
        private final UnaryCallSettings.Builder<UpdateProjectRequest, Operation> updateProjectSettings;
        private final OperationCallSettings.Builder<UpdateProjectRequest, Project, UpdateProjectMetadata> updateProjectOperationSettings;
        private final UnaryCallSettings.Builder<MoveProjectRequest, Operation> moveProjectSettings;
        private final OperationCallSettings.Builder<MoveProjectRequest, Project, MoveProjectMetadata> moveProjectOperationSettings;
        private final UnaryCallSettings.Builder<DeleteProjectRequest, Operation> deleteProjectSettings;
        private final OperationCallSettings.Builder<DeleteProjectRequest, Project, DeleteProjectMetadata> deleteProjectOperationSettings;
        private final UnaryCallSettings.Builder<UndeleteProjectRequest, Operation> undeleteProjectSettings;
        private final OperationCallSettings.Builder<UndeleteProjectRequest, Project, UndeleteProjectMetadata> undeleteProjectOperationSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getProjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listProjectsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PROJECTS_PAGE_STR_FACT);
            this.searchProjectsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_PROJECTS_PAGE_STR_FACT);
            this.createProjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createProjectOperationSettings = OperationCallSettings.newBuilder();
            this.updateProjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateProjectOperationSettings = OperationCallSettings.newBuilder();
            this.moveProjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.moveProjectOperationSettings = OperationCallSettings.newBuilder();
            this.deleteProjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteProjectOperationSettings = OperationCallSettings.newBuilder();
            this.undeleteProjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.undeleteProjectOperationSettings = OperationCallSettings.newBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getProjectSettings, this.listProjectsSettings, this.searchProjectsSettings, this.createProjectSettings, this.updateProjectSettings, this.moveProjectSettings, this.deleteProjectSettings, this.undeleteProjectSettings, this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ProjectsStubSettings settings) {
            super((StubSettings)settings);
            this.getProjectSettings = settings.getProjectSettings.toBuilder();
            this.listProjectsSettings = settings.listProjectsSettings.toBuilder();
            this.searchProjectsSettings = settings.searchProjectsSettings.toBuilder();
            this.createProjectSettings = settings.createProjectSettings.toBuilder();
            this.createProjectOperationSettings = settings.createProjectOperationSettings.toBuilder();
            this.updateProjectSettings = settings.updateProjectSettings.toBuilder();
            this.updateProjectOperationSettings = settings.updateProjectOperationSettings.toBuilder();
            this.moveProjectSettings = settings.moveProjectSettings.toBuilder();
            this.moveProjectOperationSettings = settings.moveProjectOperationSettings.toBuilder();
            this.deleteProjectSettings = settings.deleteProjectSettings.toBuilder();
            this.deleteProjectOperationSettings = settings.deleteProjectOperationSettings.toBuilder();
            this.undeleteProjectSettings = settings.undeleteProjectSettings.toBuilder();
            this.undeleteProjectOperationSettings = settings.undeleteProjectOperationSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getProjectSettings, this.listProjectsSettings, this.searchProjectsSettings, this.createProjectSettings, this.updateProjectSettings, this.moveProjectSettings, this.deleteProjectSettings, this.undeleteProjectSettings, this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ProjectsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ProjectsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ProjectsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ProjectsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ProjectsStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ProjectsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ProjectsStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ProjectsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getProjectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listProjectsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.searchProjectsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createProjectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateProjectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.moveProjectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteProjectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.undeleteProjectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createProjectOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Project.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateProjectMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateProjectOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Project.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpdateProjectMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.moveProjectOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Project.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(MoveProjectMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteProjectOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Project.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteProjectMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.undeleteProjectOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Project.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UndeleteProjectMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetProjectRequest, Project> getProjectSettings() {
            return this.getProjectSettings;
        }

        public PagedCallSettings.Builder<ListProjectsRequest, ListProjectsResponse, ProjectsClient.ListProjectsPagedResponse> listProjectsSettings() {
            return this.listProjectsSettings;
        }

        public PagedCallSettings.Builder<SearchProjectsRequest, SearchProjectsResponse, ProjectsClient.SearchProjectsPagedResponse> searchProjectsSettings() {
            return this.searchProjectsSettings;
        }

        public UnaryCallSettings.Builder<CreateProjectRequest, Operation> createProjectSettings() {
            return this.createProjectSettings;
        }

        public OperationCallSettings.Builder<CreateProjectRequest, Project, CreateProjectMetadata> createProjectOperationSettings() {
            return this.createProjectOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateProjectRequest, Operation> updateProjectSettings() {
            return this.updateProjectSettings;
        }

        public OperationCallSettings.Builder<UpdateProjectRequest, Project, UpdateProjectMetadata> updateProjectOperationSettings() {
            return this.updateProjectOperationSettings;
        }

        public UnaryCallSettings.Builder<MoveProjectRequest, Operation> moveProjectSettings() {
            return this.moveProjectSettings;
        }

        public OperationCallSettings.Builder<MoveProjectRequest, Project, MoveProjectMetadata> moveProjectOperationSettings() {
            return this.moveProjectOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteProjectRequest, Operation> deleteProjectSettings() {
            return this.deleteProjectSettings;
        }

        public OperationCallSettings.Builder<DeleteProjectRequest, Project, DeleteProjectMetadata> deleteProjectOperationSettings() {
            return this.deleteProjectOperationSettings;
        }

        public UnaryCallSettings.Builder<UndeleteProjectRequest, Operation> undeleteProjectSettings() {
            return this.undeleteProjectSettings;
        }

        public OperationCallSettings.Builder<UndeleteProjectRequest, Project, UndeleteProjectMetadata> undeleteProjectOperationSettings() {
            return this.undeleteProjectOperationSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public ProjectsStubSettings build() throws IOException {
            return new ProjectsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

