/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager.v3;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.resourcemanager.v3.CreateTagBindingMetadata;
import com.google.cloud.resourcemanager.v3.CreateTagBindingRequest;
import com.google.cloud.resourcemanager.v3.DeleteTagBindingMetadata;
import com.google.cloud.resourcemanager.v3.DeleteTagBindingRequest;
import com.google.cloud.resourcemanager.v3.ListTagBindingsRequest;
import com.google.cloud.resourcemanager.v3.ListTagBindingsResponse;
import com.google.cloud.resourcemanager.v3.TagBinding;
import com.google.cloud.resourcemanager.v3.TagBindingName;
import com.google.cloud.resourcemanager.v3.TagBindingsSettings;
import com.google.cloud.resourcemanager.v3.stub.TagBindingsStub;
import com.google.cloud.resourcemanager.v3.stub.TagBindingsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class TagBindingsClient
implements BackgroundResource {
    private final TagBindingsSettings settings;
    private final TagBindingsStub stub;
    private final OperationsClient operationsClient;

    public static final TagBindingsClient create() throws IOException {
        return TagBindingsClient.create(TagBindingsSettings.newBuilder().build());
    }

    public static final TagBindingsClient create(TagBindingsSettings settings) throws IOException {
        return new TagBindingsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final TagBindingsClient create(TagBindingsStub stub) {
        return new TagBindingsClient(stub);
    }

    protected TagBindingsClient(TagBindingsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TagBindingsStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected TagBindingsClient(TagBindingsStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final TagBindingsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TagBindingsStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListTagBindingsPagedResponse listTagBindings(ResourceName parent) {
        ListTagBindingsRequest request = ListTagBindingsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTagBindings(request);
    }

    public final ListTagBindingsPagedResponse listTagBindings(String parent) {
        ListTagBindingsRequest request = ListTagBindingsRequest.newBuilder().setParent(parent).build();
        return this.listTagBindings(request);
    }

    public final ListTagBindingsPagedResponse listTagBindings(ListTagBindingsRequest request) {
        return (ListTagBindingsPagedResponse)((Object)this.listTagBindingsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTagBindingsRequest, ListTagBindingsPagedResponse> listTagBindingsPagedCallable() {
        return this.stub.listTagBindingsPagedCallable();
    }

    public final UnaryCallable<ListTagBindingsRequest, ListTagBindingsResponse> listTagBindingsCallable() {
        return this.stub.listTagBindingsCallable();
    }

    public final OperationFuture<TagBinding, CreateTagBindingMetadata> createTagBindingAsync(TagBinding tagBinding) {
        CreateTagBindingRequest request = CreateTagBindingRequest.newBuilder().setTagBinding(tagBinding).build();
        return this.createTagBindingAsync(request);
    }

    public final OperationFuture<TagBinding, CreateTagBindingMetadata> createTagBindingAsync(CreateTagBindingRequest request) {
        return this.createTagBindingOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateTagBindingRequest, TagBinding, CreateTagBindingMetadata> createTagBindingOperationCallable() {
        return this.stub.createTagBindingOperationCallable();
    }

    public final UnaryCallable<CreateTagBindingRequest, Operation> createTagBindingCallable() {
        return this.stub.createTagBindingCallable();
    }

    public final OperationFuture<Empty, DeleteTagBindingMetadata> deleteTagBindingAsync(TagBindingName name) {
        DeleteTagBindingRequest request = DeleteTagBindingRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteTagBindingAsync(request);
    }

    public final OperationFuture<Empty, DeleteTagBindingMetadata> deleteTagBindingAsync(String name) {
        DeleteTagBindingRequest request = DeleteTagBindingRequest.newBuilder().setName(name).build();
        return this.deleteTagBindingAsync(request);
    }

    public final OperationFuture<Empty, DeleteTagBindingMetadata> deleteTagBindingAsync(DeleteTagBindingRequest request) {
        return this.deleteTagBindingOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteTagBindingRequest, Empty, DeleteTagBindingMetadata> deleteTagBindingOperationCallable() {
        return this.stub.deleteTagBindingOperationCallable();
    }

    public final UnaryCallable<DeleteTagBindingRequest, Operation> deleteTagBindingCallable() {
        return this.stub.deleteTagBindingCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListTagBindingsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTagBindingsRequest, ListTagBindingsResponse, TagBinding, ListTagBindingsPage, ListTagBindingsFixedSizeCollection> {
        private ListTagBindingsFixedSizeCollection(List<ListTagBindingsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTagBindingsFixedSizeCollection createEmptyCollection() {
            return new ListTagBindingsFixedSizeCollection(null, 0);
        }

        protected ListTagBindingsFixedSizeCollection createCollection(List<ListTagBindingsPage> pages, int collectionSize) {
            return new ListTagBindingsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTagBindingsPage
    extends AbstractPage<ListTagBindingsRequest, ListTagBindingsResponse, TagBinding, ListTagBindingsPage> {
        private ListTagBindingsPage(PageContext<ListTagBindingsRequest, ListTagBindingsResponse, TagBinding> context, ListTagBindingsResponse response) {
            super(context, (Object)response);
        }

        private static ListTagBindingsPage createEmptyPage() {
            return new ListTagBindingsPage(null, null);
        }

        protected ListTagBindingsPage createPage(PageContext<ListTagBindingsRequest, ListTagBindingsResponse, TagBinding> context, ListTagBindingsResponse response) {
            return new ListTagBindingsPage(context, response);
        }

        public ApiFuture<ListTagBindingsPage> createPageAsync(PageContext<ListTagBindingsRequest, ListTagBindingsResponse, TagBinding> context, ApiFuture<ListTagBindingsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTagBindingsPagedResponse
    extends AbstractPagedListResponse<ListTagBindingsRequest, ListTagBindingsResponse, TagBinding, ListTagBindingsPage, ListTagBindingsFixedSizeCollection> {
        public static ApiFuture<ListTagBindingsPagedResponse> createAsync(PageContext<ListTagBindingsRequest, ListTagBindingsResponse, TagBinding> context, ApiFuture<ListTagBindingsResponse> futureResponse) {
            ApiFuture<ListTagBindingsPage> futurePage = ListTagBindingsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTagBindingsPagedResponse((ListTagBindingsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTagBindingsPagedResponse(ListTagBindingsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTagBindingsFixedSizeCollection.createEmptyCollection());
        }
    }
}

