/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager.v3.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.resourcemanager.v3.CreateProjectMetadata;
import com.google.cloud.resourcemanager.v3.CreateProjectRequest;
import com.google.cloud.resourcemanager.v3.DeleteProjectMetadata;
import com.google.cloud.resourcemanager.v3.DeleteProjectRequest;
import com.google.cloud.resourcemanager.v3.GetProjectRequest;
import com.google.cloud.resourcemanager.v3.ListProjectsRequest;
import com.google.cloud.resourcemanager.v3.ListProjectsResponse;
import com.google.cloud.resourcemanager.v3.MoveProjectMetadata;
import com.google.cloud.resourcemanager.v3.MoveProjectRequest;
import com.google.cloud.resourcemanager.v3.Project;
import com.google.cloud.resourcemanager.v3.ProjectsClient;
import com.google.cloud.resourcemanager.v3.SearchProjectsRequest;
import com.google.cloud.resourcemanager.v3.SearchProjectsResponse;
import com.google.cloud.resourcemanager.v3.UndeleteProjectMetadata;
import com.google.cloud.resourcemanager.v3.UndeleteProjectRequest;
import com.google.cloud.resourcemanager.v3.UpdateProjectMetadata;
import com.google.cloud.resourcemanager.v3.UpdateProjectRequest;
import com.google.cloud.resourcemanager.v3.stub.HttpJsonProjectsCallableFactory;
import com.google.cloud.resourcemanager.v3.stub.ProjectsStub;
import com.google.cloud.resourcemanager.v3.stub.ProjectsStubSettings;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonProjectsStub
extends ProjectsStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Project.getDescriptor()).add(CreateProjectMetadata.getDescriptor()).add(UpdateProjectMetadata.getDescriptor()).add(MoveProjectMetadata.getDescriptor()).add(UndeleteProjectMetadata.getDescriptor()).add(DeleteProjectMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<GetProjectRequest, Project> getProjectMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.Projects/GetProject").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{name=projects/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Project.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListProjectsRequest, ListProjectsResponse> listProjectsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.Projects/ListProjects").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/projects", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "parent", (Object)request.getParent());
        serializer.putQueryParam(fields, "showDeleted", (Object)request.getShowDeleted());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListProjectsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SearchProjectsRequest, SearchProjectsResponse> searchProjectsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.Projects/SearchProjects").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/projects:search", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "query", (Object)request.getQuery());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SearchProjectsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateProjectRequest, Operation> createProjectMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.Projects/CreateProject").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/projects", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("project", (Message)request.getProject(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateProjectRequest, Operation> updateProjectMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.Projects/UpdateProject").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{project.name=projects/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project.name", (Object)request.getProject().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("project", (Message)request.getProject(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<MoveProjectRequest, Operation> moveProjectMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.Projects/MoveProject").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{name=projects/*}:move", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteProjectRequest, Operation> deleteProjectMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.Projects/DeleteProject").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{name=projects/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UndeleteProjectRequest, Operation> undeleteProjectMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.Projects/UndeleteProject").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{name=projects/*}:undelete", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.Projects/GetIamPolicy").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{resource=projects/*}:getIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.Projects/SetIamPolicy").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{resource=projects/*}:setIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.Projects/TestIamPermissions").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{resource=projects/*}:testIamPermissions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TestIamPermissionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<GetProjectRequest, Project> getProjectCallable;
    private final UnaryCallable<ListProjectsRequest, ListProjectsResponse> listProjectsCallable;
    private final UnaryCallable<ListProjectsRequest, ProjectsClient.ListProjectsPagedResponse> listProjectsPagedCallable;
    private final UnaryCallable<SearchProjectsRequest, SearchProjectsResponse> searchProjectsCallable;
    private final UnaryCallable<SearchProjectsRequest, ProjectsClient.SearchProjectsPagedResponse> searchProjectsPagedCallable;
    private final UnaryCallable<CreateProjectRequest, Operation> createProjectCallable;
    private final OperationCallable<CreateProjectRequest, Project, CreateProjectMetadata> createProjectOperationCallable;
    private final UnaryCallable<UpdateProjectRequest, Operation> updateProjectCallable;
    private final OperationCallable<UpdateProjectRequest, Project, UpdateProjectMetadata> updateProjectOperationCallable;
    private final UnaryCallable<MoveProjectRequest, Operation> moveProjectCallable;
    private final OperationCallable<MoveProjectRequest, Project, MoveProjectMetadata> moveProjectOperationCallable;
    private final UnaryCallable<DeleteProjectRequest, Operation> deleteProjectCallable;
    private final OperationCallable<DeleteProjectRequest, Project, DeleteProjectMetadata> deleteProjectOperationCallable;
    private final UnaryCallable<UndeleteProjectRequest, Operation> undeleteProjectCallable;
    private final OperationCallable<UndeleteProjectRequest, Project, UndeleteProjectMetadata> undeleteProjectOperationCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonProjectsStub create(ProjectsStubSettings settings) throws IOException {
        return new HttpJsonProjectsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonProjectsStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonProjectsStub(ProjectsStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonProjectsStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonProjectsStub(ProjectsStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonProjectsStub(ProjectsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonProjectsCallableFactory());
    }

    protected HttpJsonProjectsStub(ProjectsStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry);
        HttpJsonCallSettings getProjectTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getProjectMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listProjectsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listProjectsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings searchProjectsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(searchProjectsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createProjectTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createProjectMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateProjectTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateProjectMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings moveProjectTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(moveProjectMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteProjectTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteProjectMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings undeleteProjectTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(undeleteProjectMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings setIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings testIamPermissionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.getProjectCallable = callableFactory.createUnaryCallable(getProjectTransportSettings, settings.getProjectSettings(), clientContext);
        this.listProjectsCallable = callableFactory.createUnaryCallable(listProjectsTransportSettings, settings.listProjectsSettings(), clientContext);
        this.listProjectsPagedCallable = callableFactory.createPagedCallable(listProjectsTransportSettings, settings.listProjectsSettings(), clientContext);
        this.searchProjectsCallable = callableFactory.createUnaryCallable(searchProjectsTransportSettings, settings.searchProjectsSettings(), clientContext);
        this.searchProjectsPagedCallable = callableFactory.createPagedCallable(searchProjectsTransportSettings, settings.searchProjectsSettings(), clientContext);
        this.createProjectCallable = callableFactory.createUnaryCallable(createProjectTransportSettings, settings.createProjectSettings(), clientContext);
        this.createProjectOperationCallable = callableFactory.createOperationCallable(createProjectTransportSettings, settings.createProjectOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateProjectCallable = callableFactory.createUnaryCallable(updateProjectTransportSettings, settings.updateProjectSettings(), clientContext);
        this.updateProjectOperationCallable = callableFactory.createOperationCallable(updateProjectTransportSettings, settings.updateProjectOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.moveProjectCallable = callableFactory.createUnaryCallable(moveProjectTransportSettings, settings.moveProjectSettings(), clientContext);
        this.moveProjectOperationCallable = callableFactory.createOperationCallable(moveProjectTransportSettings, settings.moveProjectOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteProjectCallable = callableFactory.createUnaryCallable(deleteProjectTransportSettings, settings.deleteProjectSettings(), clientContext);
        this.deleteProjectOperationCallable = callableFactory.createOperationCallable(deleteProjectTransportSettings, settings.deleteProjectOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.undeleteProjectCallable = callableFactory.createUnaryCallable(undeleteProjectTransportSettings, settings.undeleteProjectSettings(), clientContext);
        this.undeleteProjectOperationCallable = callableFactory.createOperationCallable(undeleteProjectTransportSettings, settings.undeleteProjectOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getProjectMethodDescriptor);
        methodDescriptors.add(listProjectsMethodDescriptor);
        methodDescriptors.add(searchProjectsMethodDescriptor);
        methodDescriptors.add(createProjectMethodDescriptor);
        methodDescriptors.add(updateProjectMethodDescriptor);
        methodDescriptors.add(moveProjectMethodDescriptor);
        methodDescriptors.add(deleteProjectMethodDescriptor);
        methodDescriptors.add(undeleteProjectMethodDescriptor);
        methodDescriptors.add(getIamPolicyMethodDescriptor);
        methodDescriptors.add(setIamPolicyMethodDescriptor);
        methodDescriptors.add(testIamPermissionsMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<GetProjectRequest, Project> getProjectCallable() {
        return this.getProjectCallable;
    }

    @Override
    public UnaryCallable<ListProjectsRequest, ListProjectsResponse> listProjectsCallable() {
        return this.listProjectsCallable;
    }

    @Override
    public UnaryCallable<ListProjectsRequest, ProjectsClient.ListProjectsPagedResponse> listProjectsPagedCallable() {
        return this.listProjectsPagedCallable;
    }

    @Override
    public UnaryCallable<SearchProjectsRequest, SearchProjectsResponse> searchProjectsCallable() {
        return this.searchProjectsCallable;
    }

    @Override
    public UnaryCallable<SearchProjectsRequest, ProjectsClient.SearchProjectsPagedResponse> searchProjectsPagedCallable() {
        return this.searchProjectsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateProjectRequest, Operation> createProjectCallable() {
        return this.createProjectCallable;
    }

    @Override
    public OperationCallable<CreateProjectRequest, Project, CreateProjectMetadata> createProjectOperationCallable() {
        return this.createProjectOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateProjectRequest, Operation> updateProjectCallable() {
        return this.updateProjectCallable;
    }

    @Override
    public OperationCallable<UpdateProjectRequest, Project, UpdateProjectMetadata> updateProjectOperationCallable() {
        return this.updateProjectOperationCallable;
    }

    @Override
    public UnaryCallable<MoveProjectRequest, Operation> moveProjectCallable() {
        return this.moveProjectCallable;
    }

    @Override
    public OperationCallable<MoveProjectRequest, Project, MoveProjectMetadata> moveProjectOperationCallable() {
        return this.moveProjectOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteProjectRequest, Operation> deleteProjectCallable() {
        return this.deleteProjectCallable;
    }

    @Override
    public OperationCallable<DeleteProjectRequest, Project, DeleteProjectMetadata> deleteProjectOperationCallable() {
        return this.deleteProjectOperationCallable;
    }

    @Override
    public UnaryCallable<UndeleteProjectRequest, Operation> undeleteProjectCallable() {
        return this.undeleteProjectCallable;
    }

    @Override
    public OperationCallable<UndeleteProjectRequest, Project, UndeleteProjectMetadata> undeleteProjectOperationCallable() {
        return this.undeleteProjectOperationCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

