/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager.v3.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.resourcemanager.v3.CreateTagBindingMetadata;
import com.google.cloud.resourcemanager.v3.CreateTagBindingRequest;
import com.google.cloud.resourcemanager.v3.DeleteTagBindingMetadata;
import com.google.cloud.resourcemanager.v3.DeleteTagBindingRequest;
import com.google.cloud.resourcemanager.v3.ListTagBindingsRequest;
import com.google.cloud.resourcemanager.v3.ListTagBindingsResponse;
import com.google.cloud.resourcemanager.v3.TagBinding;
import com.google.cloud.resourcemanager.v3.TagBindingsClient;
import com.google.cloud.resourcemanager.v3.stub.HttpJsonTagBindingsCallableFactory;
import com.google.cloud.resourcemanager.v3.stub.TagBindingsStub;
import com.google.cloud.resourcemanager.v3.stub.TagBindingsStubSettings;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonTagBindingsStub
extends TagBindingsStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Empty.getDescriptor()).add(TagBinding.getDescriptor()).add(DeleteTagBindingMetadata.getDescriptor()).add(CreateTagBindingMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<ListTagBindingsRequest, ListTagBindingsResponse> listTagBindingsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.TagBindings/ListTagBindings").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/tagBindings", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "parent", (Object)request.getParent());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListTagBindingsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateTagBindingRequest, Operation> createTagBindingMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.TagBindings/CreateTagBinding").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/tagBindings", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("tagBinding", (Message)request.getTagBinding(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteTagBindingRequest, Operation> deleteTagBindingMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.TagBindings/DeleteTagBinding").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{name=tagBindings/**}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private final UnaryCallable<ListTagBindingsRequest, ListTagBindingsResponse> listTagBindingsCallable;
    private final UnaryCallable<ListTagBindingsRequest, TagBindingsClient.ListTagBindingsPagedResponse> listTagBindingsPagedCallable;
    private final UnaryCallable<CreateTagBindingRequest, Operation> createTagBindingCallable;
    private final OperationCallable<CreateTagBindingRequest, TagBinding, CreateTagBindingMetadata> createTagBindingOperationCallable;
    private final UnaryCallable<DeleteTagBindingRequest, Operation> deleteTagBindingCallable;
    private final OperationCallable<DeleteTagBindingRequest, Empty, DeleteTagBindingMetadata> deleteTagBindingOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonTagBindingsStub create(TagBindingsStubSettings settings) throws IOException {
        return new HttpJsonTagBindingsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonTagBindingsStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonTagBindingsStub(TagBindingsStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonTagBindingsStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonTagBindingsStub(TagBindingsStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonTagBindingsStub(TagBindingsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonTagBindingsCallableFactory());
    }

    protected HttpJsonTagBindingsStub(TagBindingsStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry);
        HttpJsonCallSettings listTagBindingsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listTagBindingsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createTagBindingTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createTagBindingMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteTagBindingTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteTagBindingMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.listTagBindingsCallable = callableFactory.createUnaryCallable(listTagBindingsTransportSettings, settings.listTagBindingsSettings(), clientContext);
        this.listTagBindingsPagedCallable = callableFactory.createPagedCallable(listTagBindingsTransportSettings, settings.listTagBindingsSettings(), clientContext);
        this.createTagBindingCallable = callableFactory.createUnaryCallable(createTagBindingTransportSettings, settings.createTagBindingSettings(), clientContext);
        this.createTagBindingOperationCallable = callableFactory.createOperationCallable(createTagBindingTransportSettings, settings.createTagBindingOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteTagBindingCallable = callableFactory.createUnaryCallable(deleteTagBindingTransportSettings, settings.deleteTagBindingSettings(), clientContext);
        this.deleteTagBindingOperationCallable = callableFactory.createOperationCallable(deleteTagBindingTransportSettings, settings.deleteTagBindingOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listTagBindingsMethodDescriptor);
        methodDescriptors.add(createTagBindingMethodDescriptor);
        methodDescriptors.add(deleteTagBindingMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<ListTagBindingsRequest, ListTagBindingsResponse> listTagBindingsCallable() {
        return this.listTagBindingsCallable;
    }

    @Override
    public UnaryCallable<ListTagBindingsRequest, TagBindingsClient.ListTagBindingsPagedResponse> listTagBindingsPagedCallable() {
        return this.listTagBindingsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateTagBindingRequest, Operation> createTagBindingCallable() {
        return this.createTagBindingCallable;
    }

    @Override
    public OperationCallable<CreateTagBindingRequest, TagBinding, CreateTagBindingMetadata> createTagBindingOperationCallable() {
        return this.createTagBindingOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteTagBindingRequest, Operation> deleteTagBindingCallable() {
        return this.deleteTagBindingCallable;
    }

    @Override
    public OperationCallable<DeleteTagBindingRequest, Empty, DeleteTagBindingMetadata> deleteTagBindingOperationCallable() {
        return this.deleteTagBindingOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

