/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager.spi.v1beta1;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.core.ApiClock;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.api.services.cloudresourcemanager.CloudResourceManager;
import com.google.api.services.cloudresourcemanager.model.GetIamPolicyRequest;
import com.google.api.services.cloudresourcemanager.model.ListProjectsResponse;
import com.google.api.services.cloudresourcemanager.model.Operation;
import com.google.api.services.cloudresourcemanager.model.Policy;
import com.google.api.services.cloudresourcemanager.model.Project;
import com.google.api.services.cloudresourcemanager.model.SetIamPolicyRequest;
import com.google.api.services.cloudresourcemanager.model.Status;
import com.google.api.services.cloudresourcemanager.model.TestIamPermissionsRequest;
import com.google.api.services.cloudresourcemanager.model.TestIamPermissionsResponse;
import com.google.api.services.cloudresourcemanager.model.UndeleteProjectRequest;
import com.google.cloud.RetryHelper;
import com.google.cloud.ServiceOptions;
import com.google.cloud.Tuple;
import com.google.cloud.http.HttpTransportOptions;
import com.google.cloud.resourcemanager.ResourceManagerException;
import com.google.cloud.resourcemanager.ResourceManagerOptions;
import com.google.cloud.resourcemanager.spi.v1beta1.ResourceManagerRpc;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.threeten.bp.Duration;

public class HttpResourceManagerRpc
implements ResourceManagerRpc {
    private static final JsonFactory JSON_FACTORY = new JacksonFactory();
    private static final RetrySettings CREATE_RETRY_SETTINGS = RetrySettings.newBuilder().setTotalTimeout(Duration.ofMinutes((long)2L)).setInitialRetryDelay(Duration.ofSeconds((long)5L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofSeconds((long)11L)).setJittered(true).setInitialRpcTimeout(Duration.ofSeconds((long)5L)).setMaxRpcTimeout(Duration.ofSeconds((long)5L)).build();
    private static final ImmutableMap<Integer, Integer> RPC_TO_HTTP_CODES = ImmutableMap.builder().put((Object)0, (Object)200).put((Object)1, (Object)499).put((Object)2, (Object)500).put((Object)3, (Object)400).put((Object)4, (Object)504).put((Object)5, (Object)404).put((Object)6, (Object)409).put((Object)7, (Object)403).put((Object)16, (Object)401).put((Object)8, (Object)429).put((Object)9, (Object)400).put((Object)10, (Object)409).put((Object)11, (Object)400).put((Object)12, (Object)501).put((Object)13, (Object)500).put((Object)14, (Object)503).put((Object)15, (Object)500).build();
    private static final ResultRetryAlgorithm<Operation> OPERATION_HANDLER = new ResultRetryAlgorithm<Operation>(){

        public TimedAttemptSettings createNextAttempt(Throwable prevThrowable, Operation prevResponse, TimedAttemptSettings prevSettings) {
            return null;
        }

        public boolean shouldRetry(Throwable prevThrowable, Operation prevOp) {
            if (prevThrowable == null) {
                return prevOp.getDone() == null || prevOp.getDone() == false;
            }
            return prevThrowable instanceof ResourceManagerException && ((ResourceManagerException)((Object)prevThrowable)).isRetryable();
        }
    };
    private final CloudResourceManager resourceManager;
    private final ApiClock clock;

    public HttpResourceManagerRpc(ResourceManagerOptions options) {
        HttpTransportOptions transportOptions = (HttpTransportOptions)options.getTransportOptions();
        HttpTransport transport = transportOptions.getHttpTransportFactory().create();
        HttpRequestInitializer initializer = transportOptions.getHttpRequestInitializer((ServiceOptions)options);
        this.resourceManager = new CloudResourceManager.Builder(transport, (JsonFactory)new JacksonFactory(), initializer).setRootUrl(options.getHost()).setApplicationName(options.getApplicationName()).build();
        this.clock = options.getClock();
    }

    private static ResourceManagerException translate(IOException exception) {
        return new ResourceManagerException(exception);
    }

    private static ResourceManagerException translate(Status status) {
        Integer code = (Integer)RPC_TO_HTTP_CODES.get((Object)status.getCode());
        if (code == null) {
            code = 0;
        }
        return new ResourceManagerException(code, status.getMessage());
    }

    @Override
    public Project create(Project project) {
        Operation operation;
        try {
            operation = (Operation)this.resourceManager.projects().create(project).execute();
        }
        catch (IOException ex) {
            throw HttpResourceManagerRpc.translate(ex);
        }
        Operation finishedOp = (Operation)RetryHelper.runWithRetries((Callable)new Callable<Operation>(){

            @Override
            public Operation call() {
                try {
                    return (Operation)HttpResourceManagerRpc.this.resourceManager.operations().get(operation.getName()).execute();
                }
                catch (IOException ex) {
                    throw HttpResourceManagerRpc.translate(ex);
                }
            }
        }, (RetrySettings)CREATE_RETRY_SETTINGS, OPERATION_HANDLER, (ApiClock)this.clock);
        if (finishedOp.getError() != null) {
            throw HttpResourceManagerRpc.translate(finishedOp.getError());
        }
        try {
            String responseTxt = JSON_FACTORY.toString((Object)finishedOp.getResponse());
            return (Project)JSON_FACTORY.fromString(responseTxt, Project.class);
        }
        catch (IOException ex) {
            throw HttpResourceManagerRpc.translate(ex);
        }
    }

    @Override
    public void delete(String projectId) {
        try {
            this.resourceManager.projects().delete(projectId).execute();
        }
        catch (IOException ex) {
            throw HttpResourceManagerRpc.translate(ex);
        }
    }

    @Override
    public Project get(String projectId, Map<ResourceManagerRpc.Option, ?> options) {
        try {
            return (Project)this.resourceManager.projects().get(projectId).setFields(ResourceManagerRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            ResourceManagerException translated = HttpResourceManagerRpc.translate(ex);
            if (translated.getCode() == 403 || translated.getCode() == 404) {
                return null;
            }
            throw translated;
        }
    }

    @Override
    public Tuple<String, Iterable<Project>> list(Map<ResourceManagerRpc.Option, ?> options) {
        try {
            ListProjectsResponse response = (ListProjectsResponse)this.resourceManager.projects().list().setFields(ResourceManagerRpc.Option.FIELDS.getString(options)).setFilter(ResourceManagerRpc.Option.FILTER.getString(options)).setPageSize(ResourceManagerRpc.Option.PAGE_SIZE.getInt(options)).setPageToken(ResourceManagerRpc.Option.PAGE_TOKEN.getString(options)).execute();
            return Tuple.of((Object)response.getNextPageToken(), (Object)response.getProjects());
        }
        catch (IOException ex) {
            throw HttpResourceManagerRpc.translate(ex);
        }
    }

    @Override
    public void undelete(String projectId) {
        try {
            this.resourceManager.projects().undelete(projectId, new UndeleteProjectRequest()).execute();
        }
        catch (IOException ex) {
            throw HttpResourceManagerRpc.translate(ex);
        }
    }

    @Override
    public Project replace(Project project) {
        try {
            return (Project)this.resourceManager.projects().update(project.getProjectId(), project).execute();
        }
        catch (IOException ex) {
            throw HttpResourceManagerRpc.translate(ex);
        }
    }

    @Override
    public Policy getPolicy(String projectId) throws ResourceManagerException {
        try {
            return (Policy)this.resourceManager.projects().getIamPolicy(projectId, new GetIamPolicyRequest()).execute();
        }
        catch (IOException ex) {
            ResourceManagerException translated = HttpResourceManagerRpc.translate(ex);
            if (translated.getCode() == 403) {
                return null;
            }
            throw translated;
        }
    }

    @Override
    public Policy replacePolicy(String projectId, Policy newPolicy) throws ResourceManagerException {
        try {
            return (Policy)this.resourceManager.projects().setIamPolicy(projectId, new SetIamPolicyRequest().setPolicy(newPolicy)).execute();
        }
        catch (IOException ex) {
            throw HttpResourceManagerRpc.translate(ex);
        }
    }

    @Override
    public List<Boolean> testPermissions(String projectId, List<String> permissions) throws ResourceManagerException {
        try {
            TestIamPermissionsResponse response = (TestIamPermissionsResponse)this.resourceManager.projects().testIamPermissions(projectId, new TestIamPermissionsRequest().setPermissions(permissions)).execute();
            ImmutableSet permissionsOwned = ImmutableSet.copyOf((Collection)((Collection)MoreObjects.firstNonNull((Object)response.getPermissions(), (Object)ImmutableList.of())));
            ImmutableList.Builder answer = ImmutableList.builder();
            for (String p : permissions) {
                answer.add((Object)permissionsOwned.contains(p));
            }
            return answer.build();
        }
        catch (IOException ex) {
            throw HttpResourceManagerRpc.translate(ex);
        }
    }
}

