/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager;

import com.google.cloud.HttpServiceOptions;
import com.google.cloud.resourcemanager.ResourceManager;
import com.google.cloud.resourcemanager.ResourceManagerFactory;
import com.google.cloud.resourcemanager.ResourceManagerImpl;
import com.google.cloud.resourcemanager.spi.DefaultResourceManagerRpc;
import com.google.cloud.resourcemanager.spi.ResourceManagerRpc;
import com.google.cloud.resourcemanager.spi.ResourceManagerRpcFactory;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class ResourceManagerOptions
extends HttpServiceOptions<ResourceManager, ResourceManagerRpc, ResourceManagerOptions> {
    private static final long serialVersionUID = -109855112863688882L;
    private static final String GCRM_SCOPE = "https://www.googleapis.com/auth/cloud-platform";
    private static final Set<String> SCOPES = ImmutableSet.of((Object)"https://www.googleapis.com/auth/cloud-platform");
    private static final String DEFAULT_HOST = "https://cloudresourcemanager.googleapis.com";

    @Deprecated
    public static ResourceManagerOptions defaultInstance() {
        return ResourceManagerOptions.getDefaultInstance();
    }

    public static ResourceManagerOptions getDefaultInstance() {
        return ResourceManagerOptions.newBuilder().build();
    }

    protected String getDefaultHost() {
        return DEFAULT_HOST;
    }

    private ResourceManagerOptions(Builder builder) {
        super(ResourceManagerFactory.class, ResourceManagerRpcFactory.class, (HttpServiceOptions.Builder)builder);
    }

    protected boolean projectIdRequired() {
        return false;
    }

    protected ResourceManagerFactory getDefaultServiceFactory() {
        return DefaultResourceManagerFactory.INSTANCE;
    }

    protected ResourceManagerRpcFactory getDefaultRpcFactory() {
        return DefaultResourceManagerRpcFactory.INSTANCE;
    }

    protected Set<String> getScopes() {
        return SCOPES;
    }

    public boolean equals(Object obj) {
        return obj instanceof ResourceManagerOptions && this.baseEquals((ResourceManagerOptions)((Object)obj));
    }

    public int hashCode() {
        return this.baseHashCode();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    @Deprecated
    public static Builder builder() {
        return ResourceManagerOptions.newBuilder();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends HttpServiceOptions.Builder<ResourceManager, ResourceManagerRpc, ResourceManagerOptions, Builder> {
        private Builder() {
        }

        private Builder(ResourceManagerOptions options) {
            super((HttpServiceOptions)options);
        }

        public ResourceManagerOptions build() {
            return new ResourceManagerOptions(this);
        }
    }

    public static class DefaultResourceManagerRpcFactory
    implements ResourceManagerRpcFactory {
        private static final ResourceManagerRpcFactory INSTANCE = new DefaultResourceManagerRpcFactory();

        public ResourceManagerRpc create(ResourceManagerOptions options) {
            return new DefaultResourceManagerRpc(options);
        }
    }

    public static class DefaultResourceManagerFactory
    implements ResourceManagerFactory {
        private static final ResourceManagerFactory INSTANCE = new DefaultResourceManagerFactory();

        public ResourceManager create(ResourceManagerOptions options) {
            return new ResourceManagerImpl(options);
        }
    }
}

