/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager;

import com.google.cloud.Policy;
import com.google.cloud.resourcemanager.ProjectInfo;
import com.google.cloud.resourcemanager.ResourceManager;
import com.google.cloud.resourcemanager.ResourceManagerOptions;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Project
extends ProjectInfo {
    private static final long serialVersionUID = 6767630161335155133L;
    private final ResourceManagerOptions options;
    private transient ResourceManager resourceManager;

    Project(ResourceManager resourceManager, ProjectInfo.BuilderImpl infoBuilder) {
        super(infoBuilder);
        this.resourceManager = (ResourceManager)Preconditions.checkNotNull((Object)resourceManager);
        this.options = (ResourceManagerOptions)resourceManager.options();
    }

    public ResourceManager resourceManager() {
        return this.resourceManager;
    }

    public Project reload() {
        return this.resourceManager.get(this.projectId(), new ResourceManager.ProjectGetOption[0]);
    }

    public void delete() {
        this.resourceManager.delete(this.projectId());
    }

    public void undelete() {
        this.resourceManager.undelete(this.projectId());
    }

    public Project replace() {
        return this.resourceManager.replace(this);
    }

    public Policy getPolicy() {
        return this.resourceManager.getPolicy(this.projectId());
    }

    public Policy replacePolicy(Policy newPolicy) {
        return this.resourceManager.replacePolicy(this.projectId(), newPolicy);
    }

    List<Boolean> testPermissions(List<String> permissions) {
        return this.resourceManager.testPermissions(this.projectId(), permissions);
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Project.class)) {
            return false;
        }
        Project other = (Project)obj;
        return Objects.equals(this.toPb(), other.toPb()) && Objects.equals((Object)this.options, (Object)other.options);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.options});
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.resourceManager = (ResourceManager)this.options.service();
    }

    static Project fromPb(ResourceManager resourceManager, com.google.api.services.cloudresourcemanager.model.Project answer) {
        ProjectInfo info = ProjectInfo.fromPb(answer);
        return new Project(resourceManager, new ProjectInfo.BuilderImpl(info));
    }

    public static class Builder
    extends ProjectInfo.Builder {
        private final ResourceManager resourceManager;
        private final ProjectInfo.BuilderImpl infoBuilder;

        Builder(Project project) {
            this.resourceManager = project.resourceManager;
            this.infoBuilder = new ProjectInfo.BuilderImpl(project);
        }

        @Override
        public Builder name(String name) {
            this.infoBuilder.name(name);
            return this;
        }

        @Override
        public Builder projectId(String projectId) {
            this.infoBuilder.projectId(projectId);
            return this;
        }

        @Override
        public Builder addLabel(String key, String value) {
            this.infoBuilder.addLabel(key, value);
            return this;
        }

        @Override
        public Builder removeLabel(String key) {
            this.infoBuilder.removeLabel(key);
            return this;
        }

        @Override
        public Builder clearLabels() {
            this.infoBuilder.clearLabels();
            return this;
        }

        @Override
        public Builder labels(Map<String, String> labels) {
            this.infoBuilder.labels(labels);
            return this;
        }

        @Override
        Builder projectNumber(Long projectNumber) {
            this.infoBuilder.projectNumber(projectNumber);
            return this;
        }

        @Override
        Builder state(ProjectInfo.State state) {
            this.infoBuilder.state(state);
            return this;
        }

        @Override
        Builder createTimeMillis(Long createTimeMillis) {
            this.infoBuilder.createTimeMillis(createTimeMillis);
            return this;
        }

        @Override
        Builder parent(ProjectInfo.ResourceId parent) {
            this.infoBuilder.parent(parent);
            return this;
        }

        @Override
        public Project build() {
            return new Project(this.resourceManager, this.infoBuilder);
        }
    }
}

