/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager.testing;

import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.api.services.cloudresourcemanager.model.Policy;
import com.google.api.services.cloudresourcemanager.model.Project;
import com.google.api.services.cloudresourcemanager.model.SetIamPolicyRequest;
import com.google.api.services.cloudresourcemanager.model.TestIamPermissionsRequest;
import com.google.api.services.cloudresourcemanager.model.TestIamPermissionsResponse;
import com.google.cloud.AuthCredentials;
import com.google.cloud.resourcemanager.ResourceManagerOptions;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.joda.time.format.ISODateTimeFormat;

public class LocalResourceManagerHelper {
    private static final Logger log = Logger.getLogger(LocalResourceManagerHelper.class.getName());
    private static final JsonFactory jsonFactory = new JacksonFactory();
    private static final Random PROJECT_NUMBER_GENERATOR = new Random();
    private static final String VERSION = "v1beta1";
    private static final String CONTEXT = "/v1beta1/projects";
    private static final URI BASE_CONTEXT;
    private static final Set<String> SUPPORTED_COMPRESSION_ENCODINGS;
    private static final Pattern LIST_FIELDS_PATTERN;
    private static final String[] NO_FIELDS;
    private static final Set<Character> PERMISSIBLE_PROJECT_NAME_PUNCTUATION;
    private final HttpServer server;
    private final ConcurrentSkipListMap<String, Project> projects = new ConcurrentSkipListMap();
    private final Map<String, Policy> policies = new HashMap<String, Policy>();
    private final int port;

    private Response handlePost(HttpExchange exchange, String path) throws IOException {
        String requestBody = LocalResourceManagerHelper.decodeContent(exchange.getRequestHeaders(), exchange.getRequestBody());
        if (!path.contains(":")) {
            return this.create((Project)jsonFactory.fromString(requestBody, Project.class));
        }
        switch (path.split(":", 2)[1]) {
            case "undelete": {
                return this.undelete(LocalResourceManagerHelper.projectIdFromUri(path));
            }
            case "getIamPolicy": {
                return this.getPolicy(LocalResourceManagerHelper.projectIdFromUri(path));
            }
            case "setIamPolicy": {
                return this.replacePolicy(LocalResourceManagerHelper.projectIdFromUri(path), ((SetIamPolicyRequest)jsonFactory.fromString(requestBody, SetIamPolicyRequest.class)).getPolicy());
            }
            case "testIamPermissions": {
                return this.testPermissions(LocalResourceManagerHelper.projectIdFromUri(path), ((TestIamPermissionsRequest)jsonFactory.fromString(requestBody, TestIamPermissionsRequest.class)).getPermissions());
            }
        }
        return Error.BAD_REQUEST.response("The server could not understand the following request URI: POST " + path);
    }

    private static void writeResponse(HttpExchange exchange, Response response) {
        exchange.getResponseHeaders().set("Content-type", "application/json; charset=UTF-8");
        OutputStream outputStream = exchange.getResponseBody();
        try {
            exchange.getResponseHeaders().add("Connection", "close");
            exchange.sendResponseHeaders(response.code(), response.body().length());
            outputStream.write(response.body().getBytes(StandardCharsets.UTF_8));
            outputStream.close();
        }
        catch (IOException e) {
            log.log(Level.WARNING, "IOException encountered when sending response.", e);
        }
    }

    private static String decodeContent(Headers headers, InputStream inputStream) throws IOException {
        Object contentEncoding = headers.get("Content-encoding");
        InputStream input = inputStream;
        try {
            if (contentEncoding != null && !contentEncoding.isEmpty()) {
                String encoding = (String)contentEncoding.get(0);
                if (SUPPORTED_COMPRESSION_ENCODINGS.contains(encoding)) {
                    input = new GZIPInputStream(inputStream);
                } else if (!encoding.equals("identity")) {
                    throw new IOException("The request has the following unsupported HTTP content encoding: " + encoding);
                }
            }
            return new String(ByteStreams.toByteArray((InputStream)input), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IOException("Exception encountered when decoding request content.", e);
        }
    }

    private static String projectIdFromUri(String path) throws IOException {
        if (path.isEmpty()) {
            throw new IOException("The URI path '" + path + "' doesn't have a project ID.");
        }
        return path.split(":")[0];
    }

    private static String[] parseFields(String query) {
        if (query != null && !query.isEmpty()) {
            String[] querySplit = query.split("=");
            return querySplit.length > 1 ? querySplit[1].split(",") : null;
        }
        return null;
    }

    private static Map<String, Object> parseListOptions(String query) throws IOException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (query != null) {
            String[] args;
            block12: for (String arg : args = query.split("&")) {
                String[] argEntry = arg.split("=");
                switch (argEntry[0]) {
                    case "fields": {
                        Matcher matcher = LIST_FIELDS_PATTERN.matcher(argEntry[1]);
                        if (matcher.matches()) {
                            options.put("projectFields", matcher.group(2).split(","));
                            options.put("listFields", (matcher.group(1) + matcher.group(3)).split(","));
                            continue block12;
                        }
                        options.put("projectFields", NO_FIELDS);
                        options.put("listFields", argEntry[1].split(","));
                        continue block12;
                    }
                    case "filter": {
                        options.put("filter", argEntry[1].split(" "));
                        continue block12;
                    }
                    case "pageToken": {
                        options.put("pageToken", argEntry[1]);
                        continue block12;
                    }
                    case "pageSize": {
                        int pageSize = Integer.parseInt(argEntry[1]);
                        if (pageSize < 1) {
                            throw new IOException("Page size must be greater than 0.");
                        }
                        options.put("pageSize", pageSize);
                    }
                }
            }
        }
        return options;
    }

    private static String checkForProjectErrors(Project project) {
        if (project.getProjectId() == null) {
            return "Project ID cannot be empty.";
        }
        if (!LocalResourceManagerHelper.isValidIdOrLabel(project.getProjectId(), 6, 30)) {
            return "Project " + project.getProjectId() + " has an invalid ID." + " See https://cloud.google.com/resource-manager/reference/rest/" + VERSION + "/projects" + " for more information.";
        }
        if (project.getName() != null) {
            for (char c : project.getName().toCharArray()) {
                if (PERMISSIBLE_PROJECT_NAME_PUNCTUATION.contains(Character.valueOf(c)) || Character.isLetterOrDigit(c)) continue;
                return "Project " + project.getProjectId() + " has an invalid name." + " See https://cloud.google.com/resource-manager/reference/rest/" + VERSION + "/projects for more information.";
            }
        }
        if (project.getLabels() != null) {
            if (project.getLabels().size() > 256) {
                return "Project " + project.getProjectId() + " exceeds the limit of 256 labels.";
            }
            for (Map.Entry entry : project.getLabels().entrySet()) {
                if (LocalResourceManagerHelper.isValidIdOrLabel((String)entry.getKey(), 1, 63) && LocalResourceManagerHelper.isValidIdOrLabel((String)entry.getValue(), 0, 63)) continue;
                return "Project " + project.getProjectId() + " has an invalid label entry." + " See https://cloud.google.com/resource-manager/reference/rest/" + VERSION + "/projects for more information.";
            }
        }
        return null;
    }

    private static boolean isValidIdOrLabel(String value, int minLength, int maxLength) {
        for (char c : value.toCharArray()) {
            if (c == '-' || Character.isDigit(c) || Character.isLowerCase(c)) continue;
            return false;
        }
        if (!(value.isEmpty() || Character.isLetter(value.charAt(0)) && !value.endsWith("-"))) {
            return false;
        }
        return value.length() >= minLength && value.length() <= maxLength;
    }

    synchronized Response create(Project project) {
        String customErrorMessage = LocalResourceManagerHelper.checkForProjectErrors(project);
        if (customErrorMessage != null) {
            return Error.INVALID_ARGUMENT.response(customErrorMessage);
        }
        project.setLifecycleState("ACTIVE");
        project.setProjectNumber(Long.valueOf(Math.abs(PROJECT_NUMBER_GENERATOR.nextLong() % Long.MAX_VALUE)));
        project.setCreateTime(ISODateTimeFormat.dateTime().print(System.currentTimeMillis()));
        if (this.projects.putIfAbsent(project.getProjectId(), project) != null) {
            return Error.ALREADY_EXISTS.response("A project with the same project ID (" + project.getProjectId() + ") already exists.");
        }
        Policy emptyPolicy = new Policy().setBindings(Collections.emptyList()).setEtag(UUID.randomUUID().toString()).setVersion(Integer.valueOf(0));
        this.policies.put(project.getProjectId(), emptyPolicy);
        try {
            String createdProjectStr = jsonFactory.toString((Object)project);
            return new Response(200, createdProjectStr);
        }
        catch (IOException e) {
            return Error.INTERNAL_ERROR.response("Error serializing project " + project.getProjectId());
        }
    }

    synchronized Response delete(String projectId) {
        Project project = this.projects.get(projectId);
        if (project == null) {
            return Error.PERMISSION_DENIED.response("Error when deleting " + projectId + " because the project was not found.");
        }
        if (!project.getLifecycleState().equals("ACTIVE")) {
            return Error.FAILED_PRECONDITION.response("Error when deleting " + projectId + " because the lifecycle state was not ACTIVE.");
        }
        project.setLifecycleState("DELETE_REQUESTED");
        return new Response(200, "{}");
    }

    Response get(String projectId, String[] fields) {
        Project project = this.projects.get(projectId);
        if (project != null) {
            try {
                return new Response(200, jsonFactory.toString((Object)LocalResourceManagerHelper.extractFields(project, fields)));
            }
            catch (IOException e) {
                return Error.INTERNAL_ERROR.response("Error when serializing project " + project.getProjectId());
            }
        }
        return Error.PERMISSION_DENIED.response("Project " + projectId + " not found.");
    }

    Response list(Map<String, Object> options) {
        ArrayList<String> projectsSerialized = new ArrayList<String>();
        String[] filters = (String[])options.get("filter");
        if (filters != null && !LocalResourceManagerHelper.isValidFilter(filters)) {
            return Error.INVALID_ARGUMENT.response("Could not parse the filter.");
        }
        String[] projectFields = (String[])options.get("projectFields");
        int count = 0;
        String pageToken = (String)options.get("pageToken");
        Integer pageSize = (Integer)options.get("pageSize");
        String nextPageToken = null;
        SortedMap<String, Object> projectsToScan = this.projects;
        if (pageToken != null) {
            projectsToScan = this.projects.tailMap((Object)pageToken);
        }
        for (Project p : projectsToScan.values()) {
            if (pageSize != null && count >= pageSize) {
                nextPageToken = p.getProjectId();
                break;
            }
            boolean includeProject = LocalResourceManagerHelper.includeProject(p, filters);
            if (!includeProject) continue;
            ++count;
            try {
                projectsSerialized.add(jsonFactory.toString((Object)LocalResourceManagerHelper.extractFields(p, projectFields)));
            }
            catch (IOException e) {
                return Error.INTERNAL_ERROR.response("Error when serializing project " + p.getProjectId());
            }
        }
        Object[] listFields = (String[])options.get("listFields");
        StringBuilder responseBody = new StringBuilder();
        responseBody.append('{');
        if (projectFields == null || projectFields.length != 0) {
            responseBody.append("\"projects\": [");
            Joiner.on((String)",").appendTo(responseBody, projectsSerialized);
            responseBody.append(']');
        }
        if (nextPageToken != null && (listFields == null || ImmutableSet.copyOf((Object[])listFields).contains((Object)"nextPageToken"))) {
            if (responseBody.length() > 1) {
                responseBody.append(',');
            }
            responseBody.append("\"nextPageToken\": \"");
            responseBody.append(nextPageToken);
            responseBody.append('\"');
        }
        responseBody.append('}');
        return new Response(200, responseBody.toString());
    }

    private static boolean isValidFilter(String[] filters) {
        for (String filter : filters) {
            String field = filter.toLowerCase().split(":")[0];
            if ("id".equals(field) || "name".equals(field) || field.startsWith("labels.")) continue;
            return false;
        }
        return true;
    }

    private static boolean includeProject(Project project, String[] filters) {
        if (filters == null) {
            return true;
        }
        for (String filter : filters) {
            String labelValue;
            String[] filterEntry = filter.toLowerCase().split(":");
            String filterType = filterEntry[0];
            if ("id".equals(filterType)) {
                if (LocalResourceManagerHelper.satisfiesFilter(project.getProjectId(), filterEntry[1])) continue;
                return false;
            }
            if ("name".equals(filterType)) {
                if (LocalResourceManagerHelper.satisfiesFilter(project.getName(), filterEntry[1])) continue;
                return false;
            }
            if (!filterType.startsWith("labels.")) continue;
            String labelKey = filterType.substring("labels.".length());
            if (project.getLabels() == null || LocalResourceManagerHelper.satisfiesFilter(labelValue = (String)project.getLabels().get(labelKey), filterEntry[1])) continue;
            return false;
        }
        return true;
    }

    private static boolean satisfiesFilter(String projectValue, String filterValue) {
        if (projectValue == null) {
            return false;
        }
        return "*".equals(filterValue) || filterValue.equals(projectValue.toLowerCase());
    }

    private static Project extractFields(Project fullProject, String[] fields) {
        if (fields == null) {
            return fullProject;
        }
        Project project = new Project();
        String[] arr$ = fields;
        int len$ = arr$.length;
        block18: for (int i$ = 0; i$ < len$; ++i$) {
            String field;
            switch (field = arr$[i$]) {
                case "createTime": {
                    project.setCreateTime(fullProject.getCreateTime());
                    continue block18;
                }
                case "labels": {
                    project.setLabels(fullProject.getLabels());
                    continue block18;
                }
                case "lifecycleState": {
                    project.setLifecycleState(fullProject.getLifecycleState());
                    continue block18;
                }
                case "name": {
                    project.setName(fullProject.getName());
                    continue block18;
                }
                case "parent": {
                    project.setParent(fullProject.getParent());
                    continue block18;
                }
                case "projectId": {
                    project.setProjectId(fullProject.getProjectId());
                    continue block18;
                }
                case "projectNumber": {
                    project.setProjectNumber(fullProject.getProjectNumber());
                }
            }
        }
        return project;
    }

    synchronized Response replace(String projectId, Project project) {
        Project originalProject = this.projects.get(projectId);
        if (originalProject == null) {
            return Error.PERMISSION_DENIED.response("Error when replacing " + projectId + " because the project was not found.");
        }
        if (!originalProject.getLifecycleState().equals("ACTIVE")) {
            return Error.FAILED_PRECONDITION.response("Error when replacing " + projectId + " because the lifecycle state was not ACTIVE.");
        }
        if (!Objects.equal((Object)originalProject.getParent(), (Object)project.getParent())) {
            return Error.INVALID_ARGUMENT.response("The server currently only supports setting the parent once and does not allow unsetting it.");
        }
        project.setProjectId(projectId);
        project.setLifecycleState(originalProject.getLifecycleState());
        project.setCreateTime(originalProject.getCreateTime());
        project.setProjectNumber(originalProject.getProjectNumber());
        this.projects.replace(projectId, project);
        try {
            return new Response(200, jsonFactory.toString((Object)project));
        }
        catch (IOException e) {
            return Error.INTERNAL_ERROR.response("Error when serializing project " + projectId);
        }
    }

    synchronized Response undelete(String projectId) {
        Response response;
        Project project = this.projects.get(projectId);
        if (project == null) {
            response = Error.PERMISSION_DENIED.response("Error when undeleting " + projectId + " because the project was not found.");
        } else if (!project.getLifecycleState().equals("DELETE_REQUESTED")) {
            response = Error.FAILED_PRECONDITION.response("Error when undeleting " + projectId + " because the lifecycle state was not DELETE_REQUESTED.");
        } else {
            project.setLifecycleState("ACTIVE");
            response = new Response(200, "{}");
        }
        return response;
    }

    synchronized Response getPolicy(String projectId) {
        Policy policy = this.policies.get(projectId);
        if (policy == null) {
            return Error.PERMISSION_DENIED.response("Project " + projectId + " not found.");
        }
        try {
            return new Response(200, jsonFactory.toString((Object)policy));
        }
        catch (IOException e) {
            return Error.INTERNAL_ERROR.response("Error when serializing the IAM policy for " + projectId);
        }
    }

    synchronized Response replacePolicy(String projectId, Policy policy) {
        Policy originalPolicy = this.policies.get(projectId);
        if (originalPolicy == null) {
            return Error.PERMISSION_DENIED.response("Error when replacing the policy for " + projectId + " because the project was not found.");
        }
        String etag = policy.getEtag();
        if (etag != null && !originalPolicy.getEtag().equals(etag)) {
            return Error.ABORTED.response("Policy etag mismatch when replacing the policy for project " + projectId + ", please retry the read.");
        }
        policy.setEtag(UUID.randomUUID().toString());
        policy.setVersion(originalPolicy.getVersion());
        this.policies.put(projectId, policy);
        try {
            return new Response(200, jsonFactory.toString((Object)policy));
        }
        catch (IOException e) {
            return Error.INTERNAL_ERROR.response("Error when serializing the policy for project " + projectId);
        }
    }

    synchronized Response testPermissions(String projectId, List<String> permissions) {
        if (!this.projects.containsKey(projectId)) {
            return Error.PERMISSION_DENIED.response("Project " + projectId + " not found.");
        }
        try {
            return new Response(200, jsonFactory.toString((Object)new TestIamPermissionsResponse().setPermissions(permissions)));
        }
        catch (IOException e) {
            return Error.INTERNAL_ERROR.response("Error when serializing permissions " + permissions);
        }
    }

    private LocalResourceManagerHelper() {
        try {
            this.server = HttpServer.create(new InetSocketAddress(0), 0);
            this.port = this.server.getAddress().getPort();
            this.server.createContext(CONTEXT, new RequestHandler());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not bind the mock Resource Manager server.", e);
        }
    }

    public static LocalResourceManagerHelper create() {
        return new LocalResourceManagerHelper();
    }

    public ResourceManagerOptions options() {
        return ((ResourceManagerOptions.Builder)((ResourceManagerOptions.Builder)ResourceManagerOptions.builder().host("http://localhost:" + this.port)).authCredentials(AuthCredentials.noAuth())).build();
    }

    public void start() {
        this.server.start();
    }

    public void stop() {
        this.server.stop(1);
    }

    public synchronized boolean changeLifecycleState(String projectId, String lifecycleState) {
        Preconditions.checkArgument(("ACTIVE".equals(lifecycleState) || "DELETE_REQUESTED".equals(lifecycleState) || "DELETE_IN_PROGRESS".equals(lifecycleState) ? 1 : 0) != 0, (Object)"Lifecycle state must be ACTIVE, DELETE_REQUESTED, or DELETE_IN_PROGRESS");
        Project project = this.projects.get(Preconditions.checkNotNull((Object)projectId));
        if (project != null) {
            project.setLifecycleState(lifecycleState);
            return true;
        }
        return false;
    }

    public synchronized boolean removeProject(String projectId) {
        this.policies.remove(Preconditions.checkNotNull((Object)projectId));
        return this.projects.remove(projectId) != null;
    }

    static {
        SUPPORTED_COMPRESSION_ENCODINGS = ImmutableSet.of((Object)"gzip", (Object)"x-gzip");
        LIST_FIELDS_PATTERN = Pattern.compile("(.*?)projects\\((.*?)\\)(.*?)");
        NO_FIELDS = new String[0];
        try {
            BASE_CONTEXT = new URI(CONTEXT);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Could not initialize LocalResourceManagerHelper due to URISyntaxException.", e);
        }
        PERMISSIBLE_PROJECT_NAME_PUNCTUATION = ImmutableSet.of((Object)Character.valueOf('-'), (Object)Character.valueOf('\''), (Object)Character.valueOf('\"'), (Object)Character.valueOf(' '), (Object)Character.valueOf('!'));
    }

    private class RequestHandler
    implements HttpHandler {
        private RequestHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) {
            Response response;
            String path = BASE_CONTEXT.relativize(exchange.getRequestURI()).getPath();
            String requestMethod = exchange.getRequestMethod();
            try {
                switch (requestMethod) {
                    case "POST": {
                        response = LocalResourceManagerHelper.this.handlePost(exchange, path);
                        break;
                    }
                    case "DELETE": {
                        response = LocalResourceManagerHelper.this.delete(LocalResourceManagerHelper.projectIdFromUri(path));
                        break;
                    }
                    case "GET": {
                        if (!path.isEmpty()) {
                            response = LocalResourceManagerHelper.this.get(LocalResourceManagerHelper.projectIdFromUri(path), LocalResourceManagerHelper.parseFields(exchange.getRequestURI().getQuery()));
                            break;
                        }
                        response = LocalResourceManagerHelper.this.list(LocalResourceManagerHelper.parseListOptions(exchange.getRequestURI().getQuery()));
                        break;
                    }
                    case "PUT": {
                        String requestBody = LocalResourceManagerHelper.decodeContent(exchange.getRequestHeaders(), exchange.getRequestBody());
                        response = LocalResourceManagerHelper.this.replace(LocalResourceManagerHelper.projectIdFromUri(path), (Project)jsonFactory.fromString(requestBody, Project.class));
                        break;
                    }
                    default: {
                        response = Error.BAD_REQUEST.response("The server could not understand the following request URI: " + requestMethod + " " + path);
                        break;
                    }
                }
            }
            catch (IOException e) {
                response = Error.BAD_REQUEST.response(e.getMessage());
            }
            LocalResourceManagerHelper.writeResponse(exchange, response);
        }
    }

    private static enum Error {
        ABORTED(409, "global", "aborted", "ABORTED"),
        ALREADY_EXISTS(409, "global", "alreadyExists", "ALREADY_EXISTS"),
        PERMISSION_DENIED(403, "global", "forbidden", "PERMISSION_DENIED"),
        FAILED_PRECONDITION(400, "global", "failedPrecondition", "FAILED_PRECONDITION"),
        INVALID_ARGUMENT(400, "global", "badRequest", "INVALID_ARGUMENT"),
        BAD_REQUEST(400, "global", "badRequest", "BAD_REQUEST"),
        INTERNAL_ERROR(500, "global", "internalError", "INTERNAL_ERROR");

        private final int code;
        private final String domain;
        private final String reason;
        private final String status;

        private Error(int code, String domain, String reason, String status) {
            this.code = code;
            this.domain = domain;
            this.reason = reason;
            this.status = status;
        }

        Response response(String message) {
            try {
                return new Response(this.code, this.toJson(message));
            }
            catch (IOException e) {
                return INTERNAL_ERROR.response("Error when generating JSON error response");
            }
        }

        private String toJson(String message) throws IOException {
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("domain", this.domain);
            errors.put("message", message);
            errors.put("reason", this.reason);
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("errors", ImmutableList.of(errors));
            args.put("code", this.code);
            args.put("message", message);
            args.put("status", this.status);
            return jsonFactory.toString((Object)ImmutableMap.of((Object)"error", args));
        }
    }

    private static class Response {
        private final int code;
        private final String body;

        Response(int code, String body) {
            this.code = code;
            this.body = body;
        }

        int code() {
            return this.code;
        }

        String body() {
            return this.body;
        }
    }
}

