/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager;

import com.google.cloud.FieldSelector;
import com.google.cloud.Page;
import com.google.cloud.Policy;
import com.google.cloud.Service;
import com.google.cloud.resourcemanager.Option;
import com.google.cloud.resourcemanager.Project;
import com.google.cloud.resourcemanager.ProjectInfo;
import com.google.cloud.resourcemanager.ResourceManagerOptions;
import com.google.cloud.resourcemanager.spi.v1beta1.ResourceManagerRpc;
import com.google.common.collect.ImmutableList;
import java.util.List;

public interface ResourceManager
extends Service<ResourceManagerOptions> {
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";

    public Project create(ProjectInfo var1);

    public void delete(String var1);

    public Project get(String var1, ProjectGetOption ... var2);

    public Page<Project> list(ProjectListOption ... var1);

    public Project replace(ProjectInfo var1);

    public void undelete(String var1);

    public Policy getPolicy(String var1);

    public Policy replacePolicy(String var1, Policy var2);

    public List<Boolean> testPermissions(String var1, List<String> var2);

    public static class ProjectListOption
    extends Option {
        private static final long serialVersionUID = 7888768979702012328L;

        private ProjectListOption(ResourceManagerRpc.Option option, Object value) {
            super(option, value);
        }

        public static ProjectListOption filter(String filter) {
            return new ProjectListOption(ResourceManagerRpc.Option.FILTER, filter);
        }

        public static ProjectListOption pageToken(String pageToken) {
            return new ProjectListOption(ResourceManagerRpc.Option.PAGE_TOKEN, pageToken);
        }

        public static ProjectListOption pageSize(int pageSize) {
            return new ProjectListOption(ResourceManagerRpc.Option.PAGE_SIZE, pageSize);
        }

        public static ProjectListOption fields(ProjectField ... fields) {
            return new ProjectListOption(ResourceManagerRpc.Option.FIELDS, FieldSelector.Helper.listSelector((String)"projects", ProjectField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }
    }

    public static class ProjectGetOption
    extends Option {
        private static final long serialVersionUID = 270185129961146874L;

        private ProjectGetOption(ResourceManagerRpc.Option option, Object value) {
            super(option, value);
        }

        public static ProjectGetOption fields(ProjectField ... fields) {
            return new ProjectGetOption(ResourceManagerRpc.Option.FIELDS, FieldSelector.Helper.selector(ProjectField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }
    }

    public static enum ProjectField implements FieldSelector
    {
        PROJECT_ID("projectId"),
        NAME("name"),
        LABELS("labels"),
        PROJECT_NUMBER("projectNumber"),
        STATE("lifecycleState"),
        CREATE_TIME("createTime");

        static final List<? extends FieldSelector> REQUIRED_FIELDS;
        private final String selector;

        private ProjectField(String selector) {
            this.selector = selector;
        }

        public String getSelector() {
            return this.selector;
        }

        static {
            REQUIRED_FIELDS = ImmutableList.of((Object)((Object)PROJECT_ID));
        }
    }
}

