/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager.spi.v1beta1;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.api.services.cloudresourcemanager.Cloudresourcemanager;
import com.google.api.services.cloudresourcemanager.model.GetIamPolicyRequest;
import com.google.api.services.cloudresourcemanager.model.ListProjectsResponse;
import com.google.api.services.cloudresourcemanager.model.Policy;
import com.google.api.services.cloudresourcemanager.model.Project;
import com.google.api.services.cloudresourcemanager.model.SetIamPolicyRequest;
import com.google.api.services.cloudresourcemanager.model.TestIamPermissionsRequest;
import com.google.api.services.cloudresourcemanager.model.TestIamPermissionsResponse;
import com.google.cloud.HttpTransportOptions;
import com.google.cloud.ServiceOptions;
import com.google.cloud.resourcemanager.ResourceManagerException;
import com.google.cloud.resourcemanager.ResourceManagerOptions;
import com.google.cloud.resourcemanager.spi.v1beta1.ResourceManagerRpc;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class HttpResourceManagerRpc
implements ResourceManagerRpc {
    private final Cloudresourcemanager resourceManager;

    public HttpResourceManagerRpc(ResourceManagerOptions options) {
        HttpTransportOptions transportOptions = (HttpTransportOptions)options.getTransportOptions();
        HttpTransport transport = transportOptions.getHttpTransportFactory().create();
        HttpRequestInitializer initializer = transportOptions.getHttpRequestInitializer((ServiceOptions)options);
        this.resourceManager = new Cloudresourcemanager.Builder(transport, (JsonFactory)new JacksonFactory(), initializer).setRootUrl(options.getHost()).setApplicationName(options.getApplicationName()).build();
    }

    private static ResourceManagerException translate(IOException exception) {
        return new ResourceManagerException(exception);
    }

    @Override
    public Project create(Project project) {
        try {
            return (Project)this.resourceManager.projects().create(project).execute();
        }
        catch (IOException ex) {
            throw HttpResourceManagerRpc.translate(ex);
        }
    }

    @Override
    public void delete(String projectId) {
        try {
            this.resourceManager.projects().delete(projectId).execute();
        }
        catch (IOException ex) {
            throw HttpResourceManagerRpc.translate(ex);
        }
    }

    @Override
    public Project get(String projectId, Map<ResourceManagerRpc.Option, ?> options) {
        try {
            return (Project)this.resourceManager.projects().get(projectId).setFields(ResourceManagerRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            ResourceManagerException translated = HttpResourceManagerRpc.translate(ex);
            if (translated.getCode() == 403 || translated.getCode() == 404) {
                return null;
            }
            throw translated;
        }
    }

    @Override
    public ResourceManagerRpc.Tuple<String, Iterable<Project>> list(Map<ResourceManagerRpc.Option, ?> options) {
        try {
            ListProjectsResponse response = (ListProjectsResponse)this.resourceManager.projects().list().setFields(ResourceManagerRpc.Option.FIELDS.getString(options)).setFilter(ResourceManagerRpc.Option.FILTER.getString(options)).setPageSize(ResourceManagerRpc.Option.PAGE_SIZE.getInt(options)).setPageToken(ResourceManagerRpc.Option.PAGE_TOKEN.getString(options)).execute();
            return ResourceManagerRpc.Tuple.of(response.getNextPageToken(), response.getProjects());
        }
        catch (IOException ex) {
            throw HttpResourceManagerRpc.translate(ex);
        }
    }

    @Override
    public void undelete(String projectId) {
        try {
            this.resourceManager.projects().undelete(projectId).execute();
        }
        catch (IOException ex) {
            throw HttpResourceManagerRpc.translate(ex);
        }
    }

    @Override
    public Project replace(Project project) {
        try {
            return (Project)this.resourceManager.projects().update(project.getProjectId(), project).execute();
        }
        catch (IOException ex) {
            throw HttpResourceManagerRpc.translate(ex);
        }
    }

    @Override
    public Policy getPolicy(String projectId) throws ResourceManagerException {
        try {
            return (Policy)this.resourceManager.projects().getIamPolicy(projectId, new GetIamPolicyRequest()).execute();
        }
        catch (IOException ex) {
            ResourceManagerException translated = HttpResourceManagerRpc.translate(ex);
            if (translated.getCode() == 403) {
                return null;
            }
            throw translated;
        }
    }

    @Override
    public Policy replacePolicy(String projectId, Policy newPolicy) throws ResourceManagerException {
        try {
            return (Policy)this.resourceManager.projects().setIamPolicy(projectId, new SetIamPolicyRequest().setPolicy(newPolicy)).execute();
        }
        catch (IOException ex) {
            throw HttpResourceManagerRpc.translate(ex);
        }
    }

    @Override
    public List<Boolean> testPermissions(String projectId, List<String> permissions) throws ResourceManagerException {
        try {
            TestIamPermissionsResponse response = (TestIamPermissionsResponse)this.resourceManager.projects().testIamPermissions(projectId, new TestIamPermissionsRequest().setPermissions(permissions)).execute();
            ImmutableSet permissionsOwned = ImmutableSet.copyOf((Collection)((Collection)MoreObjects.firstNonNull((Object)response.getPermissions(), (Object)ImmutableList.of())));
            ImmutableList.Builder answer = ImmutableList.builder();
            for (String p : permissions) {
                answer.add((Object)permissionsOwned.contains(p));
            }
            return answer.build();
        }
        catch (IOException ex) {
            throw HttpResourceManagerRpc.translate(ex);
        }
    }
}

