/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager;

import com.google.cloud.HttpTransportOptions;
import com.google.cloud.ServiceDefaults;
import com.google.cloud.ServiceOptions;
import com.google.cloud.ServiceRpc;
import com.google.cloud.TransportOptions;
import com.google.cloud.resourcemanager.ResourceManager;
import com.google.cloud.resourcemanager.ResourceManagerFactory;
import com.google.cloud.resourcemanager.ResourceManagerImpl;
import com.google.cloud.resourcemanager.spi.ResourceManagerRpcFactory;
import com.google.cloud.resourcemanager.spi.v1beta1.HttpResourceManagerRpc;
import com.google.cloud.resourcemanager.spi.v1beta1.ResourceManagerRpc;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class ResourceManagerOptions
extends ServiceOptions<ResourceManager, ResourceManagerOptions> {
    private static final long serialVersionUID = 624147474447836183L;
    private static final String API_SHORT_NAME = "ResourceManager";
    private static final String GCRM_SCOPE = "https://www.googleapis.com/auth/cloud-platform";
    private static final Set<String> SCOPES = ImmutableSet.of((Object)"https://www.googleapis.com/auth/cloud-platform");
    private static final String DEFAULT_HOST = "https://cloudresourcemanager.googleapis.com";

    public static ResourceManagerOptions getDefaultInstance() {
        return ResourceManagerOptions.newBuilder().build();
    }

    protected String getDefaultHost() {
        return DEFAULT_HOST;
    }

    private ResourceManagerOptions(Builder builder) {
        super(ResourceManagerFactory.class, ResourceManagerRpcFactory.class, (ServiceOptions.Builder)builder, (ServiceDefaults)new ResourceManagerDefaults());
    }

    protected boolean projectIdRequired() {
        return false;
    }

    public static HttpTransportOptions getDefaultHttpTransportOptions() {
        return HttpTransportOptions.newBuilder().build();
    }

    protected Set<String> getScopes() {
        return SCOPES;
    }

    protected ResourceManagerRpc getResourceManagerRpcV1Beta1() {
        return (ResourceManagerRpc)this.getRpc();
    }

    public boolean equals(Object obj) {
        return obj instanceof ResourceManagerOptions && this.baseEquals((ResourceManagerOptions)((Object)obj));
    }

    public int hashCode() {
        return this.baseHashCode();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static class ResourceManagerDefaults
    implements ServiceDefaults<ResourceManager, ResourceManagerOptions> {
        private ResourceManagerDefaults() {
        }

        public ResourceManagerFactory getDefaultServiceFactory() {
            return DefaultResourceManagerFactory.INSTANCE;
        }

        public ResourceManagerRpcFactory getDefaultRpcFactory() {
            return DefaultResourceManagerRpcFactory.INSTANCE;
        }

        public TransportOptions getDefaultTransportOptions() {
            return ResourceManagerOptions.getDefaultHttpTransportOptions();
        }
    }

    public static class Builder
    extends ServiceOptions.Builder<ResourceManager, ResourceManagerOptions, Builder> {
        private Builder() {
        }

        private Builder(ResourceManagerOptions options) {
            super((ServiceOptions)options);
        }

        public Builder setTransportOptions(TransportOptions transportOptions) {
            if (!(transportOptions instanceof HttpTransportOptions)) {
                throw new IllegalArgumentException("Only http transport is allowed for ResourceManager.");
            }
            return (Builder)super.setTransportOptions(transportOptions);
        }

        public ResourceManagerOptions build() {
            return new ResourceManagerOptions(this);
        }
    }

    public static class DefaultResourceManagerRpcFactory
    implements ResourceManagerRpcFactory {
        private static final ResourceManagerRpcFactory INSTANCE = new DefaultResourceManagerRpcFactory();

        public ServiceRpc create(ResourceManagerOptions options) {
            return new HttpResourceManagerRpc(options);
        }
    }

    public static class DefaultResourceManagerFactory
    implements ResourceManagerFactory {
        private static final ResourceManagerFactory INSTANCE = new DefaultResourceManagerFactory();

        public ResourceManager create(ResourceManagerOptions options) {
            return new ResourceManagerImpl(options);
        }
    }
}

