/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager;

import com.google.api.client.util.Data;
import com.google.api.services.cloudresourcemanager.model.Project;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;

public class ProjectInfo
implements Serializable {
    private static final long serialVersionUID = 9148970963697734236L;
    private final String name;
    private final String projectId;
    private final Map<String, String> labels;
    private final Long projectNumber;
    private final State state;
    private final Long createTimeMillis;
    private final ResourceId parent;

    ProjectInfo(BuilderImpl builder) {
        this.name = builder.name;
        this.projectId = builder.projectId;
        this.labels = ImmutableMap.copyOf((Map)builder.labels);
        this.projectNumber = builder.projectNumber;
        this.state = builder.state;
        this.createTimeMillis = builder.createTimeMillis;
        this.parent = builder.parent;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getName() {
        return Data.isNull((Object)this.name) ? null : this.name;
    }

    public Long getProjectNumber() {
        return this.projectNumber;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public State getState() {
        return this.state;
    }

    ResourceId getParent() {
        return this.parent;
    }

    public Long getCreateTimeMillis() {
        return this.createTimeMillis;
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(ProjectInfo.class) && Objects.equals(this.toPb(), ((ProjectInfo)obj).toPb());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.projectId, this.labels, this.projectNumber, this.state, this.createTimeMillis, this.parent});
    }

    public static Builder newBuilder(String id) {
        return new BuilderImpl(id);
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    Project toPb() {
        Project projectPb = new Project();
        projectPb.setName(this.name);
        projectPb.setProjectId(this.projectId);
        projectPb.setLabels(this.labels);
        projectPb.setProjectNumber(this.projectNumber);
        if (this.state != null) {
            projectPb.setLifecycleState(this.state.toString());
        }
        if (this.createTimeMillis != null) {
            projectPb.setCreateTime(ISODateTimeFormat.dateTime().withZoneUTC().print(this.createTimeMillis.longValue()));
        }
        if (this.parent != null) {
            projectPb.setParent(this.parent.toPb());
        }
        return projectPb;
    }

    static ProjectInfo fromPb(Project projectPb) {
        Builder builder = ProjectInfo.newBuilder(projectPb.getProjectId()).setProjectNumber(projectPb.getProjectNumber());
        if (projectPb.getName() != null && !projectPb.getName().equals("Unnamed")) {
            builder.setName(projectPb.getName());
        }
        if (projectPb.getLabels() != null) {
            builder.setLabels(projectPb.getLabels());
        }
        if (projectPb.getLifecycleState() != null) {
            builder.setState(State.valueOf(projectPb.getLifecycleState()));
        }
        if (projectPb.getCreateTime() != null) {
            builder.setCreateTimeMillis(DateTime.parse((String)projectPb.getCreateTime()).getMillis());
        }
        if (projectPb.getParent() != null) {
            builder.setParent(ResourceId.fromPb(projectPb.getParent()));
        }
        return builder.build();
    }

    static class BuilderImpl
    extends Builder {
        private String name;
        private String projectId;
        private Map<String, String> labels = new HashMap<String, String>();
        private Long projectNumber;
        private State state;
        private Long createTimeMillis;
        private ResourceId parent;

        BuilderImpl(String projectId) {
            this.projectId = projectId;
        }

        BuilderImpl(ProjectInfo info) {
            this.name = info.name;
            this.projectId = info.projectId;
            this.labels.putAll(info.labels);
            this.projectNumber = info.projectNumber;
            this.state = info.state;
            this.createTimeMillis = info.createTimeMillis;
            this.parent = info.parent;
        }

        @Override
        public Builder setName(String name) {
            this.name = (String)MoreObjects.firstNonNull((Object)name, (Object)Data.nullOf(String.class));
            return this;
        }

        @Override
        public Builder setProjectId(String projectId) {
            this.projectId = (String)Preconditions.checkNotNull((Object)projectId);
            return this;
        }

        @Override
        public Builder addLabel(String key, String value) {
            this.labels.put(key, value);
            return this;
        }

        @Override
        public Builder removeLabel(String key) {
            this.labels.remove(key);
            return this;
        }

        @Override
        public Builder clearLabels() {
            this.labels.clear();
            return this;
        }

        @Override
        public Builder setLabels(Map<String, String> labels) {
            this.labels = Maps.newHashMap((Map)((Map)Preconditions.checkNotNull(labels)));
            return this;
        }

        @Override
        Builder setProjectNumber(Long projectNumber) {
            this.projectNumber = projectNumber;
            return this;
        }

        @Override
        Builder setState(State state) {
            this.state = state;
            return this;
        }

        @Override
        Builder setCreateTimeMillis(Long createTimeMillis) {
            this.createTimeMillis = createTimeMillis;
            return this;
        }

        @Override
        Builder setParent(ResourceId parent) {
            this.parent = parent;
            return this;
        }

        @Override
        public ProjectInfo build() {
            return new ProjectInfo(this);
        }
    }

    public static abstract class Builder {
        public abstract Builder setName(String var1);

        public abstract Builder setProjectId(String var1);

        public abstract Builder addLabel(String var1, String var2);

        public abstract Builder removeLabel(String var1);

        public abstract Builder clearLabels();

        public abstract Builder setLabels(Map<String, String> var1);

        abstract Builder setProjectNumber(Long var1);

        abstract Builder setState(State var1);

        abstract Builder setCreateTimeMillis(Long var1);

        abstract Builder setParent(ResourceId var1);

        public abstract ProjectInfo build();
    }

    static class ResourceId
    implements Serializable {
        private static final long serialVersionUID = -325199985993344726L;
        private final String id;
        private final String type;

        ResourceId(String id, String type) {
            this.id = (String)Preconditions.checkNotNull((Object)id);
            this.type = (String)Preconditions.checkNotNull((Object)type);
        }

        String getId() {
            return this.id;
        }

        String type() {
            return this.type;
        }

        public boolean equals(Object obj) {
            return obj instanceof ResourceId && Objects.equals(this.toPb(), ((ResourceId)obj).toPb());
        }

        public int hashCode() {
            return Objects.hash(this.id, this.type);
        }

        com.google.api.services.cloudresourcemanager.model.ResourceId toPb() {
            com.google.api.services.cloudresourcemanager.model.ResourceId resourceIdPb = new com.google.api.services.cloudresourcemanager.model.ResourceId();
            resourceIdPb.setId(this.id);
            resourceIdPb.setType(this.type.toLowerCase());
            return resourceIdPb;
        }

        static ResourceId fromPb(com.google.api.services.cloudresourcemanager.model.ResourceId resourceIdPb) {
            return new ResourceId(resourceIdPb.getId(), resourceIdPb.getType());
        }
    }

    public static enum State {
        LIFECYCLE_STATE_UNSPECIFIED,
        ACTIVE,
        DELETE_REQUESTED,
        DELETE_IN_PROGRESS;

    }
}

