/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager;

import com.google.cloud.HttpTransportOptions;
import com.google.cloud.ServiceDefaults;
import com.google.cloud.ServiceOptions;
import com.google.cloud.TransportOptions;
import com.google.cloud.resourcemanager.ResourceManager;
import com.google.cloud.resourcemanager.ResourceManagerFactory;
import com.google.cloud.resourcemanager.ResourceManagerImpl;
import com.google.cloud.resourcemanager.spi.DefaultResourceManagerRpc;
import com.google.cloud.resourcemanager.spi.ResourceManagerRpc;
import com.google.cloud.resourcemanager.spi.ResourceManagerRpcFactory;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class ResourceManagerOptions
extends ServiceOptions<ResourceManager, ResourceManagerRpc, ResourceManagerOptions> {
    private static final long serialVersionUID = 624147474447836183L;
    private static final String API_SHORT_NAME = "ResourceManager";
    private static final String GCRM_SCOPE = "https://www.googleapis.com/auth/cloud-platform";
    private static final Set<String> SCOPES = ImmutableSet.of((Object)"https://www.googleapis.com/auth/cloud-platform");
    private static final String DEFAULT_HOST = "https://cloudresourcemanager.googleapis.com";

    public static ResourceManagerOptions getDefaultInstance() {
        return ResourceManagerOptions.newBuilder().build();
    }

    protected String getDefaultHost() {
        return DEFAULT_HOST;
    }

    private ResourceManagerOptions(Builder builder) {
        super(ResourceManagerFactory.class, ResourceManagerRpcFactory.class, (ServiceOptions.Builder)builder, (ServiceDefaults)new ResourceManagerDefaults());
    }

    protected boolean projectIdRequired() {
        return false;
    }

    public static HttpTransportOptions getDefaultHttpTransportOptions() {
        return HttpTransportOptions.newBuilder().build();
    }

    protected Set<String> getScopes() {
        return SCOPES;
    }

    public boolean equals(Object obj) {
        return obj instanceof ResourceManagerOptions && this.baseEquals((ResourceManagerOptions)((Object)obj));
    }

    public int hashCode() {
        return this.baseHashCode();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static class ResourceManagerDefaults
    implements ServiceDefaults<ResourceManager, ResourceManagerRpc, ResourceManagerOptions> {
        private ResourceManagerDefaults() {
        }

        public ResourceManagerFactory getDefaultServiceFactory() {
            return DefaultResourceManagerFactory.INSTANCE;
        }

        public ResourceManagerRpcFactory getDefaultRpcFactory() {
            return DefaultResourceManagerRpcFactory.INSTANCE;
        }

        public TransportOptions getDefaultTransportOptions() {
            return ResourceManagerOptions.getDefaultHttpTransportOptions();
        }
    }

    public static class Builder
    extends ServiceOptions.Builder<ResourceManager, ResourceManagerRpc, ResourceManagerOptions, Builder> {
        private Builder() {
        }

        private Builder(ResourceManagerOptions options) {
            super((ServiceOptions)options);
        }

        public Builder setTransportOptions(TransportOptions transportOptions) {
            if (!(transportOptions instanceof HttpTransportOptions)) {
                throw new IllegalArgumentException("Only http transport is allowed for ResourceManager.");
            }
            return (Builder)super.setTransportOptions(transportOptions);
        }

        public ResourceManagerOptions build() {
            return new ResourceManagerOptions(this);
        }
    }

    public static class DefaultResourceManagerRpcFactory
    implements ResourceManagerRpcFactory {
        private static final ResourceManagerRpcFactory INSTANCE = new DefaultResourceManagerRpcFactory();

        public ResourceManagerRpc create(ResourceManagerOptions options) {
            return new DefaultResourceManagerRpc(options);
        }
    }

    public static class DefaultResourceManagerFactory
    implements ResourceManagerFactory {
        private static final ResourceManagerFactory INSTANCE = new DefaultResourceManagerFactory();

        public ResourceManager create(ResourceManagerOptions options) {
            return new ResourceManagerImpl(options);
        }
    }
}

