/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.redis.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.redis.v1.CloudRedisSettings;
import com.google.cloud.redis.v1.CreateInstanceRequest;
import com.google.cloud.redis.v1.DeleteInstanceRequest;
import com.google.cloud.redis.v1.GetInstanceRequest;
import com.google.cloud.redis.v1.Instance;
import com.google.cloud.redis.v1.InstanceName;
import com.google.cloud.redis.v1.ListInstancesRequest;
import com.google.cloud.redis.v1.ListInstancesResponse;
import com.google.cloud.redis.v1.LocationName;
import com.google.cloud.redis.v1.OperationMetadata;
import com.google.cloud.redis.v1.UpdateInstanceRequest;
import com.google.cloud.redis.v1.stub.CloudRedisStub;
import com.google.cloud.redis.v1.stub.CloudRedisStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class CloudRedisClient
implements BackgroundResource {
    private final CloudRedisSettings settings;
    private final CloudRedisStub stub;
    private final OperationsClient operationsClient;

    public static final CloudRedisClient create() throws IOException {
        return CloudRedisClient.create(CloudRedisSettings.newBuilder().build());
    }

    public static final CloudRedisClient create(CloudRedisSettings settings) throws IOException {
        return new CloudRedisClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final CloudRedisClient create(CloudRedisStub stub) {
        return new CloudRedisClient(stub);
    }

    protected CloudRedisClient(CloudRedisSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CloudRedisStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected CloudRedisClient(CloudRedisStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final CloudRedisSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CloudRedisStub getStub() {
        return this.stub;
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListInstancesPagedResponse listInstances(LocationName parent) {
        ListInstancesRequest request = ListInstancesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listInstances(request);
    }

    public final ListInstancesPagedResponse listInstances(String parent) {
        ListInstancesRequest request = ListInstancesRequest.newBuilder().setParent(parent).build();
        return this.listInstances(request);
    }

    public final ListInstancesPagedResponse listInstances(ListInstancesRequest request) {
        return (ListInstancesPagedResponse)((Object)this.listInstancesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInstancesRequest, ListInstancesPagedResponse> listInstancesPagedCallable() {
        return this.stub.listInstancesPagedCallable();
    }

    public final UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable() {
        return this.stub.listInstancesCallable();
    }

    public final Instance getInstance(InstanceName name) {
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getInstance(request);
    }

    public final Instance getInstance(String name) {
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setName(name).build();
        return this.getInstance(request);
    }

    public final Instance getInstance(GetInstanceRequest request) {
        return (Instance)this.getInstanceCallable().call((Object)request);
    }

    public final UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable() {
        return this.stub.getInstanceCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Instance, OperationMetadata> createInstanceAsync(LocationName parent, String instanceId, Instance instance) {
        CreateInstanceRequest request = CreateInstanceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setInstanceId(instanceId).setInstance(instance).build();
        return this.createInstanceAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Instance, OperationMetadata> createInstanceAsync(String parent, String instanceId, Instance instance) {
        CreateInstanceRequest request = CreateInstanceRequest.newBuilder().setParent(parent).setInstanceId(instanceId).setInstance(instance).build();
        return this.createInstanceAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Instance, OperationMetadata> createInstanceAsync(CreateInstanceRequest request) {
        return this.createInstanceOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationCallable() {
        return this.stub.createInstanceOperationCallable();
    }

    public final UnaryCallable<CreateInstanceRequest, Operation> createInstanceCallable() {
        return this.stub.createInstanceCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Instance, OperationMetadata> updateInstanceAsync(FieldMask updateMask, Instance instance) {
        UpdateInstanceRequest request = UpdateInstanceRequest.newBuilder().setUpdateMask(updateMask).setInstance(instance).build();
        return this.updateInstanceAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Instance, OperationMetadata> updateInstanceAsync(UpdateInstanceRequest request) {
        return this.updateInstanceOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationCallable() {
        return this.stub.updateInstanceOperationCallable();
    }

    public final UnaryCallable<UpdateInstanceRequest, Operation> updateInstanceCallable() {
        return this.stub.updateInstanceCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> deleteInstanceAsync(InstanceName name) {
        DeleteInstanceRequest request = DeleteInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteInstanceAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> deleteInstanceAsync(String name) {
        DeleteInstanceRequest request = DeleteInstanceRequest.newBuilder().setName(name).build();
        return this.deleteInstanceAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> deleteInstanceAsync(DeleteInstanceRequest request) {
        return this.deleteInstanceOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationCallable() {
        return this.stub.deleteInstanceOperationCallable();
    }

    public final UnaryCallable<DeleteInstanceRequest, Operation> deleteInstanceCallable() {
        return this.stub.deleteInstanceCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListInstancesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage, ListInstancesFixedSizeCollection> {
        private ListInstancesFixedSizeCollection(List<ListInstancesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInstancesFixedSizeCollection createEmptyCollection() {
            return new ListInstancesFixedSizeCollection(null, 0);
        }

        protected ListInstancesFixedSizeCollection createCollection(List<ListInstancesPage> pages, int collectionSize) {
            return new ListInstancesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInstancesPage
    extends AbstractPage<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage> {
        private ListInstancesPage(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ListInstancesResponse response) {
            super(context, (Object)response);
        }

        private static ListInstancesPage createEmptyPage() {
            return new ListInstancesPage(null, null);
        }

        protected ListInstancesPage createPage(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ListInstancesResponse response) {
            return new ListInstancesPage(context, response);
        }

        public ApiFuture<ListInstancesPage> createPageAsync(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ApiFuture<ListInstancesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInstancesPagedResponse
    extends AbstractPagedListResponse<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage, ListInstancesFixedSizeCollection> {
        public static ApiFuture<ListInstancesPagedResponse> createAsync(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ApiFuture<ListInstancesResponse> futureResponse) {
            ApiFuture<ListInstancesPage> futurePage = ListInstancesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListInstancesPage, ListInstancesPagedResponse>(){

                public ListInstancesPagedResponse apply(ListInstancesPage input) {
                    return new ListInstancesPagedResponse(input);
                }
            });
        }

        private ListInstancesPagedResponse(ListInstancesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInstancesFixedSizeCollection.createEmptyCollection());
        }
    }
}

