/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.redis.cluster.v1.stub;

import com.google.api.HttpRule;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.redis.cluster.v1.Backup;
import com.google.cloud.redis.cluster.v1.BackupClusterRequest;
import com.google.cloud.redis.cluster.v1.BackupCollection;
import com.google.cloud.redis.cluster.v1.CertificateAuthority;
import com.google.cloud.redis.cluster.v1.CloudRedisClusterClient;
import com.google.cloud.redis.cluster.v1.Cluster;
import com.google.cloud.redis.cluster.v1.CreateClusterRequest;
import com.google.cloud.redis.cluster.v1.DeleteBackupRequest;
import com.google.cloud.redis.cluster.v1.DeleteClusterRequest;
import com.google.cloud.redis.cluster.v1.ExportBackupRequest;
import com.google.cloud.redis.cluster.v1.GetBackupCollectionRequest;
import com.google.cloud.redis.cluster.v1.GetBackupRequest;
import com.google.cloud.redis.cluster.v1.GetClusterCertificateAuthorityRequest;
import com.google.cloud.redis.cluster.v1.GetClusterRequest;
import com.google.cloud.redis.cluster.v1.ListBackupCollectionsRequest;
import com.google.cloud.redis.cluster.v1.ListBackupCollectionsResponse;
import com.google.cloud.redis.cluster.v1.ListBackupsRequest;
import com.google.cloud.redis.cluster.v1.ListBackupsResponse;
import com.google.cloud.redis.cluster.v1.ListClustersRequest;
import com.google.cloud.redis.cluster.v1.ListClustersResponse;
import com.google.cloud.redis.cluster.v1.RescheduleClusterMaintenanceRequest;
import com.google.cloud.redis.cluster.v1.UpdateClusterRequest;
import com.google.cloud.redis.cluster.v1.stub.CloudRedisClusterStub;
import com.google.cloud.redis.cluster.v1.stub.CloudRedisClusterStubSettings;
import com.google.cloud.redis.cluster.v1.stub.HttpJsonCloudRedisClusterCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HttpJsonCloudRedisClusterStub
extends CloudRedisClusterStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Empty.getDescriptor()).add(Cluster.getDescriptor()).add(Any.getDescriptor()).add(Backup.getDescriptor()).build();
    private static final ApiMethodDescriptor<ListClustersRequest, ListClustersResponse> listClustersMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.redis.cluster.v1.CloudRedisCluster/ListClusters").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/clusters", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListClustersResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetClusterRequest, Cluster> getClusterMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.redis.cluster.v1.CloudRedisCluster/GetCluster").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/clusters/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Cluster.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateClusterRequest, Operation> updateClusterMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.redis.cluster.v1.CloudRedisCluster/UpdateCluster").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{cluster.name=projects/*/locations/*/clusters/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "cluster.name", (Object)request.getCluster().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("cluster", (Message)request.getCluster(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteClusterRequest, Operation> deleteClusterMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.redis.cluster.v1.CloudRedisCluster/DeleteCluster").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/clusters/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<CreateClusterRequest, Operation> createClusterMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.redis.cluster.v1.CloudRedisCluster/CreateCluster").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/clusters", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "clusterId", (Object)request.getClusterId());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("cluster", (Message)request.getCluster(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetClusterCertificateAuthorityRequest, CertificateAuthority> getClusterCertificateAuthorityMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.redis.cluster.v1.CloudRedisCluster/GetClusterCertificateAuthority").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/clusters/*/certificateAuthority}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CertificateAuthority.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<RescheduleClusterMaintenanceRequest, Operation> rescheduleClusterMaintenanceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.redis.cluster.v1.CloudRedisCluster/RescheduleClusterMaintenance").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/clusters/*}:rescheduleClusterMaintenance", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ListBackupCollectionsRequest, ListBackupCollectionsResponse> listBackupCollectionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.redis.cluster.v1.CloudRedisCluster/ListBackupCollections").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/backupCollections", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListBackupCollectionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetBackupCollectionRequest, BackupCollection> getBackupCollectionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.redis.cluster.v1.CloudRedisCluster/GetBackupCollection").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/backupCollections/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)BackupCollection.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListBackupsRequest, ListBackupsResponse> listBackupsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.redis.cluster.v1.CloudRedisCluster/ListBackups").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/backupCollections/*}/backups", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListBackupsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetBackupRequest, Backup> getBackupMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.redis.cluster.v1.CloudRedisCluster/GetBackup").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/backupCollections/*/backups/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Backup.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteBackupRequest, Operation> deleteBackupMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.redis.cluster.v1.CloudRedisCluster/DeleteBackup").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/backupCollections/*/backups/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ExportBackupRequest, Operation> exportBackupMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.redis.cluster.v1.CloudRedisCluster/ExportBackup").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/backupCollections/*/backups/*}:export", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<BackupClusterRequest, Operation> backupClusterMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.redis.cluster.v1.CloudRedisCluster/BackupCluster").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/clusters/*}:backup", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/ListLocations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*}/locations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListLocationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/GetLocation").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Location.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListClustersRequest, ListClustersResponse> listClustersCallable;
    private final UnaryCallable<ListClustersRequest, CloudRedisClusterClient.ListClustersPagedResponse> listClustersPagedCallable;
    private final UnaryCallable<GetClusterRequest, Cluster> getClusterCallable;
    private final UnaryCallable<UpdateClusterRequest, Operation> updateClusterCallable;
    private final OperationCallable<UpdateClusterRequest, Cluster, Any> updateClusterOperationCallable;
    private final UnaryCallable<DeleteClusterRequest, Operation> deleteClusterCallable;
    private final OperationCallable<DeleteClusterRequest, Empty, Any> deleteClusterOperationCallable;
    private final UnaryCallable<CreateClusterRequest, Operation> createClusterCallable;
    private final OperationCallable<CreateClusterRequest, Cluster, Any> createClusterOperationCallable;
    private final UnaryCallable<GetClusterCertificateAuthorityRequest, CertificateAuthority> getClusterCertificateAuthorityCallable;
    private final UnaryCallable<RescheduleClusterMaintenanceRequest, Operation> rescheduleClusterMaintenanceCallable;
    private final OperationCallable<RescheduleClusterMaintenanceRequest, Cluster, Any> rescheduleClusterMaintenanceOperationCallable;
    private final UnaryCallable<ListBackupCollectionsRequest, ListBackupCollectionsResponse> listBackupCollectionsCallable;
    private final UnaryCallable<ListBackupCollectionsRequest, CloudRedisClusterClient.ListBackupCollectionsPagedResponse> listBackupCollectionsPagedCallable;
    private final UnaryCallable<GetBackupCollectionRequest, BackupCollection> getBackupCollectionCallable;
    private final UnaryCallable<ListBackupsRequest, ListBackupsResponse> listBackupsCallable;
    private final UnaryCallable<ListBackupsRequest, CloudRedisClusterClient.ListBackupsPagedResponse> listBackupsPagedCallable;
    private final UnaryCallable<GetBackupRequest, Backup> getBackupCallable;
    private final UnaryCallable<DeleteBackupRequest, Operation> deleteBackupCallable;
    private final OperationCallable<DeleteBackupRequest, Empty, Any> deleteBackupOperationCallable;
    private final UnaryCallable<ExportBackupRequest, Operation> exportBackupCallable;
    private final OperationCallable<ExportBackupRequest, Backup, Any> exportBackupOperationCallable;
    private final UnaryCallable<BackupClusterRequest, Operation> backupClusterCallable;
    private final OperationCallable<BackupClusterRequest, Cluster, Any> backupClusterOperationCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, CloudRedisClusterClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonCloudRedisClusterStub create(CloudRedisClusterStubSettings settings) throws IOException {
        return new HttpJsonCloudRedisClusterStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonCloudRedisClusterStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonCloudRedisClusterStub(CloudRedisClusterStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonCloudRedisClusterStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonCloudRedisClusterStub(CloudRedisClusterStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonCloudRedisClusterStub(CloudRedisClusterStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonCloudRedisClusterCallableFactory());
    }

    protected HttpJsonCloudRedisClusterStub(CloudRedisClusterStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.CancelOperation", (Object)HttpRule.newBuilder().setPost("/v1/{name=projects/*/locations/*/operations/*}:cancel").build()).put((Object)"google.longrunning.Operations.DeleteOperation", (Object)HttpRule.newBuilder().setDelete("/v1/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*}/operations").build()).build());
        HttpJsonCallSettings listClustersTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listClustersMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getClusterTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getClusterMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateClusterTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateClusterMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("cluster.name", String.valueOf(request.getCluster().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteClusterTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteClusterMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createClusterTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createClusterMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getClusterCertificateAuthorityTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getClusterCertificateAuthorityMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings rescheduleClusterMaintenanceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(rescheduleClusterMaintenanceMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listBackupCollectionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listBackupCollectionsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getBackupCollectionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getBackupCollectionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listBackupsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listBackupsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getBackupTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getBackupMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteBackupTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteBackupMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings exportBackupTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(exportBackupMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings backupClusterTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(backupClusterMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listLocationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getLocationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listClustersCallable = callableFactory.createUnaryCallable(listClustersTransportSettings, settings.listClustersSettings(), clientContext);
        this.listClustersPagedCallable = callableFactory.createPagedCallable(listClustersTransportSettings, settings.listClustersSettings(), clientContext);
        this.getClusterCallable = callableFactory.createUnaryCallable(getClusterTransportSettings, settings.getClusterSettings(), clientContext);
        this.updateClusterCallable = callableFactory.createUnaryCallable(updateClusterTransportSettings, settings.updateClusterSettings(), clientContext);
        this.updateClusterOperationCallable = callableFactory.createOperationCallable(updateClusterTransportSettings, settings.updateClusterOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteClusterCallable = callableFactory.createUnaryCallable(deleteClusterTransportSettings, settings.deleteClusterSettings(), clientContext);
        this.deleteClusterOperationCallable = callableFactory.createOperationCallable(deleteClusterTransportSettings, settings.deleteClusterOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.createClusterCallable = callableFactory.createUnaryCallable(createClusterTransportSettings, settings.createClusterSettings(), clientContext);
        this.createClusterOperationCallable = callableFactory.createOperationCallable(createClusterTransportSettings, settings.createClusterOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getClusterCertificateAuthorityCallable = callableFactory.createUnaryCallable(getClusterCertificateAuthorityTransportSettings, settings.getClusterCertificateAuthoritySettings(), clientContext);
        this.rescheduleClusterMaintenanceCallable = callableFactory.createUnaryCallable(rescheduleClusterMaintenanceTransportSettings, settings.rescheduleClusterMaintenanceSettings(), clientContext);
        this.rescheduleClusterMaintenanceOperationCallable = callableFactory.createOperationCallable(rescheduleClusterMaintenanceTransportSettings, settings.rescheduleClusterMaintenanceOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listBackupCollectionsCallable = callableFactory.createUnaryCallable(listBackupCollectionsTransportSettings, settings.listBackupCollectionsSettings(), clientContext);
        this.listBackupCollectionsPagedCallable = callableFactory.createPagedCallable(listBackupCollectionsTransportSettings, settings.listBackupCollectionsSettings(), clientContext);
        this.getBackupCollectionCallable = callableFactory.createUnaryCallable(getBackupCollectionTransportSettings, settings.getBackupCollectionSettings(), clientContext);
        this.listBackupsCallable = callableFactory.createUnaryCallable(listBackupsTransportSettings, settings.listBackupsSettings(), clientContext);
        this.listBackupsPagedCallable = callableFactory.createPagedCallable(listBackupsTransportSettings, settings.listBackupsSettings(), clientContext);
        this.getBackupCallable = callableFactory.createUnaryCallable(getBackupTransportSettings, settings.getBackupSettings(), clientContext);
        this.deleteBackupCallable = callableFactory.createUnaryCallable(deleteBackupTransportSettings, settings.deleteBackupSettings(), clientContext);
        this.deleteBackupOperationCallable = callableFactory.createOperationCallable(deleteBackupTransportSettings, settings.deleteBackupOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.exportBackupCallable = callableFactory.createUnaryCallable(exportBackupTransportSettings, settings.exportBackupSettings(), clientContext);
        this.exportBackupOperationCallable = callableFactory.createOperationCallable(exportBackupTransportSettings, settings.exportBackupOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backupClusterCallable = callableFactory.createUnaryCallable(backupClusterTransportSettings, settings.backupClusterSettings(), clientContext);
        this.backupClusterOperationCallable = callableFactory.createOperationCallable(backupClusterTransportSettings, settings.backupClusterOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listClustersMethodDescriptor);
        methodDescriptors.add(getClusterMethodDescriptor);
        methodDescriptors.add(updateClusterMethodDescriptor);
        methodDescriptors.add(deleteClusterMethodDescriptor);
        methodDescriptors.add(createClusterMethodDescriptor);
        methodDescriptors.add(getClusterCertificateAuthorityMethodDescriptor);
        methodDescriptors.add(rescheduleClusterMaintenanceMethodDescriptor);
        methodDescriptors.add(listBackupCollectionsMethodDescriptor);
        methodDescriptors.add(getBackupCollectionMethodDescriptor);
        methodDescriptors.add(listBackupsMethodDescriptor);
        methodDescriptors.add(getBackupMethodDescriptor);
        methodDescriptors.add(deleteBackupMethodDescriptor);
        methodDescriptors.add(exportBackupMethodDescriptor);
        methodDescriptors.add(backupClusterMethodDescriptor);
        methodDescriptors.add(listLocationsMethodDescriptor);
        methodDescriptors.add(getLocationMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<ListClustersRequest, ListClustersResponse> listClustersCallable() {
        return this.listClustersCallable;
    }

    @Override
    public UnaryCallable<ListClustersRequest, CloudRedisClusterClient.ListClustersPagedResponse> listClustersPagedCallable() {
        return this.listClustersPagedCallable;
    }

    @Override
    public UnaryCallable<GetClusterRequest, Cluster> getClusterCallable() {
        return this.getClusterCallable;
    }

    @Override
    public UnaryCallable<UpdateClusterRequest, Operation> updateClusterCallable() {
        return this.updateClusterCallable;
    }

    @Override
    public OperationCallable<UpdateClusterRequest, Cluster, Any> updateClusterOperationCallable() {
        return this.updateClusterOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteClusterRequest, Operation> deleteClusterCallable() {
        return this.deleteClusterCallable;
    }

    @Override
    public OperationCallable<DeleteClusterRequest, Empty, Any> deleteClusterOperationCallable() {
        return this.deleteClusterOperationCallable;
    }

    @Override
    public UnaryCallable<CreateClusterRequest, Operation> createClusterCallable() {
        return this.createClusterCallable;
    }

    @Override
    public OperationCallable<CreateClusterRequest, Cluster, Any> createClusterOperationCallable() {
        return this.createClusterOperationCallable;
    }

    @Override
    public UnaryCallable<GetClusterCertificateAuthorityRequest, CertificateAuthority> getClusterCertificateAuthorityCallable() {
        return this.getClusterCertificateAuthorityCallable;
    }

    @Override
    public UnaryCallable<RescheduleClusterMaintenanceRequest, Operation> rescheduleClusterMaintenanceCallable() {
        return this.rescheduleClusterMaintenanceCallable;
    }

    @Override
    public OperationCallable<RescheduleClusterMaintenanceRequest, Cluster, Any> rescheduleClusterMaintenanceOperationCallable() {
        return this.rescheduleClusterMaintenanceOperationCallable;
    }

    @Override
    public UnaryCallable<ListBackupCollectionsRequest, ListBackupCollectionsResponse> listBackupCollectionsCallable() {
        return this.listBackupCollectionsCallable;
    }

    @Override
    public UnaryCallable<ListBackupCollectionsRequest, CloudRedisClusterClient.ListBackupCollectionsPagedResponse> listBackupCollectionsPagedCallable() {
        return this.listBackupCollectionsPagedCallable;
    }

    @Override
    public UnaryCallable<GetBackupCollectionRequest, BackupCollection> getBackupCollectionCallable() {
        return this.getBackupCollectionCallable;
    }

    @Override
    public UnaryCallable<ListBackupsRequest, ListBackupsResponse> listBackupsCallable() {
        return this.listBackupsCallable;
    }

    @Override
    public UnaryCallable<ListBackupsRequest, CloudRedisClusterClient.ListBackupsPagedResponse> listBackupsPagedCallable() {
        return this.listBackupsPagedCallable;
    }

    @Override
    public UnaryCallable<GetBackupRequest, Backup> getBackupCallable() {
        return this.getBackupCallable;
    }

    @Override
    public UnaryCallable<DeleteBackupRequest, Operation> deleteBackupCallable() {
        return this.deleteBackupCallable;
    }

    @Override
    public OperationCallable<DeleteBackupRequest, Empty, Any> deleteBackupOperationCallable() {
        return this.deleteBackupOperationCallable;
    }

    @Override
    public UnaryCallable<ExportBackupRequest, Operation> exportBackupCallable() {
        return this.exportBackupCallable;
    }

    @Override
    public OperationCallable<ExportBackupRequest, Backup, Any> exportBackupOperationCallable() {
        return this.exportBackupOperationCallable;
    }

    @Override
    public UnaryCallable<BackupClusterRequest, Operation> backupClusterCallable() {
        return this.backupClusterCallable;
    }

    @Override
    public OperationCallable<BackupClusterRequest, Cluster, Any> backupClusterOperationCallable() {
        return this.backupClusterOperationCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, CloudRedisClusterClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

