/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recommender.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.recommender.v1beta1.GetInsightRequest;
import com.google.cloud.recommender.v1beta1.GetInsightTypeConfigRequest;
import com.google.cloud.recommender.v1beta1.GetRecommendationRequest;
import com.google.cloud.recommender.v1beta1.GetRecommenderConfigRequest;
import com.google.cloud.recommender.v1beta1.Insight;
import com.google.cloud.recommender.v1beta1.InsightName;
import com.google.cloud.recommender.v1beta1.InsightType;
import com.google.cloud.recommender.v1beta1.InsightTypeConfig;
import com.google.cloud.recommender.v1beta1.InsightTypeConfigName;
import com.google.cloud.recommender.v1beta1.InsightTypeName;
import com.google.cloud.recommender.v1beta1.ListInsightTypesRequest;
import com.google.cloud.recommender.v1beta1.ListInsightTypesResponse;
import com.google.cloud.recommender.v1beta1.ListInsightsRequest;
import com.google.cloud.recommender.v1beta1.ListInsightsResponse;
import com.google.cloud.recommender.v1beta1.ListRecommendationsRequest;
import com.google.cloud.recommender.v1beta1.ListRecommendationsResponse;
import com.google.cloud.recommender.v1beta1.ListRecommendersRequest;
import com.google.cloud.recommender.v1beta1.ListRecommendersResponse;
import com.google.cloud.recommender.v1beta1.MarkInsightAcceptedRequest;
import com.google.cloud.recommender.v1beta1.MarkRecommendationClaimedRequest;
import com.google.cloud.recommender.v1beta1.MarkRecommendationFailedRequest;
import com.google.cloud.recommender.v1beta1.MarkRecommendationSucceededRequest;
import com.google.cloud.recommender.v1beta1.Recommendation;
import com.google.cloud.recommender.v1beta1.RecommendationName;
import com.google.cloud.recommender.v1beta1.RecommenderConfig;
import com.google.cloud.recommender.v1beta1.RecommenderConfigName;
import com.google.cloud.recommender.v1beta1.RecommenderName;
import com.google.cloud.recommender.v1beta1.RecommenderSettings;
import com.google.cloud.recommender.v1beta1.RecommenderType;
import com.google.cloud.recommender.v1beta1.UpdateInsightTypeConfigRequest;
import com.google.cloud.recommender.v1beta1.UpdateRecommenderConfigRequest;
import com.google.cloud.recommender.v1beta1.stub.RecommenderStub;
import com.google.cloud.recommender.v1beta1.stub.RecommenderStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class RecommenderClient
implements BackgroundResource {
    private final RecommenderSettings settings;
    private final RecommenderStub stub;

    public static final RecommenderClient create() throws IOException {
        return RecommenderClient.create(RecommenderSettings.newBuilder().build());
    }

    public static final RecommenderClient create(RecommenderSettings settings) throws IOException {
        return new RecommenderClient(settings);
    }

    public static final RecommenderClient create(RecommenderStub stub) {
        return new RecommenderClient(stub);
    }

    protected RecommenderClient(RecommenderSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RecommenderStubSettings)settings.getStubSettings()).createStub();
    }

    protected RecommenderClient(RecommenderStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RecommenderSettings getSettings() {
        return this.settings;
    }

    public RecommenderStub getStub() {
        return this.stub;
    }

    public final ListInsightsPagedResponse listInsights(InsightTypeName parent) {
        ListInsightsRequest request = ListInsightsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listInsights(request);
    }

    public final ListInsightsPagedResponse listInsights(String parent) {
        ListInsightsRequest request = ListInsightsRequest.newBuilder().setParent(parent).build();
        return this.listInsights(request);
    }

    public final ListInsightsPagedResponse listInsights(ListInsightsRequest request) {
        return (ListInsightsPagedResponse)((Object)this.listInsightsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInsightsRequest, ListInsightsPagedResponse> listInsightsPagedCallable() {
        return this.stub.listInsightsPagedCallable();
    }

    public final UnaryCallable<ListInsightsRequest, ListInsightsResponse> listInsightsCallable() {
        return this.stub.listInsightsCallable();
    }

    public final Insight getInsight(InsightName name) {
        GetInsightRequest request = GetInsightRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getInsight(request);
    }

    public final Insight getInsight(String name) {
        GetInsightRequest request = GetInsightRequest.newBuilder().setName(name).build();
        return this.getInsight(request);
    }

    public final Insight getInsight(GetInsightRequest request) {
        return (Insight)this.getInsightCallable().call((Object)request);
    }

    public final UnaryCallable<GetInsightRequest, Insight> getInsightCallable() {
        return this.stub.getInsightCallable();
    }

    public final Insight markInsightAccepted(InsightName name, Map<String, String> stateMetadata, String etag) {
        MarkInsightAcceptedRequest request = MarkInsightAcceptedRequest.newBuilder().setName(name == null ? null : name.toString()).putAllStateMetadata(stateMetadata).setEtag(etag).build();
        return this.markInsightAccepted(request);
    }

    public final Insight markInsightAccepted(String name, Map<String, String> stateMetadata, String etag) {
        MarkInsightAcceptedRequest request = MarkInsightAcceptedRequest.newBuilder().setName(name).putAllStateMetadata(stateMetadata).setEtag(etag).build();
        return this.markInsightAccepted(request);
    }

    public final Insight markInsightAccepted(MarkInsightAcceptedRequest request) {
        return (Insight)this.markInsightAcceptedCallable().call((Object)request);
    }

    public final UnaryCallable<MarkInsightAcceptedRequest, Insight> markInsightAcceptedCallable() {
        return this.stub.markInsightAcceptedCallable();
    }

    public final ListRecommendationsPagedResponse listRecommendations(RecommenderName parent, String filter) {
        ListRecommendationsRequest request = ListRecommendationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFilter(filter).build();
        return this.listRecommendations(request);
    }

    public final ListRecommendationsPagedResponse listRecommendations(String parent, String filter) {
        ListRecommendationsRequest request = ListRecommendationsRequest.newBuilder().setParent(parent).setFilter(filter).build();
        return this.listRecommendations(request);
    }

    public final ListRecommendationsPagedResponse listRecommendations(ListRecommendationsRequest request) {
        return (ListRecommendationsPagedResponse)((Object)this.listRecommendationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRecommendationsRequest, ListRecommendationsPagedResponse> listRecommendationsPagedCallable() {
        return this.stub.listRecommendationsPagedCallable();
    }

    public final UnaryCallable<ListRecommendationsRequest, ListRecommendationsResponse> listRecommendationsCallable() {
        return this.stub.listRecommendationsCallable();
    }

    public final Recommendation getRecommendation(RecommendationName name) {
        GetRecommendationRequest request = GetRecommendationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRecommendation(request);
    }

    public final Recommendation getRecommendation(String name) {
        GetRecommendationRequest request = GetRecommendationRequest.newBuilder().setName(name).build();
        return this.getRecommendation(request);
    }

    public final Recommendation getRecommendation(GetRecommendationRequest request) {
        return (Recommendation)this.getRecommendationCallable().call((Object)request);
    }

    public final UnaryCallable<GetRecommendationRequest, Recommendation> getRecommendationCallable() {
        return this.stub.getRecommendationCallable();
    }

    public final Recommendation markRecommendationClaimed(RecommendationName name, Map<String, String> stateMetadata, String etag) {
        MarkRecommendationClaimedRequest request = MarkRecommendationClaimedRequest.newBuilder().setName(name == null ? null : name.toString()).putAllStateMetadata(stateMetadata).setEtag(etag).build();
        return this.markRecommendationClaimed(request);
    }

    public final Recommendation markRecommendationClaimed(String name, Map<String, String> stateMetadata, String etag) {
        MarkRecommendationClaimedRequest request = MarkRecommendationClaimedRequest.newBuilder().setName(name).putAllStateMetadata(stateMetadata).setEtag(etag).build();
        return this.markRecommendationClaimed(request);
    }

    public final Recommendation markRecommendationClaimed(MarkRecommendationClaimedRequest request) {
        return (Recommendation)this.markRecommendationClaimedCallable().call((Object)request);
    }

    public final UnaryCallable<MarkRecommendationClaimedRequest, Recommendation> markRecommendationClaimedCallable() {
        return this.stub.markRecommendationClaimedCallable();
    }

    public final Recommendation markRecommendationSucceeded(RecommendationName name, Map<String, String> stateMetadata, String etag) {
        MarkRecommendationSucceededRequest request = MarkRecommendationSucceededRequest.newBuilder().setName(name == null ? null : name.toString()).putAllStateMetadata(stateMetadata).setEtag(etag).build();
        return this.markRecommendationSucceeded(request);
    }

    public final Recommendation markRecommendationSucceeded(String name, Map<String, String> stateMetadata, String etag) {
        MarkRecommendationSucceededRequest request = MarkRecommendationSucceededRequest.newBuilder().setName(name).putAllStateMetadata(stateMetadata).setEtag(etag).build();
        return this.markRecommendationSucceeded(request);
    }

    public final Recommendation markRecommendationSucceeded(MarkRecommendationSucceededRequest request) {
        return (Recommendation)this.markRecommendationSucceededCallable().call((Object)request);
    }

    public final UnaryCallable<MarkRecommendationSucceededRequest, Recommendation> markRecommendationSucceededCallable() {
        return this.stub.markRecommendationSucceededCallable();
    }

    public final Recommendation markRecommendationFailed(RecommendationName name, Map<String, String> stateMetadata, String etag) {
        MarkRecommendationFailedRequest request = MarkRecommendationFailedRequest.newBuilder().setName(name == null ? null : name.toString()).putAllStateMetadata(stateMetadata).setEtag(etag).build();
        return this.markRecommendationFailed(request);
    }

    public final Recommendation markRecommendationFailed(String name, Map<String, String> stateMetadata, String etag) {
        MarkRecommendationFailedRequest request = MarkRecommendationFailedRequest.newBuilder().setName(name).putAllStateMetadata(stateMetadata).setEtag(etag).build();
        return this.markRecommendationFailed(request);
    }

    public final Recommendation markRecommendationFailed(MarkRecommendationFailedRequest request) {
        return (Recommendation)this.markRecommendationFailedCallable().call((Object)request);
    }

    public final UnaryCallable<MarkRecommendationFailedRequest, Recommendation> markRecommendationFailedCallable() {
        return this.stub.markRecommendationFailedCallable();
    }

    public final RecommenderConfig getRecommenderConfig(RecommenderConfigName name) {
        GetRecommenderConfigRequest request = GetRecommenderConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRecommenderConfig(request);
    }

    public final RecommenderConfig getRecommenderConfig(String name) {
        GetRecommenderConfigRequest request = GetRecommenderConfigRequest.newBuilder().setName(name).build();
        return this.getRecommenderConfig(request);
    }

    public final RecommenderConfig getRecommenderConfig(GetRecommenderConfigRequest request) {
        return (RecommenderConfig)this.getRecommenderConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetRecommenderConfigRequest, RecommenderConfig> getRecommenderConfigCallable() {
        return this.stub.getRecommenderConfigCallable();
    }

    public final RecommenderConfig updateRecommenderConfig(RecommenderConfig recommenderConfig, FieldMask updateMask) {
        UpdateRecommenderConfigRequest request = UpdateRecommenderConfigRequest.newBuilder().setRecommenderConfig(recommenderConfig).setUpdateMask(updateMask).build();
        return this.updateRecommenderConfig(request);
    }

    public final RecommenderConfig updateRecommenderConfig(UpdateRecommenderConfigRequest request) {
        return (RecommenderConfig)this.updateRecommenderConfigCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateRecommenderConfigRequest, RecommenderConfig> updateRecommenderConfigCallable() {
        return this.stub.updateRecommenderConfigCallable();
    }

    public final InsightTypeConfig getInsightTypeConfig(InsightTypeConfigName name) {
        GetInsightTypeConfigRequest request = GetInsightTypeConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getInsightTypeConfig(request);
    }

    public final InsightTypeConfig getInsightTypeConfig(String name) {
        GetInsightTypeConfigRequest request = GetInsightTypeConfigRequest.newBuilder().setName(name).build();
        return this.getInsightTypeConfig(request);
    }

    public final InsightTypeConfig getInsightTypeConfig(GetInsightTypeConfigRequest request) {
        return (InsightTypeConfig)this.getInsightTypeConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetInsightTypeConfigRequest, InsightTypeConfig> getInsightTypeConfigCallable() {
        return this.stub.getInsightTypeConfigCallable();
    }

    public final InsightTypeConfig updateInsightTypeConfig(InsightTypeConfig insightTypeConfig, FieldMask updateMask) {
        UpdateInsightTypeConfigRequest request = UpdateInsightTypeConfigRequest.newBuilder().setInsightTypeConfig(insightTypeConfig).setUpdateMask(updateMask).build();
        return this.updateInsightTypeConfig(request);
    }

    public final InsightTypeConfig updateInsightTypeConfig(UpdateInsightTypeConfigRequest request) {
        return (InsightTypeConfig)this.updateInsightTypeConfigCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateInsightTypeConfigRequest, InsightTypeConfig> updateInsightTypeConfigCallable() {
        return this.stub.updateInsightTypeConfigCallable();
    }

    public final ListRecommendersPagedResponse listRecommenders(ListRecommendersRequest request) {
        return (ListRecommendersPagedResponse)((Object)this.listRecommendersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRecommendersRequest, ListRecommendersPagedResponse> listRecommendersPagedCallable() {
        return this.stub.listRecommendersPagedCallable();
    }

    public final UnaryCallable<ListRecommendersRequest, ListRecommendersResponse> listRecommendersCallable() {
        return this.stub.listRecommendersCallable();
    }

    public final ListInsightTypesPagedResponse listInsightTypes(ListInsightTypesRequest request) {
        return (ListInsightTypesPagedResponse)((Object)this.listInsightTypesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInsightTypesRequest, ListInsightTypesPagedResponse> listInsightTypesPagedCallable() {
        return this.stub.listInsightTypesPagedCallable();
    }

    public final UnaryCallable<ListInsightTypesRequest, ListInsightTypesResponse> listInsightTypesCallable() {
        return this.stub.listInsightTypesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListInsightTypesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInsightTypesRequest, ListInsightTypesResponse, InsightType, ListInsightTypesPage, ListInsightTypesFixedSizeCollection> {
        private ListInsightTypesFixedSizeCollection(List<ListInsightTypesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInsightTypesFixedSizeCollection createEmptyCollection() {
            return new ListInsightTypesFixedSizeCollection(null, 0);
        }

        protected ListInsightTypesFixedSizeCollection createCollection(List<ListInsightTypesPage> pages, int collectionSize) {
            return new ListInsightTypesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInsightTypesPage
    extends AbstractPage<ListInsightTypesRequest, ListInsightTypesResponse, InsightType, ListInsightTypesPage> {
        private ListInsightTypesPage(PageContext<ListInsightTypesRequest, ListInsightTypesResponse, InsightType> context, ListInsightTypesResponse response) {
            super(context, (Object)response);
        }

        private static ListInsightTypesPage createEmptyPage() {
            return new ListInsightTypesPage(null, null);
        }

        protected ListInsightTypesPage createPage(PageContext<ListInsightTypesRequest, ListInsightTypesResponse, InsightType> context, ListInsightTypesResponse response) {
            return new ListInsightTypesPage(context, response);
        }

        public ApiFuture<ListInsightTypesPage> createPageAsync(PageContext<ListInsightTypesRequest, ListInsightTypesResponse, InsightType> context, ApiFuture<ListInsightTypesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInsightTypesPagedResponse
    extends AbstractPagedListResponse<ListInsightTypesRequest, ListInsightTypesResponse, InsightType, ListInsightTypesPage, ListInsightTypesFixedSizeCollection> {
        public static ApiFuture<ListInsightTypesPagedResponse> createAsync(PageContext<ListInsightTypesRequest, ListInsightTypesResponse, InsightType> context, ApiFuture<ListInsightTypesResponse> futureResponse) {
            ApiFuture<ListInsightTypesPage> futurePage = ListInsightTypesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListInsightTypesPagedResponse((ListInsightTypesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListInsightTypesPagedResponse(ListInsightTypesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInsightTypesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListRecommendersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRecommendersRequest, ListRecommendersResponse, RecommenderType, ListRecommendersPage, ListRecommendersFixedSizeCollection> {
        private ListRecommendersFixedSizeCollection(List<ListRecommendersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRecommendersFixedSizeCollection createEmptyCollection() {
            return new ListRecommendersFixedSizeCollection(null, 0);
        }

        protected ListRecommendersFixedSizeCollection createCollection(List<ListRecommendersPage> pages, int collectionSize) {
            return new ListRecommendersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRecommendersPage
    extends AbstractPage<ListRecommendersRequest, ListRecommendersResponse, RecommenderType, ListRecommendersPage> {
        private ListRecommendersPage(PageContext<ListRecommendersRequest, ListRecommendersResponse, RecommenderType> context, ListRecommendersResponse response) {
            super(context, (Object)response);
        }

        private static ListRecommendersPage createEmptyPage() {
            return new ListRecommendersPage(null, null);
        }

        protected ListRecommendersPage createPage(PageContext<ListRecommendersRequest, ListRecommendersResponse, RecommenderType> context, ListRecommendersResponse response) {
            return new ListRecommendersPage(context, response);
        }

        public ApiFuture<ListRecommendersPage> createPageAsync(PageContext<ListRecommendersRequest, ListRecommendersResponse, RecommenderType> context, ApiFuture<ListRecommendersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRecommendersPagedResponse
    extends AbstractPagedListResponse<ListRecommendersRequest, ListRecommendersResponse, RecommenderType, ListRecommendersPage, ListRecommendersFixedSizeCollection> {
        public static ApiFuture<ListRecommendersPagedResponse> createAsync(PageContext<ListRecommendersRequest, ListRecommendersResponse, RecommenderType> context, ApiFuture<ListRecommendersResponse> futureResponse) {
            ApiFuture<ListRecommendersPage> futurePage = ListRecommendersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRecommendersPagedResponse((ListRecommendersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRecommendersPagedResponse(ListRecommendersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRecommendersFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListRecommendationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRecommendationsRequest, ListRecommendationsResponse, Recommendation, ListRecommendationsPage, ListRecommendationsFixedSizeCollection> {
        private ListRecommendationsFixedSizeCollection(List<ListRecommendationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRecommendationsFixedSizeCollection createEmptyCollection() {
            return new ListRecommendationsFixedSizeCollection(null, 0);
        }

        protected ListRecommendationsFixedSizeCollection createCollection(List<ListRecommendationsPage> pages, int collectionSize) {
            return new ListRecommendationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRecommendationsPage
    extends AbstractPage<ListRecommendationsRequest, ListRecommendationsResponse, Recommendation, ListRecommendationsPage> {
        private ListRecommendationsPage(PageContext<ListRecommendationsRequest, ListRecommendationsResponse, Recommendation> context, ListRecommendationsResponse response) {
            super(context, (Object)response);
        }

        private static ListRecommendationsPage createEmptyPage() {
            return new ListRecommendationsPage(null, null);
        }

        protected ListRecommendationsPage createPage(PageContext<ListRecommendationsRequest, ListRecommendationsResponse, Recommendation> context, ListRecommendationsResponse response) {
            return new ListRecommendationsPage(context, response);
        }

        public ApiFuture<ListRecommendationsPage> createPageAsync(PageContext<ListRecommendationsRequest, ListRecommendationsResponse, Recommendation> context, ApiFuture<ListRecommendationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRecommendationsPagedResponse
    extends AbstractPagedListResponse<ListRecommendationsRequest, ListRecommendationsResponse, Recommendation, ListRecommendationsPage, ListRecommendationsFixedSizeCollection> {
        public static ApiFuture<ListRecommendationsPagedResponse> createAsync(PageContext<ListRecommendationsRequest, ListRecommendationsResponse, Recommendation> context, ApiFuture<ListRecommendationsResponse> futureResponse) {
            ApiFuture<ListRecommendationsPage> futurePage = ListRecommendationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRecommendationsPagedResponse((ListRecommendationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRecommendationsPagedResponse(ListRecommendationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRecommendationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListInsightsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInsightsRequest, ListInsightsResponse, Insight, ListInsightsPage, ListInsightsFixedSizeCollection> {
        private ListInsightsFixedSizeCollection(List<ListInsightsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInsightsFixedSizeCollection createEmptyCollection() {
            return new ListInsightsFixedSizeCollection(null, 0);
        }

        protected ListInsightsFixedSizeCollection createCollection(List<ListInsightsPage> pages, int collectionSize) {
            return new ListInsightsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInsightsPage
    extends AbstractPage<ListInsightsRequest, ListInsightsResponse, Insight, ListInsightsPage> {
        private ListInsightsPage(PageContext<ListInsightsRequest, ListInsightsResponse, Insight> context, ListInsightsResponse response) {
            super(context, (Object)response);
        }

        private static ListInsightsPage createEmptyPage() {
            return new ListInsightsPage(null, null);
        }

        protected ListInsightsPage createPage(PageContext<ListInsightsRequest, ListInsightsResponse, Insight> context, ListInsightsResponse response) {
            return new ListInsightsPage(context, response);
        }

        public ApiFuture<ListInsightsPage> createPageAsync(PageContext<ListInsightsRequest, ListInsightsResponse, Insight> context, ApiFuture<ListInsightsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInsightsPagedResponse
    extends AbstractPagedListResponse<ListInsightsRequest, ListInsightsResponse, Insight, ListInsightsPage, ListInsightsFixedSizeCollection> {
        public static ApiFuture<ListInsightsPagedResponse> createAsync(PageContext<ListInsightsRequest, ListInsightsResponse, Insight> context, ApiFuture<ListInsightsResponse> futureResponse) {
            ApiFuture<ListInsightsPage> futurePage = ListInsightsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListInsightsPagedResponse((ListInsightsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListInsightsPagedResponse(ListInsightsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInsightsFixedSizeCollection.createEmptyCollection());
        }
    }
}

