/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recommender.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.recommender.v1.GetInsightRequest;
import com.google.cloud.recommender.v1.GetInsightTypeConfigRequest;
import com.google.cloud.recommender.v1.GetRecommendationRequest;
import com.google.cloud.recommender.v1.GetRecommenderConfigRequest;
import com.google.cloud.recommender.v1.Insight;
import com.google.cloud.recommender.v1.InsightTypeConfig;
import com.google.cloud.recommender.v1.ListInsightsRequest;
import com.google.cloud.recommender.v1.ListInsightsResponse;
import com.google.cloud.recommender.v1.ListRecommendationsRequest;
import com.google.cloud.recommender.v1.ListRecommendationsResponse;
import com.google.cloud.recommender.v1.MarkInsightAcceptedRequest;
import com.google.cloud.recommender.v1.MarkRecommendationClaimedRequest;
import com.google.cloud.recommender.v1.MarkRecommendationFailedRequest;
import com.google.cloud.recommender.v1.MarkRecommendationSucceededRequest;
import com.google.cloud.recommender.v1.Recommendation;
import com.google.cloud.recommender.v1.RecommenderClient;
import com.google.cloud.recommender.v1.RecommenderConfig;
import com.google.cloud.recommender.v1.UpdateInsightTypeConfigRequest;
import com.google.cloud.recommender.v1.UpdateRecommenderConfigRequest;
import com.google.cloud.recommender.v1.stub.HttpJsonRecommenderCallableFactory;
import com.google.cloud.recommender.v1.stub.RecommenderStub;
import com.google.cloud.recommender.v1.stub.RecommenderStubSettings;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonRecommenderStub
extends RecommenderStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<ListInsightsRequest, ListInsightsResponse> listInsightsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.recommender.v1.Recommender/ListInsights").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/insightTypes/*}/insights", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{parent=billingAccounts/*/locations/*/insightTypes/*}/insights", "/v1/{parent=folders/*/locations/*/insightTypes/*}/insights", "/v1/{parent=organizations/*/locations/*/insightTypes/*}/insights"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListInsightsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetInsightRequest, Insight> getInsightMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.recommender.v1.Recommender/GetInsight").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/insightTypes/*/insights/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=billingAccounts/*/locations/*/insightTypes/*/insights/*}", "/v1/{name=folders/*/locations/*/insightTypes/*/insights/*}", "/v1/{name=organizations/*/locations/*/insightTypes/*/insights/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Insight.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<MarkInsightAcceptedRequest, Insight> markInsightAcceptedMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.recommender.v1.Recommender/MarkInsightAccepted").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/insightTypes/*/insights/*}:markAccepted", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=billingAccounts/*/locations/*/insightTypes/*/insights/*}:markAccepted", "/v1/{name=folders/*/locations/*/insightTypes/*/insights/*}:markAccepted", "/v1/{name=organizations/*/locations/*/insightTypes/*/insights/*}:markAccepted"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Insight.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListRecommendationsRequest, ListRecommendationsResponse> listRecommendationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.recommender.v1.Recommender/ListRecommendations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/recommenders/*}/recommendations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{parent=billingAccounts/*/locations/*/recommenders/*}/recommendations", "/v1/{parent=folders/*/locations/*/recommenders/*}/recommendations", "/v1/{parent=organizations/*/locations/*/recommenders/*}/recommendations"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListRecommendationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetRecommendationRequest, Recommendation> getRecommendationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.recommender.v1.Recommender/GetRecommendation").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/recommenders/*/recommendations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=billingAccounts/*/locations/*/recommenders/*/recommendations/*}", "/v1/{name=folders/*/locations/*/recommenders/*/recommendations/*}", "/v1/{name=organizations/*/locations/*/recommenders/*/recommendations/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Recommendation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<MarkRecommendationClaimedRequest, Recommendation> markRecommendationClaimedMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.recommender.v1.Recommender/MarkRecommendationClaimed").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/recommenders/*/recommendations/*}:markClaimed", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=billingAccounts/*/locations/*/recommenders/*/recommendations/*}:markClaimed", "/v1/{name=folders/*/locations/*/recommenders/*/recommendations/*}:markClaimed", "/v1/{name=organizations/*/locations/*/recommenders/*/recommendations/*}:markClaimed"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Recommendation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<MarkRecommendationSucceededRequest, Recommendation> markRecommendationSucceededMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.recommender.v1.Recommender/MarkRecommendationSucceeded").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/recommenders/*/recommendations/*}:markSucceeded", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=billingAccounts/*/locations/*/recommenders/*/recommendations/*}:markSucceeded", "/v1/{name=folders/*/locations/*/recommenders/*/recommendations/*}:markSucceeded", "/v1/{name=organizations/*/locations/*/recommenders/*/recommendations/*}:markSucceeded"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Recommendation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<MarkRecommendationFailedRequest, Recommendation> markRecommendationFailedMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.recommender.v1.Recommender/MarkRecommendationFailed").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/recommenders/*/recommendations/*}:markFailed", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=billingAccounts/*/locations/*/recommenders/*/recommendations/*}:markFailed", "/v1/{name=folders/*/locations/*/recommenders/*/recommendations/*}:markFailed", "/v1/{name=organizations/*/locations/*/recommenders/*/recommendations/*}:markFailed"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Recommendation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetRecommenderConfigRequest, RecommenderConfig> getRecommenderConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.recommender.v1.Recommender/GetRecommenderConfig").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/recommenders/*/config}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=organizations/*/locations/*/recommenders/*/config}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)RecommenderConfig.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateRecommenderConfigRequest, RecommenderConfig> updateRecommenderConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.recommender.v1.Recommender/UpdateRecommenderConfig").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{recommenderConfig.name=projects/*/locations/*/recommenders/*/config}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "recommenderConfig.name", (Object)request.getRecommenderConfig().getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{recommenderConfig.name=organizations/*/locations/*/recommenders/*/config}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("recommenderConfig", (Message)request.getRecommenderConfig(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)RecommenderConfig.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetInsightTypeConfigRequest, InsightTypeConfig> getInsightTypeConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.recommender.v1.Recommender/GetInsightTypeConfig").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/insightTypes/*/config}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=organizations/*/locations/*/insightTypes/*/config}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)InsightTypeConfig.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateInsightTypeConfigRequest, InsightTypeConfig> updateInsightTypeConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.recommender.v1.Recommender/UpdateInsightTypeConfig").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{insightTypeConfig.name=projects/*/locations/*/insightTypes/*/config}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "insightTypeConfig.name", (Object)request.getInsightTypeConfig().getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{insightTypeConfig.name=organizations/*/locations/*/insightTypes/*/config}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("insightTypeConfig", (Message)request.getInsightTypeConfig(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)InsightTypeConfig.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListInsightsRequest, ListInsightsResponse> listInsightsCallable;
    private final UnaryCallable<ListInsightsRequest, RecommenderClient.ListInsightsPagedResponse> listInsightsPagedCallable;
    private final UnaryCallable<GetInsightRequest, Insight> getInsightCallable;
    private final UnaryCallable<MarkInsightAcceptedRequest, Insight> markInsightAcceptedCallable;
    private final UnaryCallable<ListRecommendationsRequest, ListRecommendationsResponse> listRecommendationsCallable;
    private final UnaryCallable<ListRecommendationsRequest, RecommenderClient.ListRecommendationsPagedResponse> listRecommendationsPagedCallable;
    private final UnaryCallable<GetRecommendationRequest, Recommendation> getRecommendationCallable;
    private final UnaryCallable<MarkRecommendationClaimedRequest, Recommendation> markRecommendationClaimedCallable;
    private final UnaryCallable<MarkRecommendationSucceededRequest, Recommendation> markRecommendationSucceededCallable;
    private final UnaryCallable<MarkRecommendationFailedRequest, Recommendation> markRecommendationFailedCallable;
    private final UnaryCallable<GetRecommenderConfigRequest, RecommenderConfig> getRecommenderConfigCallable;
    private final UnaryCallable<UpdateRecommenderConfigRequest, RecommenderConfig> updateRecommenderConfigCallable;
    private final UnaryCallable<GetInsightTypeConfigRequest, InsightTypeConfig> getInsightTypeConfigCallable;
    private final UnaryCallable<UpdateInsightTypeConfigRequest, InsightTypeConfig> updateInsightTypeConfigCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonRecommenderStub create(RecommenderStubSettings settings) throws IOException {
        return new HttpJsonRecommenderStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonRecommenderStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonRecommenderStub(RecommenderStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonRecommenderStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonRecommenderStub(RecommenderStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonRecommenderStub(RecommenderStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonRecommenderCallableFactory());
    }

    protected HttpJsonRecommenderStub(RecommenderStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings listInsightsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listInsightsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getInsightTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getInsightMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings markInsightAcceptedTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(markInsightAcceptedMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listRecommendationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listRecommendationsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getRecommendationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getRecommendationMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings markRecommendationClaimedTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(markRecommendationClaimedMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings markRecommendationSucceededTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(markRecommendationSucceededMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings markRecommendationFailedTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(markRecommendationFailedMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getRecommenderConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getRecommenderConfigMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateRecommenderConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateRecommenderConfigMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getInsightTypeConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getInsightTypeConfigMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateInsightTypeConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateInsightTypeConfigMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.listInsightsCallable = callableFactory.createUnaryCallable(listInsightsTransportSettings, settings.listInsightsSettings(), clientContext);
        this.listInsightsPagedCallable = callableFactory.createPagedCallable(listInsightsTransportSettings, settings.listInsightsSettings(), clientContext);
        this.getInsightCallable = callableFactory.createUnaryCallable(getInsightTransportSettings, settings.getInsightSettings(), clientContext);
        this.markInsightAcceptedCallable = callableFactory.createUnaryCallable(markInsightAcceptedTransportSettings, settings.markInsightAcceptedSettings(), clientContext);
        this.listRecommendationsCallable = callableFactory.createUnaryCallable(listRecommendationsTransportSettings, settings.listRecommendationsSettings(), clientContext);
        this.listRecommendationsPagedCallable = callableFactory.createPagedCallable(listRecommendationsTransportSettings, settings.listRecommendationsSettings(), clientContext);
        this.getRecommendationCallable = callableFactory.createUnaryCallable(getRecommendationTransportSettings, settings.getRecommendationSettings(), clientContext);
        this.markRecommendationClaimedCallable = callableFactory.createUnaryCallable(markRecommendationClaimedTransportSettings, settings.markRecommendationClaimedSettings(), clientContext);
        this.markRecommendationSucceededCallable = callableFactory.createUnaryCallable(markRecommendationSucceededTransportSettings, settings.markRecommendationSucceededSettings(), clientContext);
        this.markRecommendationFailedCallable = callableFactory.createUnaryCallable(markRecommendationFailedTransportSettings, settings.markRecommendationFailedSettings(), clientContext);
        this.getRecommenderConfigCallable = callableFactory.createUnaryCallable(getRecommenderConfigTransportSettings, settings.getRecommenderConfigSettings(), clientContext);
        this.updateRecommenderConfigCallable = callableFactory.createUnaryCallable(updateRecommenderConfigTransportSettings, settings.updateRecommenderConfigSettings(), clientContext);
        this.getInsightTypeConfigCallable = callableFactory.createUnaryCallable(getInsightTypeConfigTransportSettings, settings.getInsightTypeConfigSettings(), clientContext);
        this.updateInsightTypeConfigCallable = callableFactory.createUnaryCallable(updateInsightTypeConfigTransportSettings, settings.updateInsightTypeConfigSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listInsightsMethodDescriptor);
        methodDescriptors.add(getInsightMethodDescriptor);
        methodDescriptors.add(markInsightAcceptedMethodDescriptor);
        methodDescriptors.add(listRecommendationsMethodDescriptor);
        methodDescriptors.add(getRecommendationMethodDescriptor);
        methodDescriptors.add(markRecommendationClaimedMethodDescriptor);
        methodDescriptors.add(markRecommendationSucceededMethodDescriptor);
        methodDescriptors.add(markRecommendationFailedMethodDescriptor);
        methodDescriptors.add(getRecommenderConfigMethodDescriptor);
        methodDescriptors.add(updateRecommenderConfigMethodDescriptor);
        methodDescriptors.add(getInsightTypeConfigMethodDescriptor);
        methodDescriptors.add(updateInsightTypeConfigMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<ListInsightsRequest, ListInsightsResponse> listInsightsCallable() {
        return this.listInsightsCallable;
    }

    @Override
    public UnaryCallable<ListInsightsRequest, RecommenderClient.ListInsightsPagedResponse> listInsightsPagedCallable() {
        return this.listInsightsPagedCallable;
    }

    @Override
    public UnaryCallable<GetInsightRequest, Insight> getInsightCallable() {
        return this.getInsightCallable;
    }

    @Override
    public UnaryCallable<MarkInsightAcceptedRequest, Insight> markInsightAcceptedCallable() {
        return this.markInsightAcceptedCallable;
    }

    @Override
    public UnaryCallable<ListRecommendationsRequest, ListRecommendationsResponse> listRecommendationsCallable() {
        return this.listRecommendationsCallable;
    }

    @Override
    public UnaryCallable<ListRecommendationsRequest, RecommenderClient.ListRecommendationsPagedResponse> listRecommendationsPagedCallable() {
        return this.listRecommendationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetRecommendationRequest, Recommendation> getRecommendationCallable() {
        return this.getRecommendationCallable;
    }

    @Override
    public UnaryCallable<MarkRecommendationClaimedRequest, Recommendation> markRecommendationClaimedCallable() {
        return this.markRecommendationClaimedCallable;
    }

    @Override
    public UnaryCallable<MarkRecommendationSucceededRequest, Recommendation> markRecommendationSucceededCallable() {
        return this.markRecommendationSucceededCallable;
    }

    @Override
    public UnaryCallable<MarkRecommendationFailedRequest, Recommendation> markRecommendationFailedCallable() {
        return this.markRecommendationFailedCallable;
    }

    @Override
    public UnaryCallable<GetRecommenderConfigRequest, RecommenderConfig> getRecommenderConfigCallable() {
        return this.getRecommenderConfigCallable;
    }

    @Override
    public UnaryCallable<UpdateRecommenderConfigRequest, RecommenderConfig> updateRecommenderConfigCallable() {
        return this.updateRecommenderConfigCallable;
    }

    @Override
    public UnaryCallable<GetInsightTypeConfigRequest, InsightTypeConfig> getInsightTypeConfigCallable() {
        return this.getInsightTypeConfigCallable;
    }

    @Override
    public UnaryCallable<UpdateInsightTypeConfigRequest, InsightTypeConfig> updateInsightTypeConfigCallable() {
        return this.updateInsightTypeConfigCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

