/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recommender.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.recommender.v1.GetRecommendationRequest;
import com.google.cloud.recommender.v1.ListRecommendationsRequest;
import com.google.cloud.recommender.v1.ListRecommendationsResponse;
import com.google.cloud.recommender.v1.MarkRecommendationClaimedRequest;
import com.google.cloud.recommender.v1.MarkRecommendationFailedRequest;
import com.google.cloud.recommender.v1.MarkRecommendationSucceededRequest;
import com.google.cloud.recommender.v1.Recommendation;
import com.google.cloud.recommender.v1.RecommendationName;
import com.google.cloud.recommender.v1.RecommenderName;
import com.google.cloud.recommender.v1.RecommenderSettings;
import com.google.cloud.recommender.v1.stub.RecommenderStub;
import com.google.cloud.recommender.v1.stub.RecommenderStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class RecommenderClient
implements BackgroundResource {
    private final RecommenderSettings settings;
    private final RecommenderStub stub;

    public static final RecommenderClient create() throws IOException {
        return RecommenderClient.create(RecommenderSettings.newBuilder().build());
    }

    public static final RecommenderClient create(RecommenderSettings settings) throws IOException {
        return new RecommenderClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RecommenderClient create(RecommenderStub stub) {
        return new RecommenderClient(stub);
    }

    protected RecommenderClient(RecommenderSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RecommenderStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RecommenderClient(RecommenderStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RecommenderSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RecommenderStub getStub() {
        return this.stub;
    }

    public final ListRecommendationsPagedResponse listRecommendations(RecommenderName parent) {
        ListRecommendationsRequest request = ListRecommendationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRecommendations(request);
    }

    public final ListRecommendationsPagedResponse listRecommendations(String parent) {
        ListRecommendationsRequest request = ListRecommendationsRequest.newBuilder().setParent(parent).build();
        return this.listRecommendations(request);
    }

    public final ListRecommendationsPagedResponse listRecommendations(RecommenderName parent, String filter) {
        ListRecommendationsRequest request = ListRecommendationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFilter(filter).build();
        return this.listRecommendations(request);
    }

    public final ListRecommendationsPagedResponse listRecommendations(String parent, String filter) {
        ListRecommendationsRequest request = ListRecommendationsRequest.newBuilder().setParent(parent).setFilter(filter).build();
        return this.listRecommendations(request);
    }

    public final ListRecommendationsPagedResponse listRecommendations(ListRecommendationsRequest request) {
        return (ListRecommendationsPagedResponse)((Object)this.listRecommendationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRecommendationsRequest, ListRecommendationsPagedResponse> listRecommendationsPagedCallable() {
        return this.stub.listRecommendationsPagedCallable();
    }

    public final UnaryCallable<ListRecommendationsRequest, ListRecommendationsResponse> listRecommendationsCallable() {
        return this.stub.listRecommendationsCallable();
    }

    public final Recommendation getRecommendation(RecommendationName name) {
        GetRecommendationRequest request = GetRecommendationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRecommendation(request);
    }

    public final Recommendation getRecommendation(String name) {
        GetRecommendationRequest request = GetRecommendationRequest.newBuilder().setName(name).build();
        return this.getRecommendation(request);
    }

    public final Recommendation getRecommendation(GetRecommendationRequest request) {
        return (Recommendation)this.getRecommendationCallable().call((Object)request);
    }

    public final UnaryCallable<GetRecommendationRequest, Recommendation> getRecommendationCallable() {
        return this.stub.getRecommendationCallable();
    }

    public final Recommendation markRecommendationClaimed(RecommendationName name, Map<String, String> stateMetadata, String etag) {
        MarkRecommendationClaimedRequest request = MarkRecommendationClaimedRequest.newBuilder().setName(name == null ? null : name.toString()).putAllStateMetadata(stateMetadata).setEtag(etag).build();
        return this.markRecommendationClaimed(request);
    }

    public final Recommendation markRecommendationClaimed(String name, Map<String, String> stateMetadata, String etag) {
        MarkRecommendationClaimedRequest request = MarkRecommendationClaimedRequest.newBuilder().setName(name).putAllStateMetadata(stateMetadata).setEtag(etag).build();
        return this.markRecommendationClaimed(request);
    }

    public final Recommendation markRecommendationClaimed(MarkRecommendationClaimedRequest request) {
        return (Recommendation)this.markRecommendationClaimedCallable().call((Object)request);
    }

    public final UnaryCallable<MarkRecommendationClaimedRequest, Recommendation> markRecommendationClaimedCallable() {
        return this.stub.markRecommendationClaimedCallable();
    }

    public final Recommendation markRecommendationSucceeded(RecommendationName name, Map<String, String> stateMetadata, String etag) {
        MarkRecommendationSucceededRequest request = MarkRecommendationSucceededRequest.newBuilder().setName(name == null ? null : name.toString()).putAllStateMetadata(stateMetadata).setEtag(etag).build();
        return this.markRecommendationSucceeded(request);
    }

    public final Recommendation markRecommendationSucceeded(String name, Map<String, String> stateMetadata, String etag) {
        MarkRecommendationSucceededRequest request = MarkRecommendationSucceededRequest.newBuilder().setName(name).putAllStateMetadata(stateMetadata).setEtag(etag).build();
        return this.markRecommendationSucceeded(request);
    }

    public final Recommendation markRecommendationSucceeded(MarkRecommendationSucceededRequest request) {
        return (Recommendation)this.markRecommendationSucceededCallable().call((Object)request);
    }

    public final UnaryCallable<MarkRecommendationSucceededRequest, Recommendation> markRecommendationSucceededCallable() {
        return this.stub.markRecommendationSucceededCallable();
    }

    public final Recommendation markRecommendationFailed(RecommendationName name, Map<String, String> stateMetadata, String etag) {
        MarkRecommendationFailedRequest request = MarkRecommendationFailedRequest.newBuilder().setName(name == null ? null : name.toString()).putAllStateMetadata(stateMetadata).setEtag(etag).build();
        return this.markRecommendationFailed(request);
    }

    public final Recommendation markRecommendationFailed(String name, Map<String, String> stateMetadata, String etag) {
        MarkRecommendationFailedRequest request = MarkRecommendationFailedRequest.newBuilder().setName(name).putAllStateMetadata(stateMetadata).setEtag(etag).build();
        return this.markRecommendationFailed(request);
    }

    public final Recommendation markRecommendationFailed(MarkRecommendationFailedRequest request) {
        return (Recommendation)this.markRecommendationFailedCallable().call((Object)request);
    }

    public final UnaryCallable<MarkRecommendationFailedRequest, Recommendation> markRecommendationFailedCallable() {
        return this.stub.markRecommendationFailedCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListRecommendationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRecommendationsRequest, ListRecommendationsResponse, Recommendation, ListRecommendationsPage, ListRecommendationsFixedSizeCollection> {
        private ListRecommendationsFixedSizeCollection(List<ListRecommendationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRecommendationsFixedSizeCollection createEmptyCollection() {
            return new ListRecommendationsFixedSizeCollection(null, 0);
        }

        protected ListRecommendationsFixedSizeCollection createCollection(List<ListRecommendationsPage> pages, int collectionSize) {
            return new ListRecommendationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRecommendationsPage
    extends AbstractPage<ListRecommendationsRequest, ListRecommendationsResponse, Recommendation, ListRecommendationsPage> {
        private ListRecommendationsPage(PageContext<ListRecommendationsRequest, ListRecommendationsResponse, Recommendation> context, ListRecommendationsResponse response) {
            super(context, (Object)response);
        }

        private static ListRecommendationsPage createEmptyPage() {
            return new ListRecommendationsPage(null, null);
        }

        protected ListRecommendationsPage createPage(PageContext<ListRecommendationsRequest, ListRecommendationsResponse, Recommendation> context, ListRecommendationsResponse response) {
            return new ListRecommendationsPage(context, response);
        }

        public ApiFuture<ListRecommendationsPage> createPageAsync(PageContext<ListRecommendationsRequest, ListRecommendationsResponse, Recommendation> context, ApiFuture<ListRecommendationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRecommendationsPagedResponse
    extends AbstractPagedListResponse<ListRecommendationsRequest, ListRecommendationsResponse, Recommendation, ListRecommendationsPage, ListRecommendationsFixedSizeCollection> {
        public static ApiFuture<ListRecommendationsPagedResponse> createAsync(PageContext<ListRecommendationsRequest, ListRecommendationsResponse, Recommendation> context, ApiFuture<ListRecommendationsResponse> futureResponse) {
            ApiFuture<ListRecommendationsPage> futurePage = ListRecommendationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListRecommendationsPage, ListRecommendationsPagedResponse>(){

                public ListRecommendationsPagedResponse apply(ListRecommendationsPage input) {
                    return new ListRecommendationsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListRecommendationsPagedResponse(ListRecommendationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRecommendationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

