/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recommender.v1beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.recommender.v1beta1.GetRecommendationRequest;
import com.google.cloud.recommender.v1beta1.ListRecommendationsRequest;
import com.google.cloud.recommender.v1beta1.ListRecommendationsResponse;
import com.google.cloud.recommender.v1beta1.MarkRecommendationClaimedRequest;
import com.google.cloud.recommender.v1beta1.MarkRecommendationFailedRequest;
import com.google.cloud.recommender.v1beta1.MarkRecommendationSucceededRequest;
import com.google.cloud.recommender.v1beta1.Recommendation;
import com.google.cloud.recommender.v1beta1.RecommenderClient;
import com.google.cloud.recommender.v1beta1.stub.GrpcRecommenderStub;
import com.google.cloud.recommender.v1beta1.stub.RecommenderStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class RecommenderStubSettings
extends StubSettings<RecommenderStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListRecommendationsRequest, ListRecommendationsResponse, RecommenderClient.ListRecommendationsPagedResponse> listRecommendationsSettings;
    private final UnaryCallSettings<GetRecommendationRequest, Recommendation> getRecommendationSettings;
    private final UnaryCallSettings<MarkRecommendationClaimedRequest, Recommendation> markRecommendationClaimedSettings;
    private final UnaryCallSettings<MarkRecommendationSucceededRequest, Recommendation> markRecommendationSucceededSettings;
    private final UnaryCallSettings<MarkRecommendationFailedRequest, Recommendation> markRecommendationFailedSettings;
    private static final PagedListDescriptor<ListRecommendationsRequest, ListRecommendationsResponse, Recommendation> LIST_RECOMMENDATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListRecommendationsRequest, ListRecommendationsResponse, Recommendation>(){

        public String emptyToken() {
            return "";
        }

        public ListRecommendationsRequest injectToken(ListRecommendationsRequest payload, String token) {
            return ListRecommendationsRequest.newBuilder((ListRecommendationsRequest)payload).setPageToken(token).build();
        }

        public ListRecommendationsRequest injectPageSize(ListRecommendationsRequest payload, int pageSize) {
            return ListRecommendationsRequest.newBuilder((ListRecommendationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListRecommendationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListRecommendationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Recommendation> extractResources(ListRecommendationsResponse payload) {
            return payload.getRecommendationsList() != null ? payload.getRecommendationsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListRecommendationsRequest, ListRecommendationsResponse, RecommenderClient.ListRecommendationsPagedResponse> LIST_RECOMMENDATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListRecommendationsRequest, ListRecommendationsResponse, RecommenderClient.ListRecommendationsPagedResponse>(){

        public ApiFuture<RecommenderClient.ListRecommendationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListRecommendationsRequest, ListRecommendationsResponse> callable, ListRecommendationsRequest request, ApiCallContext context, ApiFuture<ListRecommendationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_RECOMMENDATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RecommenderClient.ListRecommendationsPagedResponse.createAsync((PageContext<ListRecommendationsRequest, ListRecommendationsResponse, Recommendation>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListRecommendationsRequest, ListRecommendationsResponse, RecommenderClient.ListRecommendationsPagedResponse> listRecommendationsSettings() {
        return this.listRecommendationsSettings;
    }

    public UnaryCallSettings<GetRecommendationRequest, Recommendation> getRecommendationSettings() {
        return this.getRecommendationSettings;
    }

    public UnaryCallSettings<MarkRecommendationClaimedRequest, Recommendation> markRecommendationClaimedSettings() {
        return this.markRecommendationClaimedSettings;
    }

    public UnaryCallSettings<MarkRecommendationSucceededRequest, Recommendation> markRecommendationSucceededSettings() {
        return this.markRecommendationSucceededSettings;
    }

    public UnaryCallSettings<MarkRecommendationFailedRequest, Recommendation> markRecommendationFailedSettings() {
        return this.markRecommendationFailedSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RecommenderStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcRecommenderStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "recommender.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RecommenderStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RecommenderStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RecommenderStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listRecommendationsSettings = settingsBuilder.listRecommendationsSettings().build();
        this.getRecommendationSettings = settingsBuilder.getRecommendationSettings().build();
        this.markRecommendationClaimedSettings = settingsBuilder.markRecommendationClaimedSettings().build();
        this.markRecommendationSucceededSettings = settingsBuilder.markRecommendationSucceededSettings().build();
        this.markRecommendationFailedSettings = settingsBuilder.markRecommendationFailedSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RecommenderStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListRecommendationsRequest, ListRecommendationsResponse, RecommenderClient.ListRecommendationsPagedResponse> listRecommendationsSettings;
        private final UnaryCallSettings.Builder<GetRecommendationRequest, Recommendation> getRecommendationSettings;
        private final UnaryCallSettings.Builder<MarkRecommendationClaimedRequest, Recommendation> markRecommendationClaimedSettings;
        private final UnaryCallSettings.Builder<MarkRecommendationSucceededRequest, Recommendation> markRecommendationSucceededSettings;
        private final UnaryCallSettings.Builder<MarkRecommendationFailedRequest, Recommendation> markRecommendationFailedSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listRecommendationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_RECOMMENDATIONS_PAGE_STR_FACT);
            this.getRecommendationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.markRecommendationClaimedSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.markRecommendationSucceededSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.markRecommendationFailedSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listRecommendationsSettings, this.getRecommendationSettings, this.markRecommendationClaimedSettings, this.markRecommendationSucceededSettings, this.markRecommendationFailedSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RecommenderStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RecommenderStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RecommenderStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(RecommenderStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listRecommendationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getRecommendationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.markRecommendationClaimedSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.markRecommendationSucceededSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.markRecommendationFailedSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(RecommenderStubSettings settings) {
            super((StubSettings)settings);
            this.listRecommendationsSettings = settings.listRecommendationsSettings.toBuilder();
            this.getRecommendationSettings = settings.getRecommendationSettings.toBuilder();
            this.markRecommendationClaimedSettings = settings.markRecommendationClaimedSettings.toBuilder();
            this.markRecommendationSucceededSettings = settings.markRecommendationSucceededSettings.toBuilder();
            this.markRecommendationFailedSettings = settings.markRecommendationFailedSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listRecommendationsSettings, this.getRecommendationSettings, this.markRecommendationClaimedSettings, this.markRecommendationSucceededSettings, this.markRecommendationFailedSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListRecommendationsRequest, ListRecommendationsResponse, RecommenderClient.ListRecommendationsPagedResponse> listRecommendationsSettings() {
            return this.listRecommendationsSettings;
        }

        public UnaryCallSettings.Builder<GetRecommendationRequest, Recommendation> getRecommendationSettings() {
            return this.getRecommendationSettings;
        }

        public UnaryCallSettings.Builder<MarkRecommendationClaimedRequest, Recommendation> markRecommendationClaimedSettings() {
            return this.markRecommendationClaimedSettings;
        }

        public UnaryCallSettings.Builder<MarkRecommendationSucceededRequest, Recommendation> markRecommendationSucceededSettings() {
            return this.markRecommendationSucceededSettings;
        }

        public UnaryCallSettings.Builder<MarkRecommendationFailedRequest, Recommendation> markRecommendationFailedSettings() {
            return this.markRecommendationFailedSettings;
        }

        public RecommenderStubSettings build() throws IOException {
            return new RecommenderStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

