/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recommendationengine.v1beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.recommendationengine.v1beta1.CatalogItem;
import com.google.cloud.recommendationengine.v1beta1.CatalogServiceClient;
import com.google.cloud.recommendationengine.v1beta1.CreateCatalogItemRequest;
import com.google.cloud.recommendationengine.v1beta1.DeleteCatalogItemRequest;
import com.google.cloud.recommendationengine.v1beta1.GetCatalogItemRequest;
import com.google.cloud.recommendationengine.v1beta1.ImportCatalogItemsRequest;
import com.google.cloud.recommendationengine.v1beta1.ImportCatalogItemsResponse;
import com.google.cloud.recommendationengine.v1beta1.ImportMetadata;
import com.google.cloud.recommendationengine.v1beta1.ListCatalogItemsRequest;
import com.google.cloud.recommendationengine.v1beta1.ListCatalogItemsResponse;
import com.google.cloud.recommendationengine.v1beta1.UpdateCatalogItemRequest;
import com.google.cloud.recommendationengine.v1beta1.stub.CatalogServiceStub;
import com.google.cloud.recommendationengine.v1beta1.stub.GrpcCatalogServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class CatalogServiceStubSettings
extends StubSettings<CatalogServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateCatalogItemRequest, CatalogItem> createCatalogItemSettings;
    private final UnaryCallSettings<GetCatalogItemRequest, CatalogItem> getCatalogItemSettings;
    private final PagedCallSettings<ListCatalogItemsRequest, ListCatalogItemsResponse, CatalogServiceClient.ListCatalogItemsPagedResponse> listCatalogItemsSettings;
    private final UnaryCallSettings<UpdateCatalogItemRequest, CatalogItem> updateCatalogItemSettings;
    private final UnaryCallSettings<DeleteCatalogItemRequest, Empty> deleteCatalogItemSettings;
    private final UnaryCallSettings<ImportCatalogItemsRequest, Operation> importCatalogItemsSettings;
    private final OperationCallSettings<ImportCatalogItemsRequest, ImportCatalogItemsResponse, ImportMetadata> importCatalogItemsOperationSettings;
    private static final PagedListDescriptor<ListCatalogItemsRequest, ListCatalogItemsResponse, CatalogItem> LIST_CATALOG_ITEMS_PAGE_STR_DESC = new PagedListDescriptor<ListCatalogItemsRequest, ListCatalogItemsResponse, CatalogItem>(){

        public String emptyToken() {
            return "";
        }

        public ListCatalogItemsRequest injectToken(ListCatalogItemsRequest payload, String token) {
            return ListCatalogItemsRequest.newBuilder((ListCatalogItemsRequest)payload).setPageToken(token).build();
        }

        public ListCatalogItemsRequest injectPageSize(ListCatalogItemsRequest payload, int pageSize) {
            return ListCatalogItemsRequest.newBuilder((ListCatalogItemsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCatalogItemsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCatalogItemsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<CatalogItem> extractResources(ListCatalogItemsResponse payload) {
            return payload.getCatalogItemsList() == null ? ImmutableList.of() : payload.getCatalogItemsList();
        }
    };
    private static final PagedListResponseFactory<ListCatalogItemsRequest, ListCatalogItemsResponse, CatalogServiceClient.ListCatalogItemsPagedResponse> LIST_CATALOG_ITEMS_PAGE_STR_FACT = new PagedListResponseFactory<ListCatalogItemsRequest, ListCatalogItemsResponse, CatalogServiceClient.ListCatalogItemsPagedResponse>(){

        public ApiFuture<CatalogServiceClient.ListCatalogItemsPagedResponse> getFuturePagedResponse(UnaryCallable<ListCatalogItemsRequest, ListCatalogItemsResponse> callable, ListCatalogItemsRequest request, ApiCallContext context, ApiFuture<ListCatalogItemsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CATALOG_ITEMS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CatalogServiceClient.ListCatalogItemsPagedResponse.createAsync((PageContext<ListCatalogItemsRequest, ListCatalogItemsResponse, CatalogItem>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateCatalogItemRequest, CatalogItem> createCatalogItemSettings() {
        return this.createCatalogItemSettings;
    }

    public UnaryCallSettings<GetCatalogItemRequest, CatalogItem> getCatalogItemSettings() {
        return this.getCatalogItemSettings;
    }

    public PagedCallSettings<ListCatalogItemsRequest, ListCatalogItemsResponse, CatalogServiceClient.ListCatalogItemsPagedResponse> listCatalogItemsSettings() {
        return this.listCatalogItemsSettings;
    }

    public UnaryCallSettings<UpdateCatalogItemRequest, CatalogItem> updateCatalogItemSettings() {
        return this.updateCatalogItemSettings;
    }

    public UnaryCallSettings<DeleteCatalogItemRequest, Empty> deleteCatalogItemSettings() {
        return this.deleteCatalogItemSettings;
    }

    public UnaryCallSettings<ImportCatalogItemsRequest, Operation> importCatalogItemsSettings() {
        return this.importCatalogItemsSettings;
    }

    public OperationCallSettings<ImportCatalogItemsRequest, ImportCatalogItemsResponse, ImportMetadata> importCatalogItemsOperationSettings() {
        return this.importCatalogItemsOperationSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CatalogServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcCatalogServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "recommendationengine.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "recommendationengine.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CatalogServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CatalogServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CatalogServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createCatalogItemSettings = settingsBuilder.createCatalogItemSettings().build();
        this.getCatalogItemSettings = settingsBuilder.getCatalogItemSettings().build();
        this.listCatalogItemsSettings = settingsBuilder.listCatalogItemsSettings().build();
        this.updateCatalogItemSettings = settingsBuilder.updateCatalogItemSettings().build();
        this.deleteCatalogItemSettings = settingsBuilder.deleteCatalogItemSettings().build();
        this.importCatalogItemsSettings = settingsBuilder.importCatalogItemsSettings().build();
        this.importCatalogItemsOperationSettings = settingsBuilder.importCatalogItemsOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CatalogServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateCatalogItemRequest, CatalogItem> createCatalogItemSettings;
        private final UnaryCallSettings.Builder<GetCatalogItemRequest, CatalogItem> getCatalogItemSettings;
        private final PagedCallSettings.Builder<ListCatalogItemsRequest, ListCatalogItemsResponse, CatalogServiceClient.ListCatalogItemsPagedResponse> listCatalogItemsSettings;
        private final UnaryCallSettings.Builder<UpdateCatalogItemRequest, CatalogItem> updateCatalogItemSettings;
        private final UnaryCallSettings.Builder<DeleteCatalogItemRequest, Empty> deleteCatalogItemSettings;
        private final UnaryCallSettings.Builder<ImportCatalogItemsRequest, Operation> importCatalogItemsSettings;
        private final OperationCallSettings.Builder<ImportCatalogItemsRequest, ImportCatalogItemsResponse, ImportMetadata> importCatalogItemsOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createCatalogItemSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getCatalogItemSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listCatalogItemsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CATALOG_ITEMS_PAGE_STR_FACT);
            this.updateCatalogItemSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteCatalogItemSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importCatalogItemsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importCatalogItemsOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createCatalogItemSettings, this.getCatalogItemSettings, this.listCatalogItemsSettings, this.updateCatalogItemSettings, this.deleteCatalogItemSettings, this.importCatalogItemsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(CatalogServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createCatalogItemSettings = settings.createCatalogItemSettings.toBuilder();
            this.getCatalogItemSettings = settings.getCatalogItemSettings.toBuilder();
            this.listCatalogItemsSettings = settings.listCatalogItemsSettings.toBuilder();
            this.updateCatalogItemSettings = settings.updateCatalogItemSettings.toBuilder();
            this.deleteCatalogItemSettings = settings.deleteCatalogItemSettings.toBuilder();
            this.importCatalogItemsSettings = settings.importCatalogItemsSettings.toBuilder();
            this.importCatalogItemsOperationSettings = settings.importCatalogItemsOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createCatalogItemSettings, this.getCatalogItemSettings, this.listCatalogItemsSettings, this.updateCatalogItemSettings, this.deleteCatalogItemSettings, this.importCatalogItemsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CatalogServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CatalogServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CatalogServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(CatalogServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(CatalogServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createCatalogItemSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getCatalogItemSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listCatalogItemsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateCatalogItemSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteCatalogItemSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.importCatalogItemsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.importCatalogItemsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ImportCatalogItemsResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ImportMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateCatalogItemRequest, CatalogItem> createCatalogItemSettings() {
            return this.createCatalogItemSettings;
        }

        public UnaryCallSettings.Builder<GetCatalogItemRequest, CatalogItem> getCatalogItemSettings() {
            return this.getCatalogItemSettings;
        }

        public PagedCallSettings.Builder<ListCatalogItemsRequest, ListCatalogItemsResponse, CatalogServiceClient.ListCatalogItemsPagedResponse> listCatalogItemsSettings() {
            return this.listCatalogItemsSettings;
        }

        public UnaryCallSettings.Builder<UpdateCatalogItemRequest, CatalogItem> updateCatalogItemSettings() {
            return this.updateCatalogItemSettings;
        }

        public UnaryCallSettings.Builder<DeleteCatalogItemRequest, Empty> deleteCatalogItemSettings() {
            return this.deleteCatalogItemSettings;
        }

        public UnaryCallSettings.Builder<ImportCatalogItemsRequest, Operation> importCatalogItemsSettings() {
            return this.importCatalogItemsSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ImportCatalogItemsRequest, ImportCatalogItemsResponse, ImportMetadata> importCatalogItemsOperationSettings() {
            return this.importCatalogItemsOperationSettings;
        }

        public CatalogServiceStubSettings build() throws IOException {
            return new CatalogServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

