/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recaptchaenterprise.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseServiceClient;
import com.google.cloud.recaptchaenterprise.v1.stub.GrpcRecaptchaEnterpriseServiceStub;
import com.google.cloud.recaptchaenterprise.v1.stub.RecaptchaEnterpriseServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import com.google.recaptchaenterprise.v1.AnnotateAssessmentRequest;
import com.google.recaptchaenterprise.v1.AnnotateAssessmentResponse;
import com.google.recaptchaenterprise.v1.Assessment;
import com.google.recaptchaenterprise.v1.CreateAssessmentRequest;
import com.google.recaptchaenterprise.v1.CreateFirewallPolicyRequest;
import com.google.recaptchaenterprise.v1.CreateKeyRequest;
import com.google.recaptchaenterprise.v1.DeleteFirewallPolicyRequest;
import com.google.recaptchaenterprise.v1.DeleteKeyRequest;
import com.google.recaptchaenterprise.v1.FirewallPolicy;
import com.google.recaptchaenterprise.v1.GetFirewallPolicyRequest;
import com.google.recaptchaenterprise.v1.GetKeyRequest;
import com.google.recaptchaenterprise.v1.GetMetricsRequest;
import com.google.recaptchaenterprise.v1.Key;
import com.google.recaptchaenterprise.v1.ListFirewallPoliciesRequest;
import com.google.recaptchaenterprise.v1.ListFirewallPoliciesResponse;
import com.google.recaptchaenterprise.v1.ListKeysRequest;
import com.google.recaptchaenterprise.v1.ListKeysResponse;
import com.google.recaptchaenterprise.v1.ListRelatedAccountGroupMembershipsRequest;
import com.google.recaptchaenterprise.v1.ListRelatedAccountGroupMembershipsResponse;
import com.google.recaptchaenterprise.v1.ListRelatedAccountGroupsRequest;
import com.google.recaptchaenterprise.v1.ListRelatedAccountGroupsResponse;
import com.google.recaptchaenterprise.v1.Metrics;
import com.google.recaptchaenterprise.v1.MigrateKeyRequest;
import com.google.recaptchaenterprise.v1.RelatedAccountGroup;
import com.google.recaptchaenterprise.v1.RelatedAccountGroupMembership;
import com.google.recaptchaenterprise.v1.RetrieveLegacySecretKeyRequest;
import com.google.recaptchaenterprise.v1.RetrieveLegacySecretKeyResponse;
import com.google.recaptchaenterprise.v1.SearchRelatedAccountGroupMembershipsRequest;
import com.google.recaptchaenterprise.v1.SearchRelatedAccountGroupMembershipsResponse;
import com.google.recaptchaenterprise.v1.UpdateFirewallPolicyRequest;
import com.google.recaptchaenterprise.v1.UpdateKeyRequest;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class RecaptchaEnterpriseServiceStubSettings
extends StubSettings<RecaptchaEnterpriseServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateAssessmentRequest, Assessment> createAssessmentSettings;
    private final UnaryCallSettings<AnnotateAssessmentRequest, AnnotateAssessmentResponse> annotateAssessmentSettings;
    private final UnaryCallSettings<CreateKeyRequest, Key> createKeySettings;
    private final PagedCallSettings<ListKeysRequest, ListKeysResponse, RecaptchaEnterpriseServiceClient.ListKeysPagedResponse> listKeysSettings;
    private final UnaryCallSettings<RetrieveLegacySecretKeyRequest, RetrieveLegacySecretKeyResponse> retrieveLegacySecretKeySettings;
    private final UnaryCallSettings<GetKeyRequest, Key> getKeySettings;
    private final UnaryCallSettings<UpdateKeyRequest, Key> updateKeySettings;
    private final UnaryCallSettings<DeleteKeyRequest, Empty> deleteKeySettings;
    private final UnaryCallSettings<MigrateKeyRequest, Key> migrateKeySettings;
    private final UnaryCallSettings<GetMetricsRequest, Metrics> getMetricsSettings;
    private final UnaryCallSettings<CreateFirewallPolicyRequest, FirewallPolicy> createFirewallPolicySettings;
    private final PagedCallSettings<ListFirewallPoliciesRequest, ListFirewallPoliciesResponse, RecaptchaEnterpriseServiceClient.ListFirewallPoliciesPagedResponse> listFirewallPoliciesSettings;
    private final UnaryCallSettings<GetFirewallPolicyRequest, FirewallPolicy> getFirewallPolicySettings;
    private final UnaryCallSettings<UpdateFirewallPolicyRequest, FirewallPolicy> updateFirewallPolicySettings;
    private final UnaryCallSettings<DeleteFirewallPolicyRequest, Empty> deleteFirewallPolicySettings;
    private final PagedCallSettings<ListRelatedAccountGroupsRequest, ListRelatedAccountGroupsResponse, RecaptchaEnterpriseServiceClient.ListRelatedAccountGroupsPagedResponse> listRelatedAccountGroupsSettings;
    private final PagedCallSettings<ListRelatedAccountGroupMembershipsRequest, ListRelatedAccountGroupMembershipsResponse, RecaptchaEnterpriseServiceClient.ListRelatedAccountGroupMembershipsPagedResponse> listRelatedAccountGroupMembershipsSettings;
    private final PagedCallSettings<SearchRelatedAccountGroupMembershipsRequest, SearchRelatedAccountGroupMembershipsResponse, RecaptchaEnterpriseServiceClient.SearchRelatedAccountGroupMembershipsPagedResponse> searchRelatedAccountGroupMembershipsSettings;
    private static final PagedListDescriptor<ListKeysRequest, ListKeysResponse, Key> LIST_KEYS_PAGE_STR_DESC = new PagedListDescriptor<ListKeysRequest, ListKeysResponse, Key>(){

        public String emptyToken() {
            return "";
        }

        public ListKeysRequest injectToken(ListKeysRequest payload, String token) {
            return ListKeysRequest.newBuilder((ListKeysRequest)payload).setPageToken(token).build();
        }

        public ListKeysRequest injectPageSize(ListKeysRequest payload, int pageSize) {
            return ListKeysRequest.newBuilder((ListKeysRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListKeysRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListKeysResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Key> extractResources(ListKeysResponse payload) {
            return payload.getKeysList() == null ? ImmutableList.of() : payload.getKeysList();
        }
    };
    private static final PagedListDescriptor<ListFirewallPoliciesRequest, ListFirewallPoliciesResponse, FirewallPolicy> LIST_FIREWALL_POLICIES_PAGE_STR_DESC = new PagedListDescriptor<ListFirewallPoliciesRequest, ListFirewallPoliciesResponse, FirewallPolicy>(){

        public String emptyToken() {
            return "";
        }

        public ListFirewallPoliciesRequest injectToken(ListFirewallPoliciesRequest payload, String token) {
            return ListFirewallPoliciesRequest.newBuilder((ListFirewallPoliciesRequest)payload).setPageToken(token).build();
        }

        public ListFirewallPoliciesRequest injectPageSize(ListFirewallPoliciesRequest payload, int pageSize) {
            return ListFirewallPoliciesRequest.newBuilder((ListFirewallPoliciesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListFirewallPoliciesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListFirewallPoliciesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<FirewallPolicy> extractResources(ListFirewallPoliciesResponse payload) {
            return payload.getFirewallPoliciesList() == null ? ImmutableList.of() : payload.getFirewallPoliciesList();
        }
    };
    private static final PagedListDescriptor<ListRelatedAccountGroupsRequest, ListRelatedAccountGroupsResponse, RelatedAccountGroup> LIST_RELATED_ACCOUNT_GROUPS_PAGE_STR_DESC = new PagedListDescriptor<ListRelatedAccountGroupsRequest, ListRelatedAccountGroupsResponse, RelatedAccountGroup>(){

        public String emptyToken() {
            return "";
        }

        public ListRelatedAccountGroupsRequest injectToken(ListRelatedAccountGroupsRequest payload, String token) {
            return ListRelatedAccountGroupsRequest.newBuilder((ListRelatedAccountGroupsRequest)payload).setPageToken(token).build();
        }

        public ListRelatedAccountGroupsRequest injectPageSize(ListRelatedAccountGroupsRequest payload, int pageSize) {
            return ListRelatedAccountGroupsRequest.newBuilder((ListRelatedAccountGroupsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListRelatedAccountGroupsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListRelatedAccountGroupsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<RelatedAccountGroup> extractResources(ListRelatedAccountGroupsResponse payload) {
            return payload.getRelatedAccountGroupsList() == null ? ImmutableList.of() : payload.getRelatedAccountGroupsList();
        }
    };
    private static final PagedListDescriptor<ListRelatedAccountGroupMembershipsRequest, ListRelatedAccountGroupMembershipsResponse, RelatedAccountGroupMembership> LIST_RELATED_ACCOUNT_GROUP_MEMBERSHIPS_PAGE_STR_DESC = new PagedListDescriptor<ListRelatedAccountGroupMembershipsRequest, ListRelatedAccountGroupMembershipsResponse, RelatedAccountGroupMembership>(){

        public String emptyToken() {
            return "";
        }

        public ListRelatedAccountGroupMembershipsRequest injectToken(ListRelatedAccountGroupMembershipsRequest payload, String token) {
            return ListRelatedAccountGroupMembershipsRequest.newBuilder((ListRelatedAccountGroupMembershipsRequest)payload).setPageToken(token).build();
        }

        public ListRelatedAccountGroupMembershipsRequest injectPageSize(ListRelatedAccountGroupMembershipsRequest payload, int pageSize) {
            return ListRelatedAccountGroupMembershipsRequest.newBuilder((ListRelatedAccountGroupMembershipsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListRelatedAccountGroupMembershipsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListRelatedAccountGroupMembershipsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<RelatedAccountGroupMembership> extractResources(ListRelatedAccountGroupMembershipsResponse payload) {
            return payload.getRelatedAccountGroupMembershipsList() == null ? ImmutableList.of() : payload.getRelatedAccountGroupMembershipsList();
        }
    };
    private static final PagedListDescriptor<SearchRelatedAccountGroupMembershipsRequest, SearchRelatedAccountGroupMembershipsResponse, RelatedAccountGroupMembership> SEARCH_RELATED_ACCOUNT_GROUP_MEMBERSHIPS_PAGE_STR_DESC = new PagedListDescriptor<SearchRelatedAccountGroupMembershipsRequest, SearchRelatedAccountGroupMembershipsResponse, RelatedAccountGroupMembership>(){

        public String emptyToken() {
            return "";
        }

        public SearchRelatedAccountGroupMembershipsRequest injectToken(SearchRelatedAccountGroupMembershipsRequest payload, String token) {
            return SearchRelatedAccountGroupMembershipsRequest.newBuilder((SearchRelatedAccountGroupMembershipsRequest)payload).setPageToken(token).build();
        }

        public SearchRelatedAccountGroupMembershipsRequest injectPageSize(SearchRelatedAccountGroupMembershipsRequest payload, int pageSize) {
            return SearchRelatedAccountGroupMembershipsRequest.newBuilder((SearchRelatedAccountGroupMembershipsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchRelatedAccountGroupMembershipsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchRelatedAccountGroupMembershipsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<RelatedAccountGroupMembership> extractResources(SearchRelatedAccountGroupMembershipsResponse payload) {
            return payload.getRelatedAccountGroupMembershipsList() == null ? ImmutableList.of() : payload.getRelatedAccountGroupMembershipsList();
        }
    };
    private static final PagedListResponseFactory<ListKeysRequest, ListKeysResponse, RecaptchaEnterpriseServiceClient.ListKeysPagedResponse> LIST_KEYS_PAGE_STR_FACT = new PagedListResponseFactory<ListKeysRequest, ListKeysResponse, RecaptchaEnterpriseServiceClient.ListKeysPagedResponse>(){

        public ApiFuture<RecaptchaEnterpriseServiceClient.ListKeysPagedResponse> getFuturePagedResponse(UnaryCallable<ListKeysRequest, ListKeysResponse> callable, ListKeysRequest request, ApiCallContext context, ApiFuture<ListKeysResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_KEYS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RecaptchaEnterpriseServiceClient.ListKeysPagedResponse.createAsync((PageContext<ListKeysRequest, ListKeysResponse, Key>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListFirewallPoliciesRequest, ListFirewallPoliciesResponse, RecaptchaEnterpriseServiceClient.ListFirewallPoliciesPagedResponse> LIST_FIREWALL_POLICIES_PAGE_STR_FACT = new PagedListResponseFactory<ListFirewallPoliciesRequest, ListFirewallPoliciesResponse, RecaptchaEnterpriseServiceClient.ListFirewallPoliciesPagedResponse>(){

        public ApiFuture<RecaptchaEnterpriseServiceClient.ListFirewallPoliciesPagedResponse> getFuturePagedResponse(UnaryCallable<ListFirewallPoliciesRequest, ListFirewallPoliciesResponse> callable, ListFirewallPoliciesRequest request, ApiCallContext context, ApiFuture<ListFirewallPoliciesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_FIREWALL_POLICIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RecaptchaEnterpriseServiceClient.ListFirewallPoliciesPagedResponse.createAsync((PageContext<ListFirewallPoliciesRequest, ListFirewallPoliciesResponse, FirewallPolicy>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListRelatedAccountGroupsRequest, ListRelatedAccountGroupsResponse, RecaptchaEnterpriseServiceClient.ListRelatedAccountGroupsPagedResponse> LIST_RELATED_ACCOUNT_GROUPS_PAGE_STR_FACT = new PagedListResponseFactory<ListRelatedAccountGroupsRequest, ListRelatedAccountGroupsResponse, RecaptchaEnterpriseServiceClient.ListRelatedAccountGroupsPagedResponse>(){

        public ApiFuture<RecaptchaEnterpriseServiceClient.ListRelatedAccountGroupsPagedResponse> getFuturePagedResponse(UnaryCallable<ListRelatedAccountGroupsRequest, ListRelatedAccountGroupsResponse> callable, ListRelatedAccountGroupsRequest request, ApiCallContext context, ApiFuture<ListRelatedAccountGroupsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_RELATED_ACCOUNT_GROUPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RecaptchaEnterpriseServiceClient.ListRelatedAccountGroupsPagedResponse.createAsync((PageContext<ListRelatedAccountGroupsRequest, ListRelatedAccountGroupsResponse, RelatedAccountGroup>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListRelatedAccountGroupMembershipsRequest, ListRelatedAccountGroupMembershipsResponse, RecaptchaEnterpriseServiceClient.ListRelatedAccountGroupMembershipsPagedResponse> LIST_RELATED_ACCOUNT_GROUP_MEMBERSHIPS_PAGE_STR_FACT = new PagedListResponseFactory<ListRelatedAccountGroupMembershipsRequest, ListRelatedAccountGroupMembershipsResponse, RecaptchaEnterpriseServiceClient.ListRelatedAccountGroupMembershipsPagedResponse>(){

        public ApiFuture<RecaptchaEnterpriseServiceClient.ListRelatedAccountGroupMembershipsPagedResponse> getFuturePagedResponse(UnaryCallable<ListRelatedAccountGroupMembershipsRequest, ListRelatedAccountGroupMembershipsResponse> callable, ListRelatedAccountGroupMembershipsRequest request, ApiCallContext context, ApiFuture<ListRelatedAccountGroupMembershipsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_RELATED_ACCOUNT_GROUP_MEMBERSHIPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RecaptchaEnterpriseServiceClient.ListRelatedAccountGroupMembershipsPagedResponse.createAsync((PageContext<ListRelatedAccountGroupMembershipsRequest, ListRelatedAccountGroupMembershipsResponse, RelatedAccountGroupMembership>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<SearchRelatedAccountGroupMembershipsRequest, SearchRelatedAccountGroupMembershipsResponse, RecaptchaEnterpriseServiceClient.SearchRelatedAccountGroupMembershipsPagedResponse> SEARCH_RELATED_ACCOUNT_GROUP_MEMBERSHIPS_PAGE_STR_FACT = new PagedListResponseFactory<SearchRelatedAccountGroupMembershipsRequest, SearchRelatedAccountGroupMembershipsResponse, RecaptchaEnterpriseServiceClient.SearchRelatedAccountGroupMembershipsPagedResponse>(){

        public ApiFuture<RecaptchaEnterpriseServiceClient.SearchRelatedAccountGroupMembershipsPagedResponse> getFuturePagedResponse(UnaryCallable<SearchRelatedAccountGroupMembershipsRequest, SearchRelatedAccountGroupMembershipsResponse> callable, SearchRelatedAccountGroupMembershipsRequest request, ApiCallContext context, ApiFuture<SearchRelatedAccountGroupMembershipsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_RELATED_ACCOUNT_GROUP_MEMBERSHIPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RecaptchaEnterpriseServiceClient.SearchRelatedAccountGroupMembershipsPagedResponse.createAsync((PageContext<SearchRelatedAccountGroupMembershipsRequest, SearchRelatedAccountGroupMembershipsResponse, RelatedAccountGroupMembership>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateAssessmentRequest, Assessment> createAssessmentSettings() {
        return this.createAssessmentSettings;
    }

    public UnaryCallSettings<AnnotateAssessmentRequest, AnnotateAssessmentResponse> annotateAssessmentSettings() {
        return this.annotateAssessmentSettings;
    }

    public UnaryCallSettings<CreateKeyRequest, Key> createKeySettings() {
        return this.createKeySettings;
    }

    public PagedCallSettings<ListKeysRequest, ListKeysResponse, RecaptchaEnterpriseServiceClient.ListKeysPagedResponse> listKeysSettings() {
        return this.listKeysSettings;
    }

    public UnaryCallSettings<RetrieveLegacySecretKeyRequest, RetrieveLegacySecretKeyResponse> retrieveLegacySecretKeySettings() {
        return this.retrieveLegacySecretKeySettings;
    }

    public UnaryCallSettings<GetKeyRequest, Key> getKeySettings() {
        return this.getKeySettings;
    }

    public UnaryCallSettings<UpdateKeyRequest, Key> updateKeySettings() {
        return this.updateKeySettings;
    }

    public UnaryCallSettings<DeleteKeyRequest, Empty> deleteKeySettings() {
        return this.deleteKeySettings;
    }

    public UnaryCallSettings<MigrateKeyRequest, Key> migrateKeySettings() {
        return this.migrateKeySettings;
    }

    public UnaryCallSettings<GetMetricsRequest, Metrics> getMetricsSettings() {
        return this.getMetricsSettings;
    }

    public UnaryCallSettings<CreateFirewallPolicyRequest, FirewallPolicy> createFirewallPolicySettings() {
        return this.createFirewallPolicySettings;
    }

    public PagedCallSettings<ListFirewallPoliciesRequest, ListFirewallPoliciesResponse, RecaptchaEnterpriseServiceClient.ListFirewallPoliciesPagedResponse> listFirewallPoliciesSettings() {
        return this.listFirewallPoliciesSettings;
    }

    public UnaryCallSettings<GetFirewallPolicyRequest, FirewallPolicy> getFirewallPolicySettings() {
        return this.getFirewallPolicySettings;
    }

    public UnaryCallSettings<UpdateFirewallPolicyRequest, FirewallPolicy> updateFirewallPolicySettings() {
        return this.updateFirewallPolicySettings;
    }

    public UnaryCallSettings<DeleteFirewallPolicyRequest, Empty> deleteFirewallPolicySettings() {
        return this.deleteFirewallPolicySettings;
    }

    public PagedCallSettings<ListRelatedAccountGroupsRequest, ListRelatedAccountGroupsResponse, RecaptchaEnterpriseServiceClient.ListRelatedAccountGroupsPagedResponse> listRelatedAccountGroupsSettings() {
        return this.listRelatedAccountGroupsSettings;
    }

    public PagedCallSettings<ListRelatedAccountGroupMembershipsRequest, ListRelatedAccountGroupMembershipsResponse, RecaptchaEnterpriseServiceClient.ListRelatedAccountGroupMembershipsPagedResponse> listRelatedAccountGroupMembershipsSettings() {
        return this.listRelatedAccountGroupMembershipsSettings;
    }

    public PagedCallSettings<SearchRelatedAccountGroupMembershipsRequest, SearchRelatedAccountGroupMembershipsResponse, RecaptchaEnterpriseServiceClient.SearchRelatedAccountGroupMembershipsPagedResponse> searchRelatedAccountGroupMembershipsSettings() {
        return this.searchRelatedAccountGroupMembershipsSettings;
    }

    public RecaptchaEnterpriseServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcRecaptchaEnterpriseServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "recaptchaenterprise";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "recaptchaenterprise.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "recaptchaenterprise.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RecaptchaEnterpriseServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RecaptchaEnterpriseServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RecaptchaEnterpriseServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createAssessmentSettings = settingsBuilder.createAssessmentSettings().build();
        this.annotateAssessmentSettings = settingsBuilder.annotateAssessmentSettings().build();
        this.createKeySettings = settingsBuilder.createKeySettings().build();
        this.listKeysSettings = settingsBuilder.listKeysSettings().build();
        this.retrieveLegacySecretKeySettings = settingsBuilder.retrieveLegacySecretKeySettings().build();
        this.getKeySettings = settingsBuilder.getKeySettings().build();
        this.updateKeySettings = settingsBuilder.updateKeySettings().build();
        this.deleteKeySettings = settingsBuilder.deleteKeySettings().build();
        this.migrateKeySettings = settingsBuilder.migrateKeySettings().build();
        this.getMetricsSettings = settingsBuilder.getMetricsSettings().build();
        this.createFirewallPolicySettings = settingsBuilder.createFirewallPolicySettings().build();
        this.listFirewallPoliciesSettings = settingsBuilder.listFirewallPoliciesSettings().build();
        this.getFirewallPolicySettings = settingsBuilder.getFirewallPolicySettings().build();
        this.updateFirewallPolicySettings = settingsBuilder.updateFirewallPolicySettings().build();
        this.deleteFirewallPolicySettings = settingsBuilder.deleteFirewallPolicySettings().build();
        this.listRelatedAccountGroupsSettings = settingsBuilder.listRelatedAccountGroupsSettings().build();
        this.listRelatedAccountGroupMembershipsSettings = settingsBuilder.listRelatedAccountGroupMembershipsSettings().build();
        this.searchRelatedAccountGroupMembershipsSettings = settingsBuilder.searchRelatedAccountGroupMembershipsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RecaptchaEnterpriseServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateAssessmentRequest, Assessment> createAssessmentSettings;
        private final UnaryCallSettings.Builder<AnnotateAssessmentRequest, AnnotateAssessmentResponse> annotateAssessmentSettings;
        private final UnaryCallSettings.Builder<CreateKeyRequest, Key> createKeySettings;
        private final PagedCallSettings.Builder<ListKeysRequest, ListKeysResponse, RecaptchaEnterpriseServiceClient.ListKeysPagedResponse> listKeysSettings;
        private final UnaryCallSettings.Builder<RetrieveLegacySecretKeyRequest, RetrieveLegacySecretKeyResponse> retrieveLegacySecretKeySettings;
        private final UnaryCallSettings.Builder<GetKeyRequest, Key> getKeySettings;
        private final UnaryCallSettings.Builder<UpdateKeyRequest, Key> updateKeySettings;
        private final UnaryCallSettings.Builder<DeleteKeyRequest, Empty> deleteKeySettings;
        private final UnaryCallSettings.Builder<MigrateKeyRequest, Key> migrateKeySettings;
        private final UnaryCallSettings.Builder<GetMetricsRequest, Metrics> getMetricsSettings;
        private final UnaryCallSettings.Builder<CreateFirewallPolicyRequest, FirewallPolicy> createFirewallPolicySettings;
        private final PagedCallSettings.Builder<ListFirewallPoliciesRequest, ListFirewallPoliciesResponse, RecaptchaEnterpriseServiceClient.ListFirewallPoliciesPagedResponse> listFirewallPoliciesSettings;
        private final UnaryCallSettings.Builder<GetFirewallPolicyRequest, FirewallPolicy> getFirewallPolicySettings;
        private final UnaryCallSettings.Builder<UpdateFirewallPolicyRequest, FirewallPolicy> updateFirewallPolicySettings;
        private final UnaryCallSettings.Builder<DeleteFirewallPolicyRequest, Empty> deleteFirewallPolicySettings;
        private final PagedCallSettings.Builder<ListRelatedAccountGroupsRequest, ListRelatedAccountGroupsResponse, RecaptchaEnterpriseServiceClient.ListRelatedAccountGroupsPagedResponse> listRelatedAccountGroupsSettings;
        private final PagedCallSettings.Builder<ListRelatedAccountGroupMembershipsRequest, ListRelatedAccountGroupMembershipsResponse, RecaptchaEnterpriseServiceClient.ListRelatedAccountGroupMembershipsPagedResponse> listRelatedAccountGroupMembershipsSettings;
        private final PagedCallSettings.Builder<SearchRelatedAccountGroupMembershipsRequest, SearchRelatedAccountGroupMembershipsResponse, RecaptchaEnterpriseServiceClient.SearchRelatedAccountGroupMembershipsPagedResponse> searchRelatedAccountGroupMembershipsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createAssessmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.annotateAssessmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listKeysSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_KEYS_PAGE_STR_FACT);
            this.retrieveLegacySecretKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.migrateKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getMetricsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createFirewallPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listFirewallPoliciesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_FIREWALL_POLICIES_PAGE_STR_FACT);
            this.getFirewallPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateFirewallPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteFirewallPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRelatedAccountGroupsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_RELATED_ACCOUNT_GROUPS_PAGE_STR_FACT);
            this.listRelatedAccountGroupMembershipsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_RELATED_ACCOUNT_GROUP_MEMBERSHIPS_PAGE_STR_FACT);
            this.searchRelatedAccountGroupMembershipsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_RELATED_ACCOUNT_GROUP_MEMBERSHIPS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createAssessmentSettings, this.annotateAssessmentSettings, this.createKeySettings, this.listKeysSettings, this.retrieveLegacySecretKeySettings, this.getKeySettings, this.updateKeySettings, this.deleteKeySettings, this.migrateKeySettings, this.getMetricsSettings, this.createFirewallPolicySettings, this.listFirewallPoliciesSettings, (Object[])new UnaryCallSettings.Builder[]{this.getFirewallPolicySettings, this.updateFirewallPolicySettings, this.deleteFirewallPolicySettings, this.listRelatedAccountGroupsSettings, this.listRelatedAccountGroupMembershipsSettings, this.searchRelatedAccountGroupMembershipsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(RecaptchaEnterpriseServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createAssessmentSettings = settings.createAssessmentSettings.toBuilder();
            this.annotateAssessmentSettings = settings.annotateAssessmentSettings.toBuilder();
            this.createKeySettings = settings.createKeySettings.toBuilder();
            this.listKeysSettings = settings.listKeysSettings.toBuilder();
            this.retrieveLegacySecretKeySettings = settings.retrieveLegacySecretKeySettings.toBuilder();
            this.getKeySettings = settings.getKeySettings.toBuilder();
            this.updateKeySettings = settings.updateKeySettings.toBuilder();
            this.deleteKeySettings = settings.deleteKeySettings.toBuilder();
            this.migrateKeySettings = settings.migrateKeySettings.toBuilder();
            this.getMetricsSettings = settings.getMetricsSettings.toBuilder();
            this.createFirewallPolicySettings = settings.createFirewallPolicySettings.toBuilder();
            this.listFirewallPoliciesSettings = settings.listFirewallPoliciesSettings.toBuilder();
            this.getFirewallPolicySettings = settings.getFirewallPolicySettings.toBuilder();
            this.updateFirewallPolicySettings = settings.updateFirewallPolicySettings.toBuilder();
            this.deleteFirewallPolicySettings = settings.deleteFirewallPolicySettings.toBuilder();
            this.listRelatedAccountGroupsSettings = settings.listRelatedAccountGroupsSettings.toBuilder();
            this.listRelatedAccountGroupMembershipsSettings = settings.listRelatedAccountGroupMembershipsSettings.toBuilder();
            this.searchRelatedAccountGroupMembershipsSettings = settings.searchRelatedAccountGroupMembershipsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createAssessmentSettings, this.annotateAssessmentSettings, this.createKeySettings, this.listKeysSettings, this.retrieveLegacySecretKeySettings, this.getKeySettings, this.updateKeySettings, this.deleteKeySettings, this.migrateKeySettings, this.getMetricsSettings, this.createFirewallPolicySettings, this.listFirewallPoliciesSettings, (Object[])new UnaryCallSettings.Builder[]{this.getFirewallPolicySettings, this.updateFirewallPolicySettings, this.deleteFirewallPolicySettings, this.listRelatedAccountGroupsSettings, this.listRelatedAccountGroupMembershipsSettings, this.searchRelatedAccountGroupMembershipsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RecaptchaEnterpriseServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RecaptchaEnterpriseServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RecaptchaEnterpriseServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(RecaptchaEnterpriseServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(RecaptchaEnterpriseServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createAssessmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.annotateAssessmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listKeysSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.retrieveLegacySecretKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.migrateKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getMetricsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createFirewallPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listFirewallPoliciesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getFirewallPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateFirewallPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteFirewallPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listRelatedAccountGroupsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listRelatedAccountGroupMembershipsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.searchRelatedAccountGroupMembershipsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateAssessmentRequest, Assessment> createAssessmentSettings() {
            return this.createAssessmentSettings;
        }

        public UnaryCallSettings.Builder<AnnotateAssessmentRequest, AnnotateAssessmentResponse> annotateAssessmentSettings() {
            return this.annotateAssessmentSettings;
        }

        public UnaryCallSettings.Builder<CreateKeyRequest, Key> createKeySettings() {
            return this.createKeySettings;
        }

        public PagedCallSettings.Builder<ListKeysRequest, ListKeysResponse, RecaptchaEnterpriseServiceClient.ListKeysPagedResponse> listKeysSettings() {
            return this.listKeysSettings;
        }

        public UnaryCallSettings.Builder<RetrieveLegacySecretKeyRequest, RetrieveLegacySecretKeyResponse> retrieveLegacySecretKeySettings() {
            return this.retrieveLegacySecretKeySettings;
        }

        public UnaryCallSettings.Builder<GetKeyRequest, Key> getKeySettings() {
            return this.getKeySettings;
        }

        public UnaryCallSettings.Builder<UpdateKeyRequest, Key> updateKeySettings() {
            return this.updateKeySettings;
        }

        public UnaryCallSettings.Builder<DeleteKeyRequest, Empty> deleteKeySettings() {
            return this.deleteKeySettings;
        }

        public UnaryCallSettings.Builder<MigrateKeyRequest, Key> migrateKeySettings() {
            return this.migrateKeySettings;
        }

        public UnaryCallSettings.Builder<GetMetricsRequest, Metrics> getMetricsSettings() {
            return this.getMetricsSettings;
        }

        public UnaryCallSettings.Builder<CreateFirewallPolicyRequest, FirewallPolicy> createFirewallPolicySettings() {
            return this.createFirewallPolicySettings;
        }

        public PagedCallSettings.Builder<ListFirewallPoliciesRequest, ListFirewallPoliciesResponse, RecaptchaEnterpriseServiceClient.ListFirewallPoliciesPagedResponse> listFirewallPoliciesSettings() {
            return this.listFirewallPoliciesSettings;
        }

        public UnaryCallSettings.Builder<GetFirewallPolicyRequest, FirewallPolicy> getFirewallPolicySettings() {
            return this.getFirewallPolicySettings;
        }

        public UnaryCallSettings.Builder<UpdateFirewallPolicyRequest, FirewallPolicy> updateFirewallPolicySettings() {
            return this.updateFirewallPolicySettings;
        }

        public UnaryCallSettings.Builder<DeleteFirewallPolicyRequest, Empty> deleteFirewallPolicySettings() {
            return this.deleteFirewallPolicySettings;
        }

        public PagedCallSettings.Builder<ListRelatedAccountGroupsRequest, ListRelatedAccountGroupsResponse, RecaptchaEnterpriseServiceClient.ListRelatedAccountGroupsPagedResponse> listRelatedAccountGroupsSettings() {
            return this.listRelatedAccountGroupsSettings;
        }

        public PagedCallSettings.Builder<ListRelatedAccountGroupMembershipsRequest, ListRelatedAccountGroupMembershipsResponse, RecaptchaEnterpriseServiceClient.ListRelatedAccountGroupMembershipsPagedResponse> listRelatedAccountGroupMembershipsSettings() {
            return this.listRelatedAccountGroupMembershipsSettings;
        }

        public PagedCallSettings.Builder<SearchRelatedAccountGroupMembershipsRequest, SearchRelatedAccountGroupMembershipsResponse, RecaptchaEnterpriseServiceClient.SearchRelatedAccountGroupMembershipsPagedResponse> searchRelatedAccountGroupMembershipsSettings() {
            return this.searchRelatedAccountGroupMembershipsSettings;
        }

        public RecaptchaEnterpriseServiceStubSettings build() throws IOException {
            return new RecaptchaEnterpriseServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

