/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recaptchaenterprise.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseServiceClient;
import com.google.cloud.recaptchaenterprise.v1.stub.GrpcRecaptchaEnterpriseServiceStub;
import com.google.cloud.recaptchaenterprise.v1.stub.RecaptchaEnterpriseServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import com.google.recaptchaenterprise.v1.AnnotateAssessmentRequest;
import com.google.recaptchaenterprise.v1.AnnotateAssessmentResponse;
import com.google.recaptchaenterprise.v1.Assessment;
import com.google.recaptchaenterprise.v1.CreateAssessmentRequest;
import com.google.recaptchaenterprise.v1.CreateKeyRequest;
import com.google.recaptchaenterprise.v1.DeleteKeyRequest;
import com.google.recaptchaenterprise.v1.GetKeyRequest;
import com.google.recaptchaenterprise.v1.Key;
import com.google.recaptchaenterprise.v1.ListKeysRequest;
import com.google.recaptchaenterprise.v1.ListKeysResponse;
import com.google.recaptchaenterprise.v1.UpdateKeyRequest;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class RecaptchaEnterpriseServiceStubSettings
extends StubSettings<RecaptchaEnterpriseServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateAssessmentRequest, Assessment> createAssessmentSettings;
    private final UnaryCallSettings<AnnotateAssessmentRequest, AnnotateAssessmentResponse> annotateAssessmentSettings;
    private final UnaryCallSettings<CreateKeyRequest, Key> createKeySettings;
    private final PagedCallSettings<ListKeysRequest, ListKeysResponse, RecaptchaEnterpriseServiceClient.ListKeysPagedResponse> listKeysSettings;
    private final UnaryCallSettings<GetKeyRequest, Key> getKeySettings;
    private final UnaryCallSettings<UpdateKeyRequest, Key> updateKeySettings;
    private final UnaryCallSettings<DeleteKeyRequest, Empty> deleteKeySettings;
    private static final PagedListDescriptor<ListKeysRequest, ListKeysResponse, Key> LIST_KEYS_PAGE_STR_DESC = new PagedListDescriptor<ListKeysRequest, ListKeysResponse, Key>(){

        public String emptyToken() {
            return "";
        }

        public ListKeysRequest injectToken(ListKeysRequest payload, String token) {
            return ListKeysRequest.newBuilder((ListKeysRequest)payload).setPageToken(token).build();
        }

        public ListKeysRequest injectPageSize(ListKeysRequest payload, int pageSize) {
            return ListKeysRequest.newBuilder((ListKeysRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListKeysRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListKeysResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Key> extractResources(ListKeysResponse payload) {
            return payload.getKeysList() == null ? ImmutableList.of() : payload.getKeysList();
        }
    };
    private static final PagedListResponseFactory<ListKeysRequest, ListKeysResponse, RecaptchaEnterpriseServiceClient.ListKeysPagedResponse> LIST_KEYS_PAGE_STR_FACT = new PagedListResponseFactory<ListKeysRequest, ListKeysResponse, RecaptchaEnterpriseServiceClient.ListKeysPagedResponse>(){

        public ApiFuture<RecaptchaEnterpriseServiceClient.ListKeysPagedResponse> getFuturePagedResponse(UnaryCallable<ListKeysRequest, ListKeysResponse> callable, ListKeysRequest request, ApiCallContext context, ApiFuture<ListKeysResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_KEYS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RecaptchaEnterpriseServiceClient.ListKeysPagedResponse.createAsync((PageContext<ListKeysRequest, ListKeysResponse, Key>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateAssessmentRequest, Assessment> createAssessmentSettings() {
        return this.createAssessmentSettings;
    }

    public UnaryCallSettings<AnnotateAssessmentRequest, AnnotateAssessmentResponse> annotateAssessmentSettings() {
        return this.annotateAssessmentSettings;
    }

    public UnaryCallSettings<CreateKeyRequest, Key> createKeySettings() {
        return this.createKeySettings;
    }

    public PagedCallSettings<ListKeysRequest, ListKeysResponse, RecaptchaEnterpriseServiceClient.ListKeysPagedResponse> listKeysSettings() {
        return this.listKeysSettings;
    }

    public UnaryCallSettings<GetKeyRequest, Key> getKeySettings() {
        return this.getKeySettings;
    }

    public UnaryCallSettings<UpdateKeyRequest, Key> updateKeySettings() {
        return this.updateKeySettings;
    }

    public UnaryCallSettings<DeleteKeyRequest, Empty> deleteKeySettings() {
        return this.deleteKeySettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RecaptchaEnterpriseServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcRecaptchaEnterpriseServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "recaptchaenterprise.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "recaptchaenterprise.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RecaptchaEnterpriseServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RecaptchaEnterpriseServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RecaptchaEnterpriseServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createAssessmentSettings = settingsBuilder.createAssessmentSettings().build();
        this.annotateAssessmentSettings = settingsBuilder.annotateAssessmentSettings().build();
        this.createKeySettings = settingsBuilder.createKeySettings().build();
        this.listKeysSettings = settingsBuilder.listKeysSettings().build();
        this.getKeySettings = settingsBuilder.getKeySettings().build();
        this.updateKeySettings = settingsBuilder.updateKeySettings().build();
        this.deleteKeySettings = settingsBuilder.deleteKeySettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RecaptchaEnterpriseServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateAssessmentRequest, Assessment> createAssessmentSettings;
        private final UnaryCallSettings.Builder<AnnotateAssessmentRequest, AnnotateAssessmentResponse> annotateAssessmentSettings;
        private final UnaryCallSettings.Builder<CreateKeyRequest, Key> createKeySettings;
        private final PagedCallSettings.Builder<ListKeysRequest, ListKeysResponse, RecaptchaEnterpriseServiceClient.ListKeysPagedResponse> listKeysSettings;
        private final UnaryCallSettings.Builder<GetKeyRequest, Key> getKeySettings;
        private final UnaryCallSettings.Builder<UpdateKeyRequest, Key> updateKeySettings;
        private final UnaryCallSettings.Builder<DeleteKeyRequest, Empty> deleteKeySettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createAssessmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.annotateAssessmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listKeysSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_KEYS_PAGE_STR_FACT);
            this.getKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createAssessmentSettings, this.annotateAssessmentSettings, this.createKeySettings, this.listKeysSettings, this.getKeySettings, this.updateKeySettings, this.deleteKeySettings);
            Builder.initDefaults(this);
        }

        protected Builder(RecaptchaEnterpriseServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createAssessmentSettings = settings.createAssessmentSettings.toBuilder();
            this.annotateAssessmentSettings = settings.annotateAssessmentSettings.toBuilder();
            this.createKeySettings = settings.createKeySettings.toBuilder();
            this.listKeysSettings = settings.listKeysSettings.toBuilder();
            this.getKeySettings = settings.getKeySettings.toBuilder();
            this.updateKeySettings = settings.updateKeySettings.toBuilder();
            this.deleteKeySettings = settings.deleteKeySettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createAssessmentSettings, this.annotateAssessmentSettings, this.createKeySettings, this.listKeysSettings, this.getKeySettings, this.updateKeySettings, this.deleteKeySettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RecaptchaEnterpriseServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RecaptchaEnterpriseServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RecaptchaEnterpriseServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(RecaptchaEnterpriseServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(RecaptchaEnterpriseServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createAssessmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.annotateAssessmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listKeysSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateAssessmentRequest, Assessment> createAssessmentSettings() {
            return this.createAssessmentSettings;
        }

        public UnaryCallSettings.Builder<AnnotateAssessmentRequest, AnnotateAssessmentResponse> annotateAssessmentSettings() {
            return this.annotateAssessmentSettings;
        }

        public UnaryCallSettings.Builder<CreateKeyRequest, Key> createKeySettings() {
            return this.createKeySettings;
        }

        public PagedCallSettings.Builder<ListKeysRequest, ListKeysResponse, RecaptchaEnterpriseServiceClient.ListKeysPagedResponse> listKeysSettings() {
            return this.listKeysSettings;
        }

        public UnaryCallSettings.Builder<GetKeyRequest, Key> getKeySettings() {
            return this.getKeySettings;
        }

        public UnaryCallSettings.Builder<UpdateKeyRequest, Key> updateKeySettings() {
            return this.updateKeySettings;
        }

        public UnaryCallSettings.Builder<DeleteKeyRequest, Empty> deleteKeySettings() {
            return this.deleteKeySettings;
        }

        public RecaptchaEnterpriseServiceStubSettings build() throws IOException {
            return new RecaptchaEnterpriseServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

