/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.rpc.ApiException;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.Publisher;
import com.google.cloud.pubsublite.internal.wire.AutoValue_PublisherBuilder;
import com.google.cloud.pubsublite.internal.wire.PublisherImpl;
import com.google.cloud.pubsublite.internal.wire.StreamFactories;
import com.google.cloud.pubsublite.proto.InitialPublishRequest;
import com.google.common.base.Preconditions;

@AutoValue
public abstract class PublisherBuilder {
    public static final BatchingSettings DISABLED_BATCHING_SETTINGS = BatchingSettings.newBuilder().setElementCountThreshold(Long.valueOf(1L)).setRequestByteThreshold(Long.valueOf(1L)).setIsEnabled(Boolean.valueOf(true)).build();

    abstract TopicPath topic();

    abstract Partition partition();

    abstract BatchingSettings batching();

    abstract StreamFactories.PublishStreamFactory streamFactory();

    public static Builder builder() {
        return new AutoValue_PublisherBuilder.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setTopic(TopicPath var1);

        public abstract Builder setPartition(Partition var1);

        public abstract Builder setBatching(BatchingSettings var1);

        public abstract Builder setStreamFactory(StreamFactories.PublishStreamFactory var1);

        abstract PublisherBuilder autoBuild();

        public Publisher<Offset> build() throws ApiException {
            PublisherBuilder autoBuilt = this.autoBuild();
            return new PublisherImpl(autoBuilt.streamFactory(), InitialPublishRequest.newBuilder().setTopic(autoBuilt.topic().toString()).setPartition(autoBuilt.partition().value()).build(), Builder.validateBatchingSettings(autoBuilt.batching()));
        }

        static BatchingSettings validateBatchingSettings(BatchingSettings batching) {
            Preconditions.checkArgument((boolean)batching.getFlowControlSettings().getLimitExceededBehavior().equals((Object)FlowController.LimitExceededBehavior.Ignore), (Object)"Publisher does not accept flow control settings as the behavior would be non-obvious given a Publisher implementation. Use external flow control instead.");
            if (!batching.getIsEnabled().booleanValue()) {
                return DISABLED_BATCHING_SETTINGS;
            }
            Preconditions.checkNotNull((Object)batching.getElementCountThreshold());
            Preconditions.checkNotNull((Object)batching.getRequestByteThreshold());
            Preconditions.checkArgument((batching.getElementCountThreshold() <= 1000L ? 1 : 0) != 0, (Object)"Batching element count greater than max value.");
            Preconditions.checkArgument((batching.getRequestByteThreshold() <= 0x380000L ? 1 : 0) != 0, (Object)"Batching byte count greater than max value.");
            return batching;
        }
    }
}

