/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.internal.ApiResourceAggregation;
import com.google.cloud.pubsublite.internal.CursorClient;
import com.google.cloud.pubsublite.internal.wire.SystemExecutors;
import com.google.cloud.pubsublite.proto.CommitCursorRequest;
import com.google.cloud.pubsublite.proto.Cursor;
import com.google.cloud.pubsublite.proto.ListPartitionCursorsRequest;
import com.google.cloud.pubsublite.proto.PartitionCursor;
import com.google.cloud.pubsublite.v1.CursorServiceClient;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.Executor;

public class CursorClientImpl
extends ApiResourceAggregation
implements CursorClient {
    private final CloudRegion region;
    private final CursorServiceClient serviceClient;

    public CursorClientImpl(CloudRegion region, CursorServiceClient serviceClient) {
        super(serviceClient);
        this.region = region;
        this.serviceClient = serviceClient;
    }

    @Override
    public CloudRegion region() {
        return this.region;
    }

    @Override
    public ApiFuture<Map<Partition, Offset>> listPartitionCursors(SubscriptionPath path) {
        return ApiFutures.transform((ApiFuture)this.serviceClient.listPartitionCursorsCallable().futureCall((Object)ListPartitionCursorsRequest.newBuilder().setParent(path.toString()).build()), response -> {
            ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
            for (PartitionCursor partitionCursor : response.getPartitionCursorsList()) {
                resultBuilder.put((Object)Partition.of(partitionCursor.getPartition()), (Object)Offset.of(partitionCursor.getCursor().getOffset()));
            }
            return resultBuilder.build();
        }, (Executor)SystemExecutors.getFuturesExecutor());
    }

    @Override
    public ApiFuture<Void> commitCursor(SubscriptionPath path, Partition partition, Offset offset) {
        return ApiFutures.transform((ApiFuture)this.serviceClient.commitCursorCallable().futureCall((Object)CommitCursorRequest.newBuilder().setSubscription(path.toString()).setPartition(partition.value()).setCursor(Cursor.newBuilder().setOffset(offset.value())).build()), x -> null, (Executor)SystemExecutors.getFuturesExecutor());
    }
}

