/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.Message;
import com.google.cloud.pubsublite.MessageMetadata;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.internal.ProxyService;
import com.google.cloud.pubsublite.internal.Publisher;
import com.google.cloud.pubsublite.internal.wire.SystemExecutors;
import java.io.IOException;
import java.util.concurrent.Executor;

public class SinglePartitionPublisher
extends ProxyService
implements Publisher<MessageMetadata> {
    private final Publisher<Offset> publisher;
    private final Partition partition;

    SinglePartitionPublisher(Publisher<Offset> publisher, Partition partition) throws ApiException {
        super(publisher);
        this.publisher = publisher;
        this.partition = partition;
    }

    @Override
    public ApiFuture<MessageMetadata> publish(Message message) {
        return ApiFutures.transform(this.publisher.publish(message), offset -> MessageMetadata.of(this.partition, offset), (Executor)SystemExecutors.getFuturesExecutor());
    }

    @Override
    public void cancelOutstandingPublishes() {
        this.publisher.cancelOutstandingPublishes();
    }

    @Override
    public void flush() throws IOException {
        this.publisher.flush();
    }
}

