/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.gax.batching.BatchingSettings;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.wire.PublisherBuilder;
import com.google.cloud.pubsublite.v1.PublisherServiceClient;

final class AutoValue_PublisherBuilder
extends PublisherBuilder {
    private final TopicPath topic;
    private final Partition partition;
    private final BatchingSettings batching;
    private final PublisherServiceClient serviceClient;

    private AutoValue_PublisherBuilder(TopicPath topic, Partition partition, BatchingSettings batching, PublisherServiceClient serviceClient) {
        this.topic = topic;
        this.partition = partition;
        this.batching = batching;
        this.serviceClient = serviceClient;
    }

    @Override
    TopicPath topic() {
        return this.topic;
    }

    @Override
    Partition partition() {
        return this.partition;
    }

    @Override
    BatchingSettings batching() {
        return this.batching;
    }

    @Override
    PublisherServiceClient serviceClient() {
        return this.serviceClient;
    }

    public String toString() {
        return "PublisherBuilder{topic=" + this.topic + ", partition=" + this.partition + ", batching=" + this.batching + ", serviceClient=" + this.serviceClient + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PublisherBuilder) {
            PublisherBuilder that = (PublisherBuilder)o;
            return this.topic.equals(that.topic()) && this.partition.equals(that.partition()) && this.batching.equals(that.batching()) && this.serviceClient.equals(that.serviceClient());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.topic.hashCode();
        h$ *= 1000003;
        h$ ^= this.partition.hashCode();
        h$ *= 1000003;
        h$ ^= this.batching.hashCode();
        h$ *= 1000003;
        return h$ ^= this.serviceClient.hashCode();
    }

    static final class Builder
    extends PublisherBuilder.Builder {
        private TopicPath topic;
        private Partition partition;
        private BatchingSettings batching;
        private PublisherServiceClient serviceClient;

        Builder() {
        }

        @Override
        public PublisherBuilder.Builder setTopic(TopicPath topic) {
            if (topic == null) {
                throw new NullPointerException("Null topic");
            }
            this.topic = topic;
            return this;
        }

        @Override
        public PublisherBuilder.Builder setPartition(Partition partition) {
            if (partition == null) {
                throw new NullPointerException("Null partition");
            }
            this.partition = partition;
            return this;
        }

        @Override
        public PublisherBuilder.Builder setBatching(BatchingSettings batching) {
            if (batching == null) {
                throw new NullPointerException("Null batching");
            }
            this.batching = batching;
            return this;
        }

        @Override
        public PublisherBuilder.Builder setServiceClient(PublisherServiceClient serviceClient) {
            if (serviceClient == null) {
                throw new NullPointerException("Null serviceClient");
            }
            this.serviceClient = serviceClient;
            return this;
        }

        @Override
        PublisherBuilder autoBuild() {
            if (this.topic == null || this.partition == null || this.batching == null || this.serviceClient == null) {
                StringBuilder missing = new StringBuilder();
                if (this.topic == null) {
                    missing.append(" topic");
                }
                if (this.partition == null) {
                    missing.append(" partition");
                }
                if (this.batching == null) {
                    missing.append(" batching");
                }
                if (this.serviceClient == null) {
                    missing.append(" serviceClient");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_PublisherBuilder(this.topic, this.partition, this.batching, this.serviceClient);
        }
    }
}

