/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.core.ApiService;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.CloseableMonitor;
import com.google.cloud.pubsublite.internal.ProxyService;
import com.google.cloud.pubsublite.internal.wire.ApiServiceUtils;
import com.google.cloud.pubsublite.internal.wire.Assigner;
import com.google.cloud.pubsublite.internal.wire.ConnectedAssigner;
import com.google.cloud.pubsublite.internal.wire.ConnectedAssignerFactory;
import com.google.cloud.pubsublite.internal.wire.ConnectedAssignerImpl;
import com.google.cloud.pubsublite.internal.wire.PartitionAssignmentReceiver;
import com.google.cloud.pubsublite.internal.wire.RetryingConnection;
import com.google.cloud.pubsublite.internal.wire.RetryingConnectionImpl;
import com.google.cloud.pubsublite.internal.wire.RetryingConnectionObserver;
import com.google.cloud.pubsublite.internal.wire.StreamFactory;
import com.google.cloud.pubsublite.proto.InitialPartitionAssignmentRequest;
import com.google.cloud.pubsublite.proto.PartitionAssignment;
import com.google.cloud.pubsublite.proto.PartitionAssignmentRequest;
import com.google.cloud.pubsublite.v1.PartitionAssignmentServiceClient;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.flogger.GoogleLogger;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class AssignerImpl
extends ProxyService
implements Assigner,
RetryingConnectionObserver<PartitionAssignment> {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final PartitionAssignmentRequest initialRequest;
    private final CloseableMonitor monitor = new CloseableMonitor();
    @GuardedBy(value="monitor.monitor")
    private final RetryingConnection<PartitionAssignmentRequest, ConnectedAssigner> connection;
    @GuardedBy(value="monitor.monitor")
    private final PartitionAssignmentReceiver receiver;

    @VisibleForTesting
    AssignerImpl(StreamFactory<PartitionAssignmentRequest, PartitionAssignment> streamFactory, ConnectedAssignerFactory factory, InitialPartitionAssignmentRequest initialRequest, PartitionAssignmentReceiver receiver) throws ApiException {
        super(new ApiService[0]);
        this.initialRequest = PartitionAssignmentRequest.newBuilder().setInitial(initialRequest).build();
        this.receiver = receiver;
        this.connection = new RetryingConnectionImpl<PartitionAssignmentRequest, PartitionAssignment, PartitionAssignment, ConnectedAssigner>(streamFactory, factory, this, this.initialRequest);
        this.addServices(this.connection);
    }

    public AssignerImpl(PartitionAssignmentServiceClient client, InitialPartitionAssignmentRequest initialRequest, PartitionAssignmentReceiver receiver) throws ApiException {
        this((ResponseObserver<PartitionAssignment> stream) -> client.assignPartitionsCallable().splitCall(stream), new ConnectedAssignerImpl.Factory(), initialRequest, receiver);
        this.addServices(ApiServiceUtils.autoCloseableAsApiService((AutoCloseable)((Object)client)));
    }

    @Override
    public void triggerReinitialize(CheckedApiException streamError) {
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            this.connection.reinitialize(this.initialRequest);
        }
    }

    private static Set<Partition> toSet(PartitionAssignment assignment) throws ApiException {
        HashSet<Partition> partitions = new HashSet<Partition>();
        Iterator iterator = assignment.getPartitionsList().iterator();
        while (iterator.hasNext()) {
            long partition = (Long)iterator.next();
            partitions.add(Partition.of(partition));
        }
        return partitions;
    }

    @Override
    public void onClientResponse(PartitionAssignment value) throws CheckedApiException {
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            Set<Partition> partitions = AssignerImpl.toSet(value);
            this.receiver.handleAssignment(partitions);
            ((GoogleLogger.Api)logger.atInfo()).log("Subscribed to partitions: %s", partitions);
            this.connection.modifyConnection(connectionOr -> connectionOr.ifPresent(ConnectedAssigner::ack));
        }
    }
}

