/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.cloud.pubsublite.proto.PublishRequest;
import com.google.cloud.pubsublite.proto.PublishResponse;
import com.google.cloud.pubsublite.v1.stub.GrpcPublisherServiceCallableFactory;
import com.google.cloud.pubsublite.v1.stub.PublisherServiceStub;
import com.google.cloud.pubsublite.v1.stub.PublisherServiceStubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcPublisherServiceStub
extends PublisherServiceStub {
    private static final MethodDescriptor<PublishRequest, PublishResponse> publishMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName("google.cloud.pubsublite.v1.PublisherService/Publish").setRequestMarshaller(ProtoUtils.marshaller((Message)PublishRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)PublishResponse.getDefaultInstance())).build();
    private final BidiStreamingCallable<PublishRequest, PublishResponse> publishCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcPublisherServiceStub create(PublisherServiceStubSettings settings) throws IOException {
        return new GrpcPublisherServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcPublisherServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcPublisherServiceStub(PublisherServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcPublisherServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcPublisherServiceStub(PublisherServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcPublisherServiceStub(PublisherServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcPublisherServiceCallableFactory());
    }

    protected GrpcPublisherServiceStub(PublisherServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings publishTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(publishMethodDescriptor).build();
        this.publishCallable = callableFactory.createBidiStreamingCallable(publishTransportSettings, settings.publishSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public BidiStreamingCallable<PublishRequest, PublishResponse> publishCallable() {
        return this.publishCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

