/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.cloudpubsub;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.cloud.pubsublite.MessageTransformer;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SequencedMessage;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.cloudpubsub.AutoValue_SubscriberSettings;
import com.google.cloud.pubsublite.cloudpubsub.FlowControlSettings;
import com.google.cloud.pubsublite.cloudpubsub.MessageTransforms;
import com.google.cloud.pubsublite.cloudpubsub.NackHandler;
import com.google.cloud.pubsublite.cloudpubsub.ReassignmentHandler;
import com.google.cloud.pubsublite.cloudpubsub.Subscriber;
import com.google.cloud.pubsublite.cloudpubsub.internal.AckSetTrackerImpl;
import com.google.cloud.pubsublite.cloudpubsub.internal.AssigningSubscriber;
import com.google.cloud.pubsublite.cloudpubsub.internal.MultiPartitionSubscriber;
import com.google.cloud.pubsublite.cloudpubsub.internal.PartitionSubscriberFactory;
import com.google.cloud.pubsublite.cloudpubsub.internal.SinglePartitionSubscriber;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.wire.AssignerFactory;
import com.google.cloud.pubsublite.internal.wire.AssignerSettings;
import com.google.cloud.pubsublite.internal.wire.Committer;
import com.google.cloud.pubsublite.internal.wire.CommitterSettings;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.RoutingMetadata;
import com.google.cloud.pubsublite.internal.wire.ServiceClients;
import com.google.cloud.pubsublite.internal.wire.SubscriberBuilder;
import com.google.cloud.pubsublite.proto.SeekRequest;
import com.google.cloud.pubsublite.v1.CursorServiceClient;
import com.google.cloud.pubsublite.v1.CursorServiceSettings;
import com.google.cloud.pubsublite.v1.PartitionAssignmentServiceClient;
import com.google.cloud.pubsublite.v1.PartitionAssignmentServiceSettings;
import com.google.cloud.pubsublite.v1.SubscriberServiceClient;
import com.google.cloud.pubsublite.v1.SubscriberServiceSettings;
import com.google.common.collect.ImmutableList;
import com.google.pubsub.v1.PubsubMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

@AutoValue
public abstract class SubscriberSettings {
    abstract MessageReceiver receiver();

    abstract SubscriptionPath subscriptionPath();

    abstract FlowControlSettings perPartitionFlowControlSettings();

    abstract List<Partition> partitions();

    abstract Optional<MessageTransformer<SequencedMessage, PubsubMessage>> transformer();

    abstract CredentialsProvider credentialsProvider();

    abstract PubsubContext.Framework framework();

    abstract Optional<Supplier<SubscriberServiceClient>> subscriberServiceClientSupplier();

    abstract Optional<Supplier<CursorServiceClient>> cursorServiceClientSupplier();

    abstract Optional<PartitionAssignmentServiceClient> assignmentServiceClient();

    abstract Optional<NackHandler> nackHandler();

    abstract ReassignmentHandler reassignmentHandler();

    public static Builder newBuilder() {
        return new AutoValue_SubscriberSettings.Builder().setFramework(PubsubContext.Framework.of("CLOUD_PUBSUB_SHIM")).setPartitions((List<Partition>)ImmutableList.of()).setCredentialsProvider((CredentialsProvider)SubscriberServiceSettings.defaultCredentialsProviderBuilder().build()).setReassignmentHandler((before, after) -> {});
    }

    private SubscriberServiceClient newSubscriberServiceClient(Partition partition) throws ApiException {
        if (this.subscriberServiceClientSupplier().isPresent()) {
            return this.subscriberServiceClientSupplier().get().get();
        }
        try {
            SubscriberServiceSettings.Builder settingsBuilder = (SubscriberServiceSettings.Builder)SubscriberServiceSettings.newBuilder().setCredentialsProvider(this.credentialsProvider());
            settingsBuilder = ServiceClients.addDefaultMetadata(PubsubContext.of(this.framework()), RoutingMetadata.of(this.subscriptionPath(), partition), settingsBuilder);
            return SubscriberServiceClient.create((SubscriberServiceSettings)((Object)ServiceClients.addDefaultSettings(this.subscriptionPath().location().extractRegion(), settingsBuilder)));
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    private CursorServiceClient newCursorServiceClient() throws ApiException {
        if (this.cursorServiceClientSupplier().isPresent()) {
            return this.cursorServiceClientSupplier().get().get();
        }
        try {
            return CursorServiceClient.create((CursorServiceSettings)((Object)ServiceClients.addDefaultSettings(this.subscriptionPath().location().extractRegion(), CursorServiceSettings.newBuilder().setCredentialsProvider(this.credentialsProvider()))));
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    Subscriber newPartitionSubscriber(Partition partition) throws CheckedApiException {
        try {
            SubscriberBuilder.Builder wireSubscriberBuilder = SubscriberBuilder.newBuilder().setPartition(partition).setSubscriptionPath(this.subscriptionPath()).setServiceClient(this.newSubscriberServiceClient(partition)).setInitialLocation(SeekRequest.newBuilder().setNamedTarget(SeekRequest.NamedTarget.COMMITTED_CURSOR).build());
            Committer wireCommitter = CommitterSettings.newBuilder().setSubscriptionPath(this.subscriptionPath()).setPartition(partition).setServiceClient(this.newCursorServiceClient()).build().instantiate();
            return new SinglePartitionSubscriber(this.receiver(), MessageTransforms.addIdCpsSubscribeTransformer(partition, this.transformer().orElse(MessageTransforms.toCpsSubscribeTransformer())), new AckSetTrackerImpl(wireCommitter), this.nackHandler().orElse(new NackHandler(){}), (messageConsumer, resetHandler) -> wireSubscriberBuilder.setMessageConsumer(messageConsumer).setResetHandler(resetHandler).build(), this.perPartitionFlowControlSettings());
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical(t);
        }
    }

    private PartitionAssignmentServiceClient getAssignmentServiceClient() throws ApiException {
        if (this.assignmentServiceClient().isPresent()) {
            return this.assignmentServiceClient().get();
        }
        try {
            return PartitionAssignmentServiceClient.create((PartitionAssignmentServiceSettings)((Object)ServiceClients.addDefaultSettings(this.subscriptionPath().location().extractRegion(), PartitionAssignmentServiceSettings.newBuilder().setCredentialsProvider(this.credentialsProvider()))));
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    Subscriber instantiate() throws ApiException {
        PartitionSubscriberFactory partitionSubscriberFactory = this::newPartitionSubscriber;
        if (this.partitions().isEmpty()) {
            AssignerSettings.Builder assignerSettings = AssignerSettings.newBuilder().setSubscriptionPath(this.subscriptionPath()).setServiceClient(this.getAssignmentServiceClient());
            AssignerFactory assignerFactory = receiver -> assignerSettings.setReceiver(receiver).build().instantiate();
            return new AssigningSubscriber(partitionSubscriberFactory, this.reassignmentHandler(), assignerFactory);
        }
        ArrayList<Subscriber> perPartitionSubscribers = new ArrayList<Subscriber>();
        for (Partition partition : this.partitions()) {
            try {
                perPartitionSubscribers.add(partitionSubscriberFactory.newSubscriber(partition));
            }
            catch (CheckedApiException e) {
                throw e.underlying;
            }
        }
        return MultiPartitionSubscriber.of(perPartitionSubscribers);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setReceiver(MessageReceiver var1);

        public abstract Builder setSubscriptionPath(SubscriptionPath var1);

        public abstract Builder setPerPartitionFlowControlSettings(FlowControlSettings var1);

        public abstract Builder setPartitions(List<Partition> var1);

        public abstract Builder setTransformer(MessageTransformer<SequencedMessage, PubsubMessage> var1);

        public abstract Builder setCredentialsProvider(CredentialsProvider var1);

        public abstract Builder setFramework(PubsubContext.Framework var1);

        public abstract Builder setSubscriberServiceClientSupplier(Supplier<SubscriberServiceClient> var1);

        public abstract Builder setCursorServiceClientSupplier(Supplier<CursorServiceClient> var1);

        public abstract Builder setAssignmentServiceClient(PartitionAssignmentServiceClient var1);

        public abstract Builder setNackHandler(NackHandler var1);

        public abstract Builder setReassignmentHandler(ReassignmentHandler var1);

        public abstract SubscriberSettings build();
    }
}

