/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.cloudpubsub;

import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.core.CredentialsProvider;
import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.Message;
import com.google.cloud.pubsublite.MessageTransformer;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.cloudpubsub.KeyExtractor;
import com.google.cloud.pubsublite.cloudpubsub.PublisherSettings;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.SinglePartitionPublisherBuilder;
import com.google.cloud.pubsublite.v1.PublisherServiceClient;
import com.google.pubsub.v1.PubsubMessage;
import java.util.Optional;
import java.util.function.Supplier;

final class AutoValue_PublisherSettings
extends PublisherSettings {
    private final TopicPath topicPath;
    private final Optional<KeyExtractor> keyExtractor;
    private final Optional<MessageTransformer<PubsubMessage, Message>> messageTransformer;
    private final Optional<BatchingSettings> batchingSettings;
    private final CredentialsProvider credentialsProvider;
    private final PubsubContext.Framework framework;
    private final Optional<Supplier<PublisherServiceClient>> serviceClientSupplier;
    private final Optional<AdminClient> adminClient;
    private final SinglePartitionPublisherBuilder.Builder underlyingBuilder;

    private AutoValue_PublisherSettings(TopicPath topicPath, Optional<KeyExtractor> keyExtractor, Optional<MessageTransformer<PubsubMessage, Message>> messageTransformer, Optional<BatchingSettings> batchingSettings, CredentialsProvider credentialsProvider, PubsubContext.Framework framework, Optional<Supplier<PublisherServiceClient>> serviceClientSupplier, Optional<AdminClient> adminClient, SinglePartitionPublisherBuilder.Builder underlyingBuilder) {
        this.topicPath = topicPath;
        this.keyExtractor = keyExtractor;
        this.messageTransformer = messageTransformer;
        this.batchingSettings = batchingSettings;
        this.credentialsProvider = credentialsProvider;
        this.framework = framework;
        this.serviceClientSupplier = serviceClientSupplier;
        this.adminClient = adminClient;
        this.underlyingBuilder = underlyingBuilder;
    }

    @Override
    TopicPath topicPath() {
        return this.topicPath;
    }

    @Override
    Optional<KeyExtractor> keyExtractor() {
        return this.keyExtractor;
    }

    @Override
    Optional<MessageTransformer<PubsubMessage, Message>> messageTransformer() {
        return this.messageTransformer;
    }

    @Override
    Optional<BatchingSettings> batchingSettings() {
        return this.batchingSettings;
    }

    @Override
    CredentialsProvider credentialsProvider() {
        return this.credentialsProvider;
    }

    @Override
    PubsubContext.Framework framework() {
        return this.framework;
    }

    @Override
    Optional<Supplier<PublisherServiceClient>> serviceClientSupplier() {
        return this.serviceClientSupplier;
    }

    @Override
    Optional<AdminClient> adminClient() {
        return this.adminClient;
    }

    @Override
    SinglePartitionPublisherBuilder.Builder underlyingBuilder() {
        return this.underlyingBuilder;
    }

    public String toString() {
        return "PublisherSettings{topicPath=" + this.topicPath + ", keyExtractor=" + this.keyExtractor + ", messageTransformer=" + this.messageTransformer + ", batchingSettings=" + this.batchingSettings + ", credentialsProvider=" + this.credentialsProvider + ", framework=" + this.framework + ", serviceClientSupplier=" + this.serviceClientSupplier + ", adminClient=" + this.adminClient + ", underlyingBuilder=" + this.underlyingBuilder + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PublisherSettings) {
            PublisherSettings that = (PublisherSettings)o;
            return this.topicPath.equals(that.topicPath()) && this.keyExtractor.equals(that.keyExtractor()) && this.messageTransformer.equals(that.messageTransformer()) && this.batchingSettings.equals(that.batchingSettings()) && this.credentialsProvider.equals(that.credentialsProvider()) && this.framework.equals(that.framework()) && this.serviceClientSupplier.equals(that.serviceClientSupplier()) && this.adminClient.equals(that.adminClient()) && this.underlyingBuilder.equals(that.underlyingBuilder());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.topicPath.hashCode();
        h$ *= 1000003;
        h$ ^= this.keyExtractor.hashCode();
        h$ *= 1000003;
        h$ ^= this.messageTransformer.hashCode();
        h$ *= 1000003;
        h$ ^= this.batchingSettings.hashCode();
        h$ *= 1000003;
        h$ ^= this.credentialsProvider.hashCode();
        h$ *= 1000003;
        h$ ^= this.framework.hashCode();
        h$ *= 1000003;
        h$ ^= this.serviceClientSupplier.hashCode();
        h$ *= 1000003;
        h$ ^= this.adminClient.hashCode();
        h$ *= 1000003;
        return h$ ^= this.underlyingBuilder.hashCode();
    }

    static final class Builder
    extends PublisherSettings.Builder {
        private TopicPath topicPath;
        private Optional<KeyExtractor> keyExtractor = Optional.empty();
        private Optional<MessageTransformer<PubsubMessage, Message>> messageTransformer = Optional.empty();
        private Optional<BatchingSettings> batchingSettings = Optional.empty();
        private CredentialsProvider credentialsProvider;
        private PubsubContext.Framework framework;
        private Optional<Supplier<PublisherServiceClient>> serviceClientSupplier = Optional.empty();
        private Optional<AdminClient> adminClient = Optional.empty();
        private SinglePartitionPublisherBuilder.Builder underlyingBuilder;

        Builder() {
        }

        @Override
        public PublisherSettings.Builder setTopicPath(TopicPath topicPath) {
            if (topicPath == null) {
                throw new NullPointerException("Null topicPath");
            }
            this.topicPath = topicPath;
            return this;
        }

        @Override
        public PublisherSettings.Builder setKeyExtractor(KeyExtractor keyExtractor) {
            this.keyExtractor = Optional.of(keyExtractor);
            return this;
        }

        @Override
        public PublisherSettings.Builder setMessageTransformer(MessageTransformer<PubsubMessage, Message> messageTransformer) {
            this.messageTransformer = Optional.of(messageTransformer);
            return this;
        }

        @Override
        public PublisherSettings.Builder setBatchingSettings(BatchingSettings batchingSettings) {
            this.batchingSettings = Optional.of(batchingSettings);
            return this;
        }

        @Override
        public PublisherSettings.Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            if (credentialsProvider == null) {
                throw new NullPointerException("Null credentialsProvider");
            }
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        @Override
        public PublisherSettings.Builder setFramework(PubsubContext.Framework framework) {
            if (framework == null) {
                throw new NullPointerException("Null framework");
            }
            this.framework = framework;
            return this;
        }

        @Override
        public PublisherSettings.Builder setServiceClientSupplier(Supplier<PublisherServiceClient> serviceClientSupplier) {
            this.serviceClientSupplier = Optional.of(serviceClientSupplier);
            return this;
        }

        @Override
        public PublisherSettings.Builder setAdminClient(AdminClient adminClient) {
            this.adminClient = Optional.of(adminClient);
            return this;
        }

        @Override
        PublisherSettings.Builder setUnderlyingBuilder(SinglePartitionPublisherBuilder.Builder underlyingBuilder) {
            if (underlyingBuilder == null) {
                throw new NullPointerException("Null underlyingBuilder");
            }
            this.underlyingBuilder = underlyingBuilder;
            return this;
        }

        @Override
        public PublisherSettings build() {
            if (this.topicPath == null || this.credentialsProvider == null || this.framework == null || this.underlyingBuilder == null) {
                StringBuilder missing = new StringBuilder();
                if (this.topicPath == null) {
                    missing.append(" topicPath");
                }
                if (this.credentialsProvider == null) {
                    missing.append(" credentialsProvider");
                }
                if (this.framework == null) {
                    missing.append(" framework");
                }
                if (this.underlyingBuilder == null) {
                    missing.append(" underlyingBuilder");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_PublisherSettings(this.topicPath, this.keyExtractor, this.messageTransformer, this.batchingSettings, this.credentialsProvider, this.framework, this.serviceClientSupplier, this.adminClient, this.underlyingBuilder);
        }
    }
}

