/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite;

import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.AutoValue_CloudZone;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import java.io.Serializable;

@AutoValue
public abstract class CloudZone
implements Serializable {
    private static final long serialVersionUID = 867184651465L;

    public static CloudZone of(CloudRegion region, char zoneId) {
        return new AutoValue_CloudZone(region, zoneId);
    }

    public static CloudZone parse(String zone) throws ApiException {
        String[] splits = zone.split("-", -1);
        if (splits.length != 3) {
            throw new CheckedApiException((String)new StringBuilder().append((String)"Invalid zone name: ").append((String)zone).toString(), (StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT).underlying;
        }
        if (splits[2].length() != 1) {
            throw new CheckedApiException((String)new StringBuilder().append((String)"Invalid zone name: ").append((String)zone).toString(), (StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT).underlying;
        }
        CloudRegion region = CloudRegion.of(splits[0] + "-" + splits[1]);
        return CloudZone.of(region, splits[2].charAt(0));
    }

    public abstract CloudRegion region();

    public abstract char zoneId();

    public final String toString() {
        return String.format("%s-%c", this.region().value(), Character.valueOf(this.zoneId()));
    }
}

