/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal;

import com.google.api.gax.rpc.ApiException;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.internal.AutoValue_CursorClientSettings;
import com.google.cloud.pubsublite.internal.CursorClient;
import com.google.cloud.pubsublite.internal.CursorClientImpl;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.wire.ServiceClients;
import com.google.cloud.pubsublite.v1.CursorServiceClient;
import com.google.cloud.pubsublite.v1.CursorServiceSettings;
import java.util.Optional;

@AutoValue
public abstract class CursorClientSettings {
    abstract CloudRegion region();

    abstract Optional<CursorServiceClient> serviceClient();

    public static Builder newBuilder() {
        return new AutoValue_CursorClientSettings.Builder();
    }

    CursorClient instantiate() throws ApiException {
        CursorServiceClient serviceClient;
        if (this.serviceClient().isPresent()) {
            serviceClient = this.serviceClient().get();
        } else {
            try {
                serviceClient = CursorServiceClient.create((CursorServiceSettings)((Object)ServiceClients.addDefaultSettings(this.region(), CursorServiceSettings.newBuilder())));
            }
            catch (Throwable t) {
                throw ExtractStatus.toCanonical((Throwable)t).underlying;
            }
        }
        return new CursorClientImpl(this.region(), serviceClient);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setRegion(CloudRegion var1);

        public abstract Builder setServiceClient(CursorServiceClient var1);

        public abstract CursorClientSettings build();
    }
}

