package com.google.cloud.pubsublite.internal.wire;

import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SubscriptionPath;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_CommitterSettings extends CommitterSettings {

  private final SubscriptionPath subscriptionPath;

  private final Partition partition;

  private final StreamFactories.CursorStreamFactory streamFactory;

  private AutoValue_CommitterSettings(
      SubscriptionPath subscriptionPath,
      Partition partition,
      StreamFactories.CursorStreamFactory streamFactory) {
    this.subscriptionPath = subscriptionPath;
    this.partition = partition;
    this.streamFactory = streamFactory;
  }

  @Override
  SubscriptionPath subscriptionPath() {
    return subscriptionPath;
  }

  @Override
  Partition partition() {
    return partition;
  }

  @Override
  StreamFactories.CursorStreamFactory streamFactory() {
    return streamFactory;
  }

  @Override
  public String toString() {
    return "CommitterSettings{"
        + "subscriptionPath=" + subscriptionPath + ", "
        + "partition=" + partition + ", "
        + "streamFactory=" + streamFactory
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof CommitterSettings) {
      CommitterSettings that = (CommitterSettings) o;
      return this.subscriptionPath.equals(that.subscriptionPath())
          && this.partition.equals(that.partition())
          && this.streamFactory.equals(that.streamFactory());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= subscriptionPath.hashCode();
    h$ *= 1000003;
    h$ ^= partition.hashCode();
    h$ *= 1000003;
    h$ ^= streamFactory.hashCode();
    return h$;
  }

  static final class Builder extends CommitterSettings.Builder {
    private SubscriptionPath subscriptionPath;
    private Partition partition;
    private StreamFactories.CursorStreamFactory streamFactory;
    Builder() {
    }
    @Override
    public CommitterSettings.Builder setSubscriptionPath(SubscriptionPath subscriptionPath) {
      if (subscriptionPath == null) {
        throw new NullPointerException("Null subscriptionPath");
      }
      this.subscriptionPath = subscriptionPath;
      return this;
    }
    @Override
    public CommitterSettings.Builder setPartition(Partition partition) {
      if (partition == null) {
        throw new NullPointerException("Null partition");
      }
      this.partition = partition;
      return this;
    }
    @Override
    public CommitterSettings.Builder setStreamFactory(StreamFactories.CursorStreamFactory streamFactory) {
      if (streamFactory == null) {
        throw new NullPointerException("Null streamFactory");
      }
      this.streamFactory = streamFactory;
      return this;
    }
    @Override
    public CommitterSettings build() {
      if (this.subscriptionPath == null
          || this.partition == null
          || this.streamFactory == null) {
        StringBuilder missing = new StringBuilder();
        if (this.subscriptionPath == null) {
          missing.append(" subscriptionPath");
        }
        if (this.partition == null) {
          missing.append(" partition");
        }
        if (this.streamFactory == null) {
          missing.append(" streamFactory");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_CommitterSettings(
          this.subscriptionPath,
          this.partition,
          this.streamFactory);
    }
  }

}
