package com.google.cloud.pubsublite;

import com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.pubsublite.v1.AdminServiceClient;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_AdminClientSettings extends AdminClientSettings {

  private final CloudRegion region;

  private final Optional<RetrySettings> retrySettings;

  private final Optional<AdminServiceClient> serviceClient;

  private AutoValue_AdminClientSettings(
      CloudRegion region,
      Optional<RetrySettings> retrySettings,
      Optional<AdminServiceClient> serviceClient) {
    this.region = region;
    this.retrySettings = retrySettings;
    this.serviceClient = serviceClient;
  }

  @Override
  CloudRegion region() {
    return region;
  }

  @Override
  Optional<RetrySettings> retrySettings() {
    return retrySettings;
  }

  @Override
  Optional<AdminServiceClient> serviceClient() {
    return serviceClient;
  }

  @Override
  public String toString() {
    return "AdminClientSettings{"
        + "region=" + region + ", "
        + "retrySettings=" + retrySettings + ", "
        + "serviceClient=" + serviceClient
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AdminClientSettings) {
      AdminClientSettings that = (AdminClientSettings) o;
      return this.region.equals(that.region())
          && this.retrySettings.equals(that.retrySettings())
          && this.serviceClient.equals(that.serviceClient());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= region.hashCode();
    h$ *= 1000003;
    h$ ^= retrySettings.hashCode();
    h$ *= 1000003;
    h$ ^= serviceClient.hashCode();
    return h$;
  }

  static final class Builder extends AdminClientSettings.Builder {
    private CloudRegion region;
    private Optional<RetrySettings> retrySettings = Optional.empty();
    private Optional<AdminServiceClient> serviceClient = Optional.empty();
    Builder() {
    }
    @Override
    public AdminClientSettings.Builder setRegion(CloudRegion region) {
      if (region == null) {
        throw new NullPointerException("Null region");
      }
      this.region = region;
      return this;
    }
    @Override
    public AdminClientSettings.Builder setRetrySettings(RetrySettings retrySettings) {
      this.retrySettings = Optional.of(retrySettings);
      return this;
    }
    @Override
    public AdminClientSettings.Builder setServiceClient(AdminServiceClient serviceClient) {
      this.serviceClient = Optional.of(serviceClient);
      return this;
    }
    @Override
    public AdminClientSettings build() {
      if (this.region == null) {
        String missing = " region";
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_AdminClientSettings(
          this.region,
          this.retrySettings,
          this.serviceClient);
    }
  }

}
