package com.google.cloud.pubsublite;

import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_SubscriptionPath extends SubscriptionPath {

  private final ProjectIdOrNumber project;

  private final CloudRegionOrZone location;

  private final SubscriptionName name;

  private AutoValue_SubscriptionPath(
      ProjectIdOrNumber project,
      CloudRegionOrZone location,
      SubscriptionName name) {
    this.project = project;
    this.location = location;
    this.name = name;
  }

  @Override
  public ProjectIdOrNumber project() {
    return project;
  }

  @Override
  public CloudRegionOrZone location() {
    return location;
  }

  @Override
  public SubscriptionName name() {
    return name;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SubscriptionPath) {
      SubscriptionPath that = (SubscriptionPath) o;
      return this.project.equals(that.project())
          && this.location.equals(that.location())
          && this.name.equals(that.name());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= project.hashCode();
    h$ *= 1000003;
    h$ ^= location.hashCode();
    h$ *= 1000003;
    h$ ^= name.hashCode();
    return h$;
  }

  @Override
  public SubscriptionPath.Builder toBuilder() {
    return new AutoValue_SubscriptionPath.Builder(this);
  }

  static final class Builder extends SubscriptionPath.Builder {
    private ProjectIdOrNumber project;
    private CloudRegionOrZone location;
    private SubscriptionName name;
    Builder() {
    }
    Builder(SubscriptionPath source) {
      this.project = source.project();
      this.location = source.location();
      this.name = source.name();
    }
    @Override
    public SubscriptionPath.Builder setProject(ProjectIdOrNumber project) {
      if (project == null) {
        throw new NullPointerException("Null project");
      }
      this.project = project;
      return this;
    }
    @Override
    public SubscriptionPath.Builder setLocation(CloudRegionOrZone location) {
      if (location == null) {
        throw new NullPointerException("Null location");
      }
      this.location = location;
      return this;
    }
    @Override
    public SubscriptionPath.Builder setName(SubscriptionName name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public SubscriptionPath build() {
      if (this.project == null
          || this.location == null
          || this.name == null) {
        StringBuilder missing = new StringBuilder();
        if (this.project == null) {
          missing.append(" project");
        }
        if (this.location == null) {
          missing.append(" location");
        }
        if (this.name == null) {
          missing.append(" name");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_SubscriptionPath(
          this.project,
          this.location,
          this.name);
    }
  }

}
