/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.gax.rpc.ResponseObserver;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.CheckedApiPreconditions;
import com.google.cloud.pubsublite.internal.wire.ConnectedCommitter;
import com.google.cloud.pubsublite.internal.wire.ConnectedCommitterFactory;
import com.google.cloud.pubsublite.internal.wire.SingleConnection;
import com.google.cloud.pubsublite.internal.wire.StreamFactory;
import com.google.cloud.pubsublite.proto.Cursor;
import com.google.cloud.pubsublite.proto.SequencedCommitCursorRequest;
import com.google.cloud.pubsublite.proto.SequencedCommitCursorResponse;
import com.google.cloud.pubsublite.proto.StreamingCommitCursorRequest;
import com.google.cloud.pubsublite.proto.StreamingCommitCursorResponse;
import com.google.common.annotations.VisibleForTesting;
import java.time.Duration;

public class ConnectedCommitterImpl
extends SingleConnection<StreamingCommitCursorRequest, StreamingCommitCursorResponse, SequencedCommitCursorResponse>
implements ConnectedCommitter {
    private final StreamingCommitCursorRequest initialRequest;

    @VisibleForTesting
    ConnectedCommitterImpl(StreamFactory<StreamingCommitCursorRequest, StreamingCommitCursorResponse> streamFactory, ResponseObserver<SequencedCommitCursorResponse> clientStream, StreamingCommitCursorRequest initialRequest, Duration streamIdleTimeout) {
        super(streamFactory, clientStream, streamIdleTimeout, true);
        this.initialRequest = initialRequest;
        this.initialize(initialRequest);
    }

    @Override
    protected void handleInitialResponse(StreamingCommitCursorResponse response) throws CheckedApiException {
        CheckedApiPreconditions.checkState(response.hasInitial(), String.format("Received non-initial first response %s on stream with initial request %s.", response, this.initialRequest));
    }

    @Override
    protected void handleStreamResponse(StreamingCommitCursorResponse response) throws CheckedApiException {
        CheckedApiPreconditions.checkState(response.hasCommit(), String.format("Received non-commit subsequent response %s on stream with initial request %s.", response, this.initialRequest));
        CheckedApiPreconditions.checkState(response.getCommit().getAcknowledgedCommits() > 0L, String.format("Received non-positive commit count response %s on stream with initial request %s.", response, this.initialRequest));
        this.sendToClient(response.getCommit());
    }

    @Override
    public void commit(Offset offset) {
        this.sendToStream(StreamingCommitCursorRequest.newBuilder().setCommit(SequencedCommitCursorRequest.newBuilder().setCursor(Cursor.newBuilder().setOffset(offset.value()))).build());
    }

    static class Factory
    implements ConnectedCommitterFactory {
        Factory() {
        }

        @Override
        public ConnectedCommitter New(StreamFactory<StreamingCommitCursorRequest, StreamingCommitCursorResponse> streamFactory, ResponseObserver<SequencedCommitCursorResponse> clientStream, StreamingCommitCursorRequest initialRequest) {
            return new ConnectedCommitterImpl(streamFactory, clientStream, initialRequest, SingleConnection.DEFAULT_STREAM_IDLE_TIMEOUT);
        }
    }
}

