/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.internal.wire.AssignerSettings;
import com.google.cloud.pubsublite.internal.wire.PartitionAssignmentReceiver;
import com.google.cloud.pubsublite.v1.PartitionAssignmentServiceClient;
import java.util.UUID;

final class AutoValue_AssignerSettings
extends AssignerSettings {
    private final SubscriptionPath subscriptionPath;
    private final PartitionAssignmentReceiver receiver;
    private final PartitionAssignmentServiceClient serviceClient;
    private final UUID uuid;

    private AutoValue_AssignerSettings(SubscriptionPath subscriptionPath, PartitionAssignmentReceiver receiver, PartitionAssignmentServiceClient serviceClient, UUID uuid) {
        this.subscriptionPath = subscriptionPath;
        this.receiver = receiver;
        this.serviceClient = serviceClient;
        this.uuid = uuid;
    }

    @Override
    SubscriptionPath subscriptionPath() {
        return this.subscriptionPath;
    }

    @Override
    PartitionAssignmentReceiver receiver() {
        return this.receiver;
    }

    @Override
    PartitionAssignmentServiceClient serviceClient() {
        return this.serviceClient;
    }

    @Override
    UUID uuid() {
        return this.uuid;
    }

    public String toString() {
        return "AssignerSettings{subscriptionPath=" + this.subscriptionPath + ", receiver=" + this.receiver + ", serviceClient=" + this.serviceClient + ", uuid=" + this.uuid + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AssignerSettings) {
            AssignerSettings that = (AssignerSettings)o;
            return this.subscriptionPath.equals(that.subscriptionPath()) && this.receiver.equals(that.receiver()) && this.serviceClient.equals(that.serviceClient()) && this.uuid.equals(that.uuid());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.subscriptionPath.hashCode();
        h$ *= 1000003;
        h$ ^= this.receiver.hashCode();
        h$ *= 1000003;
        h$ ^= this.serviceClient.hashCode();
        h$ *= 1000003;
        return h$ ^= this.uuid.hashCode();
    }

    static final class Builder
    extends AssignerSettings.Builder {
        private SubscriptionPath subscriptionPath;
        private PartitionAssignmentReceiver receiver;
        private PartitionAssignmentServiceClient serviceClient;
        private UUID uuid;

        Builder() {
        }

        @Override
        public AssignerSettings.Builder setSubscriptionPath(SubscriptionPath subscriptionPath) {
            if (subscriptionPath == null) {
                throw new NullPointerException("Null subscriptionPath");
            }
            this.subscriptionPath = subscriptionPath;
            return this;
        }

        @Override
        public AssignerSettings.Builder setReceiver(PartitionAssignmentReceiver receiver) {
            if (receiver == null) {
                throw new NullPointerException("Null receiver");
            }
            this.receiver = receiver;
            return this;
        }

        @Override
        public AssignerSettings.Builder setServiceClient(PartitionAssignmentServiceClient serviceClient) {
            if (serviceClient == null) {
                throw new NullPointerException("Null serviceClient");
            }
            this.serviceClient = serviceClient;
            return this;
        }

        @Override
        public AssignerSettings.Builder setUuid(UUID uuid) {
            if (uuid == null) {
                throw new NullPointerException("Null uuid");
            }
            this.uuid = uuid;
            return this;
        }

        @Override
        public AssignerSettings build() {
            if (this.subscriptionPath == null || this.receiver == null || this.serviceClient == null || this.uuid == null) {
                StringBuilder missing = new StringBuilder();
                if (this.subscriptionPath == null) {
                    missing.append(" subscriptionPath");
                }
                if (this.receiver == null) {
                    missing.append(" receiver");
                }
                if (this.serviceClient == null) {
                    missing.append(" serviceClient");
                }
                if (this.uuid == null) {
                    missing.append(" uuid");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_AssignerSettings(this.subscriptionPath, this.receiver, this.serviceClient, this.uuid);
        }
    }
}

