/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.internal.wire.AutoValue_SerialBatcher_UnbatchedMessage;
import com.google.cloud.pubsublite.proto.PubSubMessage;
import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;

class SerialBatcher {
    private final long byteLimit;
    private final long messageLimit;
    private long byteCount = 0L;
    private Deque<UnbatchedMessage> messages = new ArrayDeque<UnbatchedMessage>();

    SerialBatcher(long byteLimit, long messageLimit) {
        this.byteLimit = byteLimit;
        this.messageLimit = messageLimit;
    }

    ApiFuture<Offset> add(PubSubMessage message) {
        this.byteCount += (long)message.getSerializedSize();
        SettableApiFuture future = SettableApiFuture.create();
        this.messages.add(UnbatchedMessage.of(message, (SettableApiFuture<Offset>)future));
        return future;
    }

    boolean shouldFlush() {
        return this.byteCount >= this.byteLimit || (long)this.messages.size() >= this.messageLimit;
    }

    Collection<UnbatchedMessage> flush() {
        Deque<UnbatchedMessage> toReturn = this.messages;
        this.messages = new ArrayDeque<UnbatchedMessage>();
        while ((this.byteCount > this.byteLimit || (long)toReturn.size() > this.messageLimit) && toReturn.size() > 1) {
            this.messages.addFirst(toReturn.removeLast());
            this.byteCount -= (long)toReturn.peekLast().message().getSerializedSize();
        }
        this.byteCount = this.messages.stream().mapToLong(value -> value.message().getSerializedSize()).sum();
        Preconditions.checkState((this.messages.size() == 1 || this.byteCount <= this.byteLimit && (long)this.messages.size() <= this.messageLimit ? 1 : 0) != 0, (Object)"Postcondition violation in SerialBatcher::flush. The caller is likely not calling flush after calling add.");
        return toReturn;
    }

    @AutoValue
    public static abstract class UnbatchedMessage {
        public abstract PubSubMessage message();

        public abstract SettableApiFuture<Offset> future();

        public static UnbatchedMessage of(PubSubMessage message, SettableApiFuture<Offset> future) {
            return new AutoValue_SerialBatcher_UnbatchedMessage(message, future);
        }
    }
}

