/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.gax.batching.BatchingSettings;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.wire.PublisherBuilder;
import com.google.cloud.pubsublite.internal.wire.SinglePartitionPublisherBuilder;
import com.google.cloud.pubsublite.v1.PublisherServiceClient;

final class AutoValue_SinglePartitionPublisherBuilder
extends SinglePartitionPublisherBuilder {
    private final TopicPath topic;
    private final Partition partition;
    private final PublisherServiceClient serviceClient;
    private final BatchingSettings batchingSettings;
    private final PublisherBuilder.Builder underlyingBuilder;

    private AutoValue_SinglePartitionPublisherBuilder(TopicPath topic, Partition partition, PublisherServiceClient serviceClient, BatchingSettings batchingSettings, PublisherBuilder.Builder underlyingBuilder) {
        this.topic = topic;
        this.partition = partition;
        this.serviceClient = serviceClient;
        this.batchingSettings = batchingSettings;
        this.underlyingBuilder = underlyingBuilder;
    }

    @Override
    TopicPath topic() {
        return this.topic;
    }

    @Override
    Partition partition() {
        return this.partition;
    }

    @Override
    PublisherServiceClient serviceClient() {
        return this.serviceClient;
    }

    @Override
    BatchingSettings batchingSettings() {
        return this.batchingSettings;
    }

    @Override
    PublisherBuilder.Builder underlyingBuilder() {
        return this.underlyingBuilder;
    }

    public String toString() {
        return "SinglePartitionPublisherBuilder{topic=" + this.topic + ", partition=" + this.partition + ", serviceClient=" + this.serviceClient + ", batchingSettings=" + this.batchingSettings + ", underlyingBuilder=" + this.underlyingBuilder + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SinglePartitionPublisherBuilder) {
            SinglePartitionPublisherBuilder that = (SinglePartitionPublisherBuilder)o;
            return this.topic.equals(that.topic()) && this.partition.equals(that.partition()) && this.serviceClient.equals(that.serviceClient()) && this.batchingSettings.equals(that.batchingSettings()) && this.underlyingBuilder.equals(that.underlyingBuilder());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.topic.hashCode();
        h$ *= 1000003;
        h$ ^= this.partition.hashCode();
        h$ *= 1000003;
        h$ ^= this.serviceClient.hashCode();
        h$ *= 1000003;
        h$ ^= this.batchingSettings.hashCode();
        h$ *= 1000003;
        return h$ ^= this.underlyingBuilder.hashCode();
    }

    static final class Builder
    extends SinglePartitionPublisherBuilder.Builder {
        private TopicPath topic;
        private Partition partition;
        private PublisherServiceClient serviceClient;
        private BatchingSettings batchingSettings;
        private PublisherBuilder.Builder underlyingBuilder;

        Builder() {
        }

        @Override
        public SinglePartitionPublisherBuilder.Builder setTopic(TopicPath topic) {
            if (topic == null) {
                throw new NullPointerException("Null topic");
            }
            this.topic = topic;
            return this;
        }

        @Override
        public SinglePartitionPublisherBuilder.Builder setPartition(Partition partition) {
            if (partition == null) {
                throw new NullPointerException("Null partition");
            }
            this.partition = partition;
            return this;
        }

        @Override
        public SinglePartitionPublisherBuilder.Builder setServiceClient(PublisherServiceClient serviceClient) {
            if (serviceClient == null) {
                throw new NullPointerException("Null serviceClient");
            }
            this.serviceClient = serviceClient;
            return this;
        }

        @Override
        public SinglePartitionPublisherBuilder.Builder setBatchingSettings(BatchingSettings batchingSettings) {
            if (batchingSettings == null) {
                throw new NullPointerException("Null batchingSettings");
            }
            this.batchingSettings = batchingSettings;
            return this;
        }

        @Override
        SinglePartitionPublisherBuilder.Builder setUnderlyingBuilder(PublisherBuilder.Builder underlyingBuilder) {
            if (underlyingBuilder == null) {
                throw new NullPointerException("Null underlyingBuilder");
            }
            this.underlyingBuilder = underlyingBuilder;
            return this;
        }

        @Override
        SinglePartitionPublisherBuilder autoBuild() {
            if (this.topic == null || this.partition == null || this.serviceClient == null || this.batchingSettings == null || this.underlyingBuilder == null) {
                StringBuilder missing = new StringBuilder();
                if (this.topic == null) {
                    missing.append(" topic");
                }
                if (this.partition == null) {
                    missing.append(" partition");
                }
                if (this.serviceClient == null) {
                    missing.append(" serviceClient");
                }
                if (this.batchingSettings == null) {
                    missing.append(" batchingSettings");
                }
                if (this.underlyingBuilder == null) {
                    missing.append(" underlyingBuilder");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SinglePartitionPublisherBuilder(this.topic, this.partition, this.serviceClient, this.batchingSettings, this.underlyingBuilder);
        }
    }
}

