/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.testing;

import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.CloudZone;
import com.google.cloud.pubsublite.LocationPath;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.ProjectNumber;
import com.google.cloud.pubsublite.ReservationName;
import com.google.cloud.pubsublite.ReservationPath;
import com.google.cloud.pubsublite.SubscriptionName;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.TopicName;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.proto.Reservation;
import com.google.cloud.pubsublite.proto.Subscription;
import com.google.cloud.pubsublite.proto.Topic;
import com.google.common.base.Preconditions;
import com.google.common.reflect.ImmutableTypeToInstanceMap;
import com.google.protobuf.util.Durations;

public final class UnitTestExamples {
    private static final ImmutableTypeToInstanceMap<Object> MAP = ImmutableTypeToInstanceMap.builder().put(Partition.class, (Object)UnitTestExamples.examplePartition()).put(CloudRegion.class, (Object)UnitTestExamples.exampleRegion()).put(CloudZone.class, (Object)UnitTestExamples.exampleZone()).put(ProjectNumber.class, (Object)UnitTestExamples.exampleProjectNumber()).put(TopicName.class, (Object)UnitTestExamples.exampleTopicName()).put(TopicPath.class, (Object)UnitTestExamples.exampleTopicPath()).put(Topic.class, (Object)UnitTestExamples.exampleTopic()).put(SubscriptionName.class, (Object)UnitTestExamples.exampleSubscriptionName()).put(SubscriptionPath.class, (Object)UnitTestExamples.exampleSubscriptionPath()).put(Subscription.class, (Object)UnitTestExamples.exampleSubscription()).put(ReservationName.class, (Object)UnitTestExamples.exampleReservationName()).put(ReservationPath.class, (Object)UnitTestExamples.exampleReservationPath()).put(Reservation.class, (Object)UnitTestExamples.exampleReservation()).put(LocationPath.class, (Object)UnitTestExamples.exampleLocationPath()).put(Offset.class, (Object)UnitTestExamples.exampleOffset()).build();

    private UnitTestExamples() {
    }

    public static <T> T example(Class<T> klass) {
        Object instance = MAP.getInstance(klass);
        Preconditions.checkNotNull((Object)instance);
        return (T)instance;
    }

    public static Partition examplePartition() {
        return Partition.of(33L);
    }

    public static CloudRegion exampleRegion() {
        return CloudRegion.of("europe-fake2");
    }

    public static CloudZone exampleZone() {
        return CloudZone.of(UnitTestExamples.exampleRegion(), 'z');
    }

    public static ProjectNumber exampleProjectNumber() {
        return ProjectNumber.of(3298749273L);
    }

    public static TopicName exampleTopicName() {
        return TopicName.of("example-topic");
    }

    public static TopicPath exampleTopicPath() {
        return ((TopicPath.Builder)TopicPath.newBuilder().setProject(UnitTestExamples.exampleProjectNumber())).setLocation(UnitTestExamples.exampleZone()).setName(UnitTestExamples.exampleTopicName()).build();
    }

    public static Topic exampleTopic() {
        return Topic.newBuilder().setName(UnitTestExamples.exampleTopicPath().toString()).setPartitionConfig(Topic.PartitionConfig.newBuilder().setCount(10L)).setRetentionConfig(Topic.RetentionConfig.newBuilder().setPeriod(Durations.fromDays((long)1L))).build();
    }

    public static SubscriptionName exampleSubscriptionName() {
        return SubscriptionName.of("example-subscription");
    }

    public static SubscriptionPath exampleSubscriptionPath() {
        return ((SubscriptionPath.Builder)SubscriptionPath.newBuilder().setProject(UnitTestExamples.exampleProjectNumber())).setLocation(UnitTestExamples.exampleZone()).setName(UnitTestExamples.exampleSubscriptionName()).build();
    }

    public static Subscription exampleSubscription() {
        return Subscription.newBuilder().setDeliveryConfig(Subscription.DeliveryConfig.newBuilder().setDeliveryRequirement(Subscription.DeliveryConfig.DeliveryRequirement.DELIVER_AFTER_STORED)).setName(UnitTestExamples.exampleSubscriptionPath().toString()).setTopic(UnitTestExamples.exampleTopicPath().toString()).build();
    }

    public static ReservationName exampleReservationName() {
        return ReservationName.of("example-reservation");
    }

    public static ReservationPath exampleReservationPath() {
        return ((ReservationPath.Builder)ReservationPath.newBuilder().setProject(UnitTestExamples.exampleProjectNumber())).setLocation(UnitTestExamples.exampleRegion()).setName(UnitTestExamples.exampleReservationName()).build();
    }

    public static Reservation exampleReservation() {
        return Reservation.newBuilder().setName(UnitTestExamples.exampleReservationPath().toString()).setThroughputCapacity(423597L).build();
    }

    public static LocationPath exampleLocationPath() {
        return ((LocationPath.Builder)((LocationPath.Builder)LocationPath.newBuilder().setProject(UnitTestExamples.exampleProjectNumber())).setLocation(UnitTestExamples.exampleZone())).build();
    }

    public static Offset exampleOffset() {
        return Offset.of(9827340L);
    }
}

