/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.cloudpubsub.internal;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsub.v1.AckReplyConsumer;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.cloud.pubsublite.MessageTransformer;
import com.google.cloud.pubsublite.SequencedMessage;
import com.google.cloud.pubsublite.cloudpubsub.FlowControlSettings;
import com.google.cloud.pubsublite.cloudpubsub.NackHandler;
import com.google.cloud.pubsublite.cloudpubsub.Subscriber;
import com.google.cloud.pubsublite.cloudpubsub.internal.AckSetTracker;
import com.google.cloud.pubsublite.cloudpubsub.internal.ResettableSubscriberFactory;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.ProxyService;
import com.google.cloud.pubsublite.internal.wire.SystemExecutors;
import com.google.cloud.pubsublite.proto.FlowControlRequest;
import com.google.common.annotations.VisibleForTesting;
import com.google.pubsub.v1.PubsubMessage;
import java.util.List;
import java.util.concurrent.Executor;

public class SinglePartitionSubscriber
extends ProxyService
implements Subscriber {
    private final MessageReceiver receiver;
    private final MessageTransformer<SequencedMessage, PubsubMessage> transformer;
    private final AckSetTracker ackSetTracker;
    private final NackHandler nackHandler;
    private final FlowControlSettings flowControlSettings;
    private final com.google.cloud.pubsublite.internal.wire.Subscriber wireSubscriber;

    public SinglePartitionSubscriber(MessageReceiver receiver, MessageTransformer<SequencedMessage, PubsubMessage> transformer, AckSetTracker ackSetTracker, NackHandler nackHandler, ResettableSubscriberFactory wireSubscriberFactory, FlowControlSettings flowControlSettings) throws ApiException {
        this.receiver = receiver;
        this.transformer = transformer;
        this.ackSetTracker = ackSetTracker;
        this.nackHandler = nackHandler;
        this.flowControlSettings = flowControlSettings;
        this.wireSubscriber = wireSubscriberFactory.newSubscriber(this::onMessages, this::onSubscriberReset);
        this.addServices(ackSetTracker, this.wireSubscriber);
    }

    @Override
    protected void handlePermanentError(CheckedApiException error) {
    }

    @Override
    protected void start() throws CheckedApiException {
        this.wireSubscriber.allowFlow(FlowControlRequest.newBuilder().setAllowedMessages(this.flowControlSettings.messagesOutstanding()).setAllowedBytes(this.flowControlSettings.bytesOutstanding()).build());
    }

    @Override
    protected void stop() {
    }

    @VisibleForTesting
    void onMessages(List<SequencedMessage> sequencedMessages) {
        try {
            for (SequencedMessage message : sequencedMessages) {
                final PubsubMessage userMessage = this.transformer.transform(message);
                final long bytes = message.byteSize();
                final Runnable trackerConsumer = this.ackSetTracker.track(message);
                AckReplyConsumer clientConsumer = new AckReplyConsumer(){

                    public void ack() {
                        trackerConsumer.run();
                        try {
                            SinglePartitionSubscriber.this.wireSubscriber.allowFlow(FlowControlRequest.newBuilder().setAllowedMessages(1L).setAllowedBytes(bytes).build());
                        }
                        catch (CheckedApiException e) {
                            SinglePartitionSubscriber.this.onPermanentError(e);
                        }
                    }

                    public void nack() {
                        ApiFuture<Void> nackDone = SinglePartitionSubscriber.this.nackHandler.nack(userMessage);
                        ApiFutures.addCallback(nackDone, (ApiFutureCallback)new ApiFutureCallback<Void>(){

                            public void onFailure(Throwable t) {
                                SinglePartitionSubscriber.this.onPermanentError(ExtractStatus.toCanonical(t));
                            }

                            public void onSuccess(Void result) {
                                this.ack();
                            }
                        }, (Executor)SystemExecutors.getFuturesExecutor());
                    }
                };
                this.receiver.receiveMessage(userMessage, clientConsumer);
            }
        }
        catch (Throwable t) {
            this.onPermanentError(ExtractStatus.toCanonical(t));
        }
    }

    @VisibleForTesting
    boolean onSubscriberReset() throws CheckedApiException {
        this.ackSetTracker.waitUntilCommitted();
        return true;
    }
}

