/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite;

import com.google.api.gax.rpc.ApiException;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.AutoValue_ProjectPath;
import com.google.cloud.pubsublite.ProjectBuilderHelper;
import com.google.cloud.pubsublite.ProjectId;
import com.google.cloud.pubsublite.ProjectIdOrNumber;
import com.google.cloud.pubsublite.ProjectNumber;
import com.google.cloud.pubsublite.internal.UncheckedApiPreconditions;
import java.io.Serializable;

@AutoValue
public abstract class ProjectPath
implements Serializable {
    public abstract ProjectIdOrNumber project();

    public String toString() {
        return "projects/" + this.project();
    }

    public static Builder newBuilder() {
        return new AutoValue_ProjectPath.Builder();
    }

    public abstract Builder toBuilder();

    public static ProjectPath parse(String path) throws ApiException {
        String[] splits = path.split("/");
        UncheckedApiPreconditions.checkArgument(splits.length == 2);
        UncheckedApiPreconditions.checkArgument(splits[0].equals("projects"));
        UncheckedApiPreconditions.checkArgument(!splits[1].isEmpty());
        try {
            long val = Long.parseLong(splits[1]);
            return ((Builder)ProjectPath.newBuilder().setProject(ProjectNumber.of(val))).build();
        }
        catch (NumberFormatException numberFormatException) {
            return ((Builder)ProjectPath.newBuilder().setProject(ProjectId.of(splits[1]))).build();
        }
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends ProjectBuilderHelper<Builder> {
        public abstract ProjectPath build();
    }
}

