package com.google.cloud.pubsublite.internal.wire;

import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.TopicPath;
import java.time.Duration;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_PartitionCountWatchingPublisherSettings extends PartitionCountWatchingPublisherSettings {

  private final TopicPath topic;

  private final PartitionPublisherFactory publisherFactory;

  private final AdminClient adminClient;

  private final Duration configPollPeriod;

  private AutoValue_PartitionCountWatchingPublisherSettings(
      TopicPath topic,
      PartitionPublisherFactory publisherFactory,
      AdminClient adminClient,
      Duration configPollPeriod) {
    this.topic = topic;
    this.publisherFactory = publisherFactory;
    this.adminClient = adminClient;
    this.configPollPeriod = configPollPeriod;
  }

  @Override
  TopicPath topic() {
    return topic;
  }

  @Override
  PartitionPublisherFactory publisherFactory() {
    return publisherFactory;
  }

  @Override
  AdminClient adminClient() {
    return adminClient;
  }

  @Override
  Duration configPollPeriod() {
    return configPollPeriod;
  }

  @Override
  public String toString() {
    return "PartitionCountWatchingPublisherSettings{"
        + "topic=" + topic + ", "
        + "publisherFactory=" + publisherFactory + ", "
        + "adminClient=" + adminClient + ", "
        + "configPollPeriod=" + configPollPeriod
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof PartitionCountWatchingPublisherSettings) {
      PartitionCountWatchingPublisherSettings that = (PartitionCountWatchingPublisherSettings) o;
      return this.topic.equals(that.topic())
          && this.publisherFactory.equals(that.publisherFactory())
          && this.adminClient.equals(that.adminClient())
          && this.configPollPeriod.equals(that.configPollPeriod());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= topic.hashCode();
    h$ *= 1000003;
    h$ ^= publisherFactory.hashCode();
    h$ *= 1000003;
    h$ ^= adminClient.hashCode();
    h$ *= 1000003;
    h$ ^= configPollPeriod.hashCode();
    return h$;
  }

  static final class Builder extends PartitionCountWatchingPublisherSettings.Builder {
    private TopicPath topic;
    private PartitionPublisherFactory publisherFactory;
    private AdminClient adminClient;
    private Duration configPollPeriod;
    Builder() {
    }
    @Override
    public PartitionCountWatchingPublisherSettings.Builder setTopic(TopicPath topic) {
      if (topic == null) {
        throw new NullPointerException("Null topic");
      }
      this.topic = topic;
      return this;
    }
    @Override
    public PartitionCountWatchingPublisherSettings.Builder setPublisherFactory(PartitionPublisherFactory publisherFactory) {
      if (publisherFactory == null) {
        throw new NullPointerException("Null publisherFactory");
      }
      this.publisherFactory = publisherFactory;
      return this;
    }
    @Override
    public PartitionCountWatchingPublisherSettings.Builder setAdminClient(AdminClient adminClient) {
      if (adminClient == null) {
        throw new NullPointerException("Null adminClient");
      }
      this.adminClient = adminClient;
      return this;
    }
    @Override
    public PartitionCountWatchingPublisherSettings.Builder setConfigPollPeriod(Duration configPollPeriod) {
      if (configPollPeriod == null) {
        throw new NullPointerException("Null configPollPeriod");
      }
      this.configPollPeriod = configPollPeriod;
      return this;
    }
    @Override
    public PartitionCountWatchingPublisherSettings build() {
      if (this.topic == null
          || this.publisherFactory == null
          || this.adminClient == null
          || this.configPollPeriod == null) {
        StringBuilder missing = new StringBuilder();
        if (this.topic == null) {
          missing.append(" topic");
        }
        if (this.publisherFactory == null) {
          missing.append(" publisherFactory");
        }
        if (this.adminClient == null) {
          missing.append(" adminClient");
        }
        if (this.configPollPeriod == null) {
          missing.append(" configPollPeriod");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_PartitionCountWatchingPublisherSettings(
          this.topic,
          this.publisherFactory,
          this.adminClient,
          this.configPollPeriod);
    }
  }

}
