/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.pubsublite.proto.CreateSubscriptionRequest;
import com.google.cloud.pubsublite.proto.CreateTopicRequest;
import com.google.cloud.pubsublite.proto.DeleteSubscriptionRequest;
import com.google.cloud.pubsublite.proto.DeleteTopicRequest;
import com.google.cloud.pubsublite.proto.GetSubscriptionRequest;
import com.google.cloud.pubsublite.proto.GetTopicPartitionsRequest;
import com.google.cloud.pubsublite.proto.GetTopicRequest;
import com.google.cloud.pubsublite.proto.ListSubscriptionsRequest;
import com.google.cloud.pubsublite.proto.ListSubscriptionsResponse;
import com.google.cloud.pubsublite.proto.ListTopicSubscriptionsRequest;
import com.google.cloud.pubsublite.proto.ListTopicSubscriptionsResponse;
import com.google.cloud.pubsublite.proto.ListTopicsRequest;
import com.google.cloud.pubsublite.proto.ListTopicsResponse;
import com.google.cloud.pubsublite.proto.LocationName;
import com.google.cloud.pubsublite.proto.Subscription;
import com.google.cloud.pubsublite.proto.SubscriptionName;
import com.google.cloud.pubsublite.proto.Topic;
import com.google.cloud.pubsublite.proto.TopicName;
import com.google.cloud.pubsublite.proto.TopicPartitions;
import com.google.cloud.pubsublite.proto.UpdateSubscriptionRequest;
import com.google.cloud.pubsublite.proto.UpdateTopicRequest;
import com.google.cloud.pubsublite.v1.AdminServiceSettings;
import com.google.cloud.pubsublite.v1.stub.AdminServiceStub;
import com.google.cloud.pubsublite.v1.stub.AdminServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class AdminServiceClient
implements BackgroundResource {
    private final AdminServiceSettings settings;
    private final AdminServiceStub stub;

    public static final AdminServiceClient create() throws IOException {
        return AdminServiceClient.create(AdminServiceSettings.newBuilder().build());
    }

    public static final AdminServiceClient create(AdminServiceSettings settings) throws IOException {
        return new AdminServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final AdminServiceClient create(AdminServiceStub stub) {
        return new AdminServiceClient(stub);
    }

    protected AdminServiceClient(AdminServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AdminServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected AdminServiceClient(AdminServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AdminServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AdminServiceStub getStub() {
        return this.stub;
    }

    public final Topic createTopic(LocationName parent, Topic topic, String topicId) {
        CreateTopicRequest request = CreateTopicRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTopic(topic).setTopicId(topicId).build();
        return this.createTopic(request);
    }

    public final Topic createTopic(String parent, Topic topic, String topicId) {
        CreateTopicRequest request = CreateTopicRequest.newBuilder().setParent(parent).setTopic(topic).setTopicId(topicId).build();
        return this.createTopic(request);
    }

    public final Topic createTopic(CreateTopicRequest request) {
        return (Topic)this.createTopicCallable().call((Object)request);
    }

    public final UnaryCallable<CreateTopicRequest, Topic> createTopicCallable() {
        return this.stub.createTopicCallable();
    }

    public final Topic getTopic(TopicName name) {
        GetTopicRequest request = GetTopicRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTopic(request);
    }

    public final Topic getTopic(String name) {
        GetTopicRequest request = GetTopicRequest.newBuilder().setName(name).build();
        return this.getTopic(request);
    }

    public final Topic getTopic(GetTopicRequest request) {
        return (Topic)this.getTopicCallable().call((Object)request);
    }

    public final UnaryCallable<GetTopicRequest, Topic> getTopicCallable() {
        return this.stub.getTopicCallable();
    }

    public final TopicPartitions getTopicPartitions(TopicName name) {
        GetTopicPartitionsRequest request = GetTopicPartitionsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTopicPartitions(request);
    }

    public final TopicPartitions getTopicPartitions(String name) {
        GetTopicPartitionsRequest request = GetTopicPartitionsRequest.newBuilder().setName(name).build();
        return this.getTopicPartitions(request);
    }

    public final TopicPartitions getTopicPartitions(GetTopicPartitionsRequest request) {
        return (TopicPartitions)this.getTopicPartitionsCallable().call((Object)request);
    }

    public final UnaryCallable<GetTopicPartitionsRequest, TopicPartitions> getTopicPartitionsCallable() {
        return this.stub.getTopicPartitionsCallable();
    }

    public final ListTopicsPagedResponse listTopics(LocationName parent) {
        ListTopicsRequest request = ListTopicsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTopics(request);
    }

    public final ListTopicsPagedResponse listTopics(String parent) {
        ListTopicsRequest request = ListTopicsRequest.newBuilder().setParent(parent).build();
        return this.listTopics(request);
    }

    public final ListTopicsPagedResponse listTopics(ListTopicsRequest request) {
        return (ListTopicsPagedResponse)((Object)this.listTopicsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTopicsRequest, ListTopicsPagedResponse> listTopicsPagedCallable() {
        return this.stub.listTopicsPagedCallable();
    }

    public final UnaryCallable<ListTopicsRequest, ListTopicsResponse> listTopicsCallable() {
        return this.stub.listTopicsCallable();
    }

    public final Topic updateTopic(Topic topic, FieldMask updateMask) {
        UpdateTopicRequest request = UpdateTopicRequest.newBuilder().setTopic(topic).setUpdateMask(updateMask).build();
        return this.updateTopic(request);
    }

    public final Topic updateTopic(UpdateTopicRequest request) {
        return (Topic)this.updateTopicCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateTopicRequest, Topic> updateTopicCallable() {
        return this.stub.updateTopicCallable();
    }

    public final void deleteTopic(TopicName name) {
        DeleteTopicRequest request = DeleteTopicRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteTopic(request);
    }

    public final void deleteTopic(String name) {
        DeleteTopicRequest request = DeleteTopicRequest.newBuilder().setName(name).build();
        this.deleteTopic(request);
    }

    public final void deleteTopic(DeleteTopicRequest request) {
        this.deleteTopicCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteTopicRequest, Empty> deleteTopicCallable() {
        return this.stub.deleteTopicCallable();
    }

    public final ListTopicSubscriptionsPagedResponse listTopicSubscriptions(TopicName name) {
        ListTopicSubscriptionsRequest request = ListTopicSubscriptionsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.listTopicSubscriptions(request);
    }

    public final ListTopicSubscriptionsPagedResponse listTopicSubscriptions(String name) {
        ListTopicSubscriptionsRequest request = ListTopicSubscriptionsRequest.newBuilder().setName(name).build();
        return this.listTopicSubscriptions(request);
    }

    public final ListTopicSubscriptionsPagedResponse listTopicSubscriptions(ListTopicSubscriptionsRequest request) {
        return (ListTopicSubscriptionsPagedResponse)((Object)this.listTopicSubscriptionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTopicSubscriptionsRequest, ListTopicSubscriptionsPagedResponse> listTopicSubscriptionsPagedCallable() {
        return this.stub.listTopicSubscriptionsPagedCallable();
    }

    public final UnaryCallable<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse> listTopicSubscriptionsCallable() {
        return this.stub.listTopicSubscriptionsCallable();
    }

    public final Subscription createSubscription(LocationName parent, Subscription subscription, String subscriptionId) {
        CreateSubscriptionRequest request = CreateSubscriptionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSubscription(subscription).setSubscriptionId(subscriptionId).build();
        return this.createSubscription(request);
    }

    public final Subscription createSubscription(String parent, Subscription subscription, String subscriptionId) {
        CreateSubscriptionRequest request = CreateSubscriptionRequest.newBuilder().setParent(parent).setSubscription(subscription).setSubscriptionId(subscriptionId).build();
        return this.createSubscription(request);
    }

    public final Subscription createSubscription(CreateSubscriptionRequest request) {
        return (Subscription)this.createSubscriptionCallable().call((Object)request);
    }

    public final UnaryCallable<CreateSubscriptionRequest, Subscription> createSubscriptionCallable() {
        return this.stub.createSubscriptionCallable();
    }

    public final Subscription getSubscription(SubscriptionName name) {
        GetSubscriptionRequest request = GetSubscriptionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSubscription(request);
    }

    public final Subscription getSubscription(String name) {
        GetSubscriptionRequest request = GetSubscriptionRequest.newBuilder().setName(name).build();
        return this.getSubscription(request);
    }

    public final Subscription getSubscription(GetSubscriptionRequest request) {
        return (Subscription)this.getSubscriptionCallable().call((Object)request);
    }

    public final UnaryCallable<GetSubscriptionRequest, Subscription> getSubscriptionCallable() {
        return this.stub.getSubscriptionCallable();
    }

    public final ListSubscriptionsPagedResponse listSubscriptions(LocationName parent) {
        ListSubscriptionsRequest request = ListSubscriptionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSubscriptions(request);
    }

    public final ListSubscriptionsPagedResponse listSubscriptions(String parent) {
        ListSubscriptionsRequest request = ListSubscriptionsRequest.newBuilder().setParent(parent).build();
        return this.listSubscriptions(request);
    }

    public final ListSubscriptionsPagedResponse listSubscriptions(ListSubscriptionsRequest request) {
        return (ListSubscriptionsPagedResponse)((Object)this.listSubscriptionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSubscriptionsRequest, ListSubscriptionsPagedResponse> listSubscriptionsPagedCallable() {
        return this.stub.listSubscriptionsPagedCallable();
    }

    public final UnaryCallable<ListSubscriptionsRequest, ListSubscriptionsResponse> listSubscriptionsCallable() {
        return this.stub.listSubscriptionsCallable();
    }

    public final Subscription updateSubscription(Subscription subscription, FieldMask updateMask) {
        UpdateSubscriptionRequest request = UpdateSubscriptionRequest.newBuilder().setSubscription(subscription).setUpdateMask(updateMask).build();
        return this.updateSubscription(request);
    }

    public final Subscription updateSubscription(UpdateSubscriptionRequest request) {
        return (Subscription)this.updateSubscriptionCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSubscriptionRequest, Subscription> updateSubscriptionCallable() {
        return this.stub.updateSubscriptionCallable();
    }

    public final void deleteSubscription(SubscriptionName name) {
        DeleteSubscriptionRequest request = DeleteSubscriptionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteSubscription(request);
    }

    public final void deleteSubscription(String name) {
        DeleteSubscriptionRequest request = DeleteSubscriptionRequest.newBuilder().setName(name).build();
        this.deleteSubscription(request);
    }

    public final void deleteSubscription(DeleteSubscriptionRequest request) {
        this.deleteSubscriptionCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSubscriptionRequest, Empty> deleteSubscriptionCallable() {
        return this.stub.deleteSubscriptionCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListSubscriptionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription, ListSubscriptionsPage, ListSubscriptionsFixedSizeCollection> {
        private ListSubscriptionsFixedSizeCollection(List<ListSubscriptionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSubscriptionsFixedSizeCollection createEmptyCollection() {
            return new ListSubscriptionsFixedSizeCollection(null, 0);
        }

        protected ListSubscriptionsFixedSizeCollection createCollection(List<ListSubscriptionsPage> pages, int collectionSize) {
            return new ListSubscriptionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSubscriptionsPage
    extends AbstractPage<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription, ListSubscriptionsPage> {
        private ListSubscriptionsPage(PageContext<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription> context, ListSubscriptionsResponse response) {
            super(context, (Object)response);
        }

        private static ListSubscriptionsPage createEmptyPage() {
            return new ListSubscriptionsPage(null, null);
        }

        protected ListSubscriptionsPage createPage(PageContext<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription> context, ListSubscriptionsResponse response) {
            return new ListSubscriptionsPage(context, response);
        }

        public ApiFuture<ListSubscriptionsPage> createPageAsync(PageContext<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription> context, ApiFuture<ListSubscriptionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSubscriptionsPagedResponse
    extends AbstractPagedListResponse<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription, ListSubscriptionsPage, ListSubscriptionsFixedSizeCollection> {
        public static ApiFuture<ListSubscriptionsPagedResponse> createAsync(PageContext<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription> context, ApiFuture<ListSubscriptionsResponse> futureResponse) {
            ApiFuture<ListSubscriptionsPage> futurePage = ListSubscriptionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListSubscriptionsPage, ListSubscriptionsPagedResponse>(){

                public ListSubscriptionsPagedResponse apply(ListSubscriptionsPage input) {
                    return new ListSubscriptionsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListSubscriptionsPagedResponse(ListSubscriptionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSubscriptionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListTopicSubscriptionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String, ListTopicSubscriptionsPage, ListTopicSubscriptionsFixedSizeCollection> {
        private ListTopicSubscriptionsFixedSizeCollection(List<ListTopicSubscriptionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTopicSubscriptionsFixedSizeCollection createEmptyCollection() {
            return new ListTopicSubscriptionsFixedSizeCollection(null, 0);
        }

        protected ListTopicSubscriptionsFixedSizeCollection createCollection(List<ListTopicSubscriptionsPage> pages, int collectionSize) {
            return new ListTopicSubscriptionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTopicSubscriptionsPage
    extends AbstractPage<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String, ListTopicSubscriptionsPage> {
        private ListTopicSubscriptionsPage(PageContext<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String> context, ListTopicSubscriptionsResponse response) {
            super(context, (Object)response);
        }

        private static ListTopicSubscriptionsPage createEmptyPage() {
            return new ListTopicSubscriptionsPage(null, null);
        }

        protected ListTopicSubscriptionsPage createPage(PageContext<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String> context, ListTopicSubscriptionsResponse response) {
            return new ListTopicSubscriptionsPage(context, response);
        }

        public ApiFuture<ListTopicSubscriptionsPage> createPageAsync(PageContext<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String> context, ApiFuture<ListTopicSubscriptionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTopicSubscriptionsPagedResponse
    extends AbstractPagedListResponse<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String, ListTopicSubscriptionsPage, ListTopicSubscriptionsFixedSizeCollection> {
        public static ApiFuture<ListTopicSubscriptionsPagedResponse> createAsync(PageContext<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String> context, ApiFuture<ListTopicSubscriptionsResponse> futureResponse) {
            ApiFuture<ListTopicSubscriptionsPage> futurePage = ListTopicSubscriptionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListTopicSubscriptionsPage, ListTopicSubscriptionsPagedResponse>(){

                public ListTopicSubscriptionsPagedResponse apply(ListTopicSubscriptionsPage input) {
                    return new ListTopicSubscriptionsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListTopicSubscriptionsPagedResponse(ListTopicSubscriptionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTopicSubscriptionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListTopicsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTopicsRequest, ListTopicsResponse, Topic, ListTopicsPage, ListTopicsFixedSizeCollection> {
        private ListTopicsFixedSizeCollection(List<ListTopicsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTopicsFixedSizeCollection createEmptyCollection() {
            return new ListTopicsFixedSizeCollection(null, 0);
        }

        protected ListTopicsFixedSizeCollection createCollection(List<ListTopicsPage> pages, int collectionSize) {
            return new ListTopicsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTopicsPage
    extends AbstractPage<ListTopicsRequest, ListTopicsResponse, Topic, ListTopicsPage> {
        private ListTopicsPage(PageContext<ListTopicsRequest, ListTopicsResponse, Topic> context, ListTopicsResponse response) {
            super(context, (Object)response);
        }

        private static ListTopicsPage createEmptyPage() {
            return new ListTopicsPage(null, null);
        }

        protected ListTopicsPage createPage(PageContext<ListTopicsRequest, ListTopicsResponse, Topic> context, ListTopicsResponse response) {
            return new ListTopicsPage(context, response);
        }

        public ApiFuture<ListTopicsPage> createPageAsync(PageContext<ListTopicsRequest, ListTopicsResponse, Topic> context, ApiFuture<ListTopicsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTopicsPagedResponse
    extends AbstractPagedListResponse<ListTopicsRequest, ListTopicsResponse, Topic, ListTopicsPage, ListTopicsFixedSizeCollection> {
        public static ApiFuture<ListTopicsPagedResponse> createAsync(PageContext<ListTopicsRequest, ListTopicsResponse, Topic> context, ApiFuture<ListTopicsResponse> futureResponse) {
            ApiFuture<ListTopicsPage> futurePage = ListTopicsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListTopicsPage, ListTopicsPagedResponse>(){

                public ListTopicsPagedResponse apply(ListTopicsPage input) {
                    return new ListTopicsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListTopicsPagedResponse(ListTopicsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTopicsFixedSizeCollection.createEmptyCollection());
        }
    }
}

