/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.gax.rpc.ApiException;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.PartitionLookupUtils;
import com.google.cloud.pubsublite.PublishMetadata;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.DefaultRoutingPolicy;
import com.google.cloud.pubsublite.internal.Publisher;
import com.google.cloud.pubsublite.internal.wire.AutoValue_RoutingPublisherBuilder;
import com.google.cloud.pubsublite.internal.wire.PartitionPublisherFactory;
import com.google.cloud.pubsublite.internal.wire.RoutingPublisher;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;

@AutoValue
public abstract class RoutingPublisherBuilder {
    abstract TopicPath topic();

    abstract PartitionPublisherFactory publisherFactory();

    abstract Optional<Integer> numPartitions();

    public static Builder newBuilder() {
        return new AutoValue_RoutingPublisherBuilder.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setTopic(TopicPath var1);

        public abstract Builder setPublisherFactory(PartitionPublisherFactory var1);

        public abstract Builder setNumPartitions(Integer var1);

        abstract RoutingPublisherBuilder autoBuild();

        public Publisher<PublishMetadata> build() throws ApiException {
            RoutingPublisherBuilder builder = this.autoBuild();
            int numPartitions = builder.numPartitions().isPresent() ? builder.numPartitions().get() : PartitionLookupUtils.numPartitions(builder.topic());
            ImmutableMap.Builder publisherMapBuilder = ImmutableMap.builder();
            for (int i = 0; i < numPartitions; ++i) {
                publisherMapBuilder.put((Object)Partition.of(i), builder.publisherFactory().newPublisher(Partition.of(i)));
            }
            return new RoutingPublisher((Map<Partition, Publisher<PublishMetadata>>)publisherMapBuilder.build(), new DefaultRoutingPolicy(numPartitions));
        }
    }
}

